/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcHttpClientConfig;
import org.apache.xmlrpc.client.XmlRpcHttpTransport;
import org.apache.xmlrpc.client.XmlRpcStreamTransport;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.util.HttpUtil;
import org.xml.sax.SAXException;

public class XmlRpcSunHttpTransport
extends XmlRpcHttpTransport {
    private static final String userAgent = "Apache XML RPC 3.0 (Sun HTTP Transport)";
    private URLConnection conn;

    public XmlRpcSunHttpTransport(XmlRpcClient pClient) {
        super(pClient, userAgent);
    }

    protected URLConnection newURLConnection(URL pURL) throws IOException {
        return pURL.openConnection();
    }

    public Object sendRequest(XmlRpcRequest pRequest) throws XmlRpcException {
        XmlRpcHttpClientConfig config = (XmlRpcHttpClientConfig)pRequest.getConfig();
        try {
            this.conn = this.newURLConnection(config.getServerURL());
            this.conn.setUseCaches(false);
            this.conn.setDoInput(true);
            this.conn.setDoOutput(true);
        }
        catch (IOException e) {
            throw new XmlRpcException("Failed to create URLConnection: " + e.getMessage(), e);
        }
        return super.sendRequest(pRequest);
    }

    protected void setRequestHeader(String pHeader, String pValue) {
        this.conn.setRequestProperty(pHeader, pValue);
    }

    protected void close() throws XmlRpcClientException {
        if (this.conn instanceof HttpURLConnection) {
            ((HttpURLConnection)this.conn).disconnect();
        }
    }

    protected boolean isResponseGzipCompressed(XmlRpcStreamRequestConfig pConfig) {
        return HttpUtil.isUsingGzipEncoding(this.conn.getHeaderField("Content-Encoding"));
    }

    protected InputStream getInputStream() throws XmlRpcException {
        try {
            return this.conn.getInputStream();
        }
        catch (IOException e) {
            throw new XmlRpcException("Failed to create input stream: " + e.getMessage(), e);
        }
    }

    protected void writeRequest(XmlRpcStreamTransport.ReqWriter pWriter) throws IOException, XmlRpcException, SAXException {
        pWriter.write(this.conn.getOutputStream());
    }
}

