/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.collab.calendar;

import com.day.cq.collab.calendar.CqCalendar;
import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateGroup;
import java.util.Arrays;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CalendarComponent {
    private static final Logger log = LoggerFactory.getLogger(CalendarComponent.class);
    public static final String PN_SUBSCRIPTIONS = "subscriptions";
    private final Resource resource;
    private ValueMap props;
    private Node node;

    public CalendarComponent(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public ValueMap getProps() {
        if (this.props == null) {
            this.props = (ValueMap)this.resource.adaptTo(ValueMap.class);
        }
        return this.props;
    }

    public Node getNode() {
        if (this.node == null) {
            this.node = (Node)this.resource.adaptTo(Node.class);
        }
        return this.node;
    }

    public String[] getSubscriptions() {
        String[] subs = (String[])this.getProps().get(PN_SUBSCRIPTIONS, String[].class);
        if (subs == null) {
            return new String[0];
        }
        return subs;
    }

    public void setSubscriptions(String[] subscriptions) {
        Node node = this.getNode();
        try {
            if (node.hasProperty(PN_SUBSCRIPTIONS)) {
                node.getProperty(PN_SUBSCRIPTIONS).remove();
            }
            node.setProperty(PN_SUBSCRIPTIONS, subscriptions);
            node.save();
        }
        catch (RepositoryException e) {
            log.error("Calendar component '" + this.resource.getPath() + "': could not update subscriptions", (Throwable)e);
        }
    }

    public void subscribeTo(String path) {
        Object[] subscriptions = this.getSubscriptions();
        if (subscriptions == null || Arrays.binarySearch(subscriptions, path) < 0) {
            this.setSubscriptions((String[])ArrayUtils.add((Object[])subscriptions, (Object)path));
        } else {
            log.warn("Calendar component '{}' is already subscribed to '{}'", (Object)this.resource.getPath(), (Object)path);
        }
    }

    public void unsubscribeFrom(String path) {
        Object[] subscriptions = this.getSubscriptions();
        if (subscriptions != null) {
            int pos = Arrays.binarySearch(subscriptions, path);
            while (pos >= 0) {
                subscriptions = (String[])ArrayUtils.remove((Object[])subscriptions, (int)pos);
                pos = Arrays.binarySearch(subscriptions, path);
            }
            this.setSubscriptions((String[])subscriptions);
        } else {
            log.warn("Calendar component '{}' was not subscribed to '{}'", (Object)this.resource.getPath(), (Object)path);
        }
    }

    public String getDefaultCalendarPath() {
        return this.resource.getPath() + "/calendars/default";
    }

    public CqCalendar getDefaultCalendar() {
        Resource defCalRes = this.resource.getResourceResolver().getResource(this.getDefaultCalendarPath());
        return defCalRes == null ? null : (CqCalendar)defCalRes.adaptTo(CqCalendar.class);
    }

    public PredicateGroup getCalendarPathQuery() {
        PredicateGroup group = new PredicateGroup();
        group.setAllRequired(false);
        group.add(new Predicate("path").set("path", this.getDefaultCalendarPath()));
        for (String path : this.getSubscriptions()) {
            Resource subscription = this.resource.getResourceResolver().getResource(path);
            if (subscription == null) continue;
            group.add(new Predicate("path").set("path", path).set("self", "true"));
            Node node = (Node)subscription.adaptTo(Node.class);
            try {
                if (node == null || !node.isNodeType("cq:CalendarEvent")) continue;
                Predicate p = new Predicate("property");
                p.set("property", "recurrenceOf");
                p.set("value", path);
                group.add(p);
            }
            catch (RepositoryException e) {
                log.error("Could not node type for node: " + subscription.getPath(), (Throwable)e);
            }
        }
        return group;
    }
}

