/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.collab.calendar;

import com.day.cq.collab.calendar.impl.ICalEventMapper;
import com.day.cq.collab.calendar.impl.JcrTimeZoneRegistry;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;

@Deprecated
public abstract class CalendarUtil {
    public static final TimeZone UTC = ICalEventMapper.UTC_TIMEZONE;
    public static final String UTC_ID = "Etc/UTC";
    public static final String ECMA_DATE_PATTERN = "EEE MMM dd yyyy HH:mm:ss 'GMT'Z";
    public static final String ECMA_DATE_ONLY_PATTERN = "EEE MMM dd yyyy";
    private static TimeZoneRegistry tzRegistry;

    public static SimpleDateFormat getEcmaDateFormat(boolean isDate, String timeZoneID) {
        SimpleDateFormat df = isDate ? new SimpleDateFormat(ECMA_DATE_ONLY_PATTERN, Locale.US) : new SimpleDateFormat(ECMA_DATE_PATTERN, Locale.US);
        TimeZone timeZone = CalendarUtil.getTimeZone(timeZoneID);
        if (isDate || timeZone == null) {
            df.setTimeZone(UTC);
        } else {
            df.setTimeZone(timeZone);
        }
        return df;
    }

    public static TimeZone getTimeZone(String tzID) {
        if (tzID == null) {
            return null;
        }
        if (tzRegistry == null) {
            tzRegistry = new JcrTimeZoneRegistry();
        }
        return tzRegistry.getTimeZone(tzID);
    }

    public static Calendar shiftTimeZone(Calendar cal, TimeZone timeZone) {
        if (cal == null || timeZone == null) {
            return cal;
        }
        Calendar out = Calendar.getInstance(timeZone);
        out.setTimeInMillis(cal.getTimeInMillis());
        return out;
    }

    public static Calendar shiftToUTC(Calendar cal) {
        return CalendarUtil.shiftTimeZone(cal, UTC);
    }

    public static Calendar replaceTimeZone(Calendar cal, TimeZone timeZone) {
        Calendar newCal = Calendar.getInstance(timeZone);
        newCal.clear();
        newCal.set(cal.get(1), cal.get(2), cal.get(5), cal.get(11), cal.get(12), cal.get(13));
        newCal.set(14, cal.get(14));
        return newCal;
    }

    public static String calendarToString(Calendar cal) {
        if (cal == null) {
            return "null";
        }
        StringBuffer result = new StringBuffer();
        result.append(cal.get(1));
        result.append("-");
        CalendarUtil.pad(result, Integer.toString(cal.get(2) + 1), '0', 2);
        result.append("-");
        CalendarUtil.pad(result, Integer.toString(cal.get(5)), '0', 2);
        result.append(" T ");
        CalendarUtil.pad(result, Integer.toString(cal.get(11)), '0', 2);
        result.append(":");
        CalendarUtil.pad(result, Integer.toString(cal.get(12)), '0', 2);
        result.append(":");
        CalendarUtil.pad(result, Integer.toString(cal.get(13)), '0', 2);
        result.append(".");
        CalendarUtil.pad(result, Integer.toString(cal.get(14)), '0', 3);
        result.append(" ");
        int offset = cal.getTimeZone().getOffset(cal.getTimeInMillis());
        if (offset >= 0) {
            result.append("+");
        } else {
            result.append("-");
        }
        CalendarUtil.pad(result, Long.toString(Math.abs((long)offset / 3600000L)), '0', 2);
        result.append(":");
        CalendarUtil.pad(result, Long.toString(Math.abs((long)offset % 3600000L) / 60000L), '0', 2);
        result.append(" ");
        result.append(cal.getTimeZone().getID());
        return result.toString();
    }

    private static void pad(StringBuffer buffer, String str, char padChr, int len) {
        for (int i = 0; i < len - str.length(); ++i) {
            buffer.append(padChr);
        }
        buffer.append(str);
    }
}

