/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.collab.calendar.impl;

import com.day.cq.collab.calendar.CalendarUtil;
import com.day.cq.collab.calendar.CqCalendar;
import com.day.cq.collab.calendar.Event;
import com.day.cq.collab.calendar.impl.CqCalendarImpl;
import com.day.cq.collab.calendar.impl.EventImpl;
import com.day.cq.collab.calendar.impl.ICalEventMapper;
import com.day.cq.collab.calendar.impl.JcrTimeZoneRegistry;
import com.day.cq.collab.calendar.impl.JcrUtils;
import com.day.cq.collab.calendar.impl.RecurrenceHandler;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import net.fortuna.ical4j.model.TimeZone;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.ModificationType;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
@Component(label="Day CQ Social Collaboration CalendarEvent Post Processor", description="Sling POST servlet post processor that handles cq:CalendarEvent node changes", enabled=false)
@Service
public class CalendarEventPostProcessor
implements SlingPostProcessor {
    private static Logger log = LoggerFactory.getLogger(CalendarEventPostProcessor.class);
    static final String PN_DISTRIBUTE = "cq:distribute";
    static final String TAKE_OUT_OF_RECURRENCE_PARAM = ":takeOutOfRecurrence";
    static final String SPLIT_RECURRENCE_PARAM = ":splitRecurrence";
    static final String DELETE_FROM_RECURRENCE_PARAM = ":deleteFromRecurrence";
    @Reference
    protected SlingRepository repository;
    @Property(boolValue={false})
    protected static final String REVERSE_REPLICATE = "reverseReplicate";
    @Property(boolValue={false})
    protected static final String ENSURE_DATE_FOLDERS = "ensureDateFolders";
    private boolean reverseReplicate;
    private boolean ensureDateFolders;

    protected void activate(ComponentContext context) {
        this.reverseReplicate = OsgiUtil.toBoolean(context.getProperties().get(REVERSE_REPLICATE), (boolean)false);
        this.ensureDateFolders = OsgiUtil.toBoolean(context.getProperties().get(ENSURE_DATE_FOLDERS), (boolean)false);
    }

    private void logRequestParams(SlingHttpServletRequest request) {
        if (log.isDebugEnabled()) {
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String name = (String)parameterNames.nextElement();
                String value = request.getParameter(name);
                log.debug("request param: " + name + " = " + value);
            }
        }
    }

    public void process(SlingHttpServletRequest request, List<Modification> changes) throws Exception {
        ResourceResolver resolver = request.getResource().getResourceResolver();
        Session session = (Session)resolver.adaptTo(Session.class);
        JcrTimeZoneRegistry registry = new JcrTimeZoneRegistry();
        if (request.getParameter(DELETE_FROM_RECURRENCE_PARAM) != null) {
            this.logRequestParams(request);
            Event event = (Event)request.getResource().adaptTo(Event.class);
            if (event != null) {
                event.deleteFromRecurrence(false);
            }
        }
        Collection<String> createdOrModifiedEvents = this.findNodes(session, changes, "cq:CalendarEvent", ModificationType.CREATE, ModificationType.MODIFY);
        Collection<String> deletedEvents = this.findNodes(session, changes, "cq:CalendarEvent", ModificationType.DELETE);
        for (String path : createdOrModifiedEvents) {
            javax.jcr.Property untilProp;
            boolean isDate;
            Node node = session.getNode(path);
            log.info("created/modified: " + path);
            this.logRequestParams(request);
            if (this.reverseReplicate) {
                changes.add(Modification.onModified((String)node.setProperty(PN_DISTRIBUTE, true).getPath()));
            }
            if (!node.hasProperty("uid")) {
                node.setProperty("uid", ICalEventMapper.generateUID());
            }
            if (!node.hasProperty("sequence")) {
                node.setProperty("sequence", 1L);
            } else {
                try {
                    long seq = node.getProperty("sequence").getLong();
                    node.setProperty("sequence", seq + 1L);
                }
                catch (ValueFormatException e) {
                    node.setProperty("sequence", 0L);
                }
            }
            boolean bl = isDate = node.hasProperty("isDate") && node.getProperty("isDate").getBoolean();
            if (isDate) {
                this.shiftToUTC(node.getProperty("start"));
                this.shiftToUTC(node.getProperty("end"));
                node.setProperty("timeZone", (String)null);
            } else if (node.hasProperty("timeZone")) {
                TimeZone tz = registry.getTimeZone(node.getProperty("timeZone").getString());
                if (tz != null) {
                    this.ensureTimeZone(node.getProperty("start"), (java.util.TimeZone)tz);
                    this.ensureTimeZone(node.getProperty("end"), (java.util.TimeZone)tz);
                }
            } else {
                this.replaceWithUTCTimeZone(node.getProperty("start"));
                this.replaceWithUTCTimeZone(node.getProperty("end"));
            }
            if (node.hasProperty("recurrence/rule/until") && (untilProp = node.getProperty("recurrence/rule/until")).getType() == 5) {
                Calendar until = untilProp.getDate();
                if (isDate) {
                    untilProp.setValue(CalendarUtil.shiftToUTC(until));
                } else {
                    Calendar startDate = node.getProperty("start").getDate();
                    until.setTimeZone(startDate.getTimeZone());
                    until.set(11, startDate.get(11));
                    until.set(12, startDate.get(12));
                    until.set(13, startDate.get(13));
                    until.set(14, startDate.get(14));
                    untilProp.setValue(CalendarUtil.shiftToUTC(until));
                }
            }
            Calendar utcNow = Calendar.getInstance(CalendarUtil.UTC);
            utcNow.set(14, 0);
            if (!node.hasProperty("stamp")) {
                node.setProperty("stamp", utcNow);
            }
            JcrUtils.setJcrCreatedAndLastModified(node, utcNow, session.getUserID());
            EventImpl event = (EventImpl)resolver.getResource(node.getPath()).adaptTo(Event.class);
            if (log.isDebugEnabled()) {
                ValueMap props = event.getProperties();
                log.debug("calendar start    : " + CalendarUtil.calendarToString(event.getStart()));
                log.debug("calendar end      : " + CalendarUtil.calendarToString(event.getEnd()));
                log.debug("calendar isDate   : " + event.isDate());
                log.debug("calendar timeZone : " + (String)props.get("timeZone", (Object)""));
            }
            if (request.getParameter(TAKE_OUT_OF_RECURRENCE_PARAM) != null) {
                log.info("taking out of recurrence: " + node.getPath());
                event.takeOutOfRecurrence(false);
                if (!this.ensureDateFolders) continue;
                this.moveIntoDateFolder(event, resolver);
                continue;
            }
            if (this.ensureDateFolders) {
                RecurrenceHandler.deleteRecurrences(event, null);
                event = this.moveIntoDateFolder(event, resolver);
                RecurrenceHandler.addRecurrences(event, null);
                continue;
            }
            event.updateRecurrences(false);
        }
        for (String path : deletedEvents) {
            log.info("deleted         : " + path);
            this.logRequestParams(request);
            RecurrenceHandler.deleteAllRecurrences(resolver, path);
        }
    }

    protected EventImpl moveIntoDateFolder(EventImpl event, ResourceResolver resolver) throws RepositoryException {
        try {
            String expectedPath;
            CqCalendar cal = event.getCalendar();
            Node node = event.getNode();
            Session session = node.getSession();
            String relPath = node.getParent().getPath().substring(cal.getPath().length() + 1);
            if (CqCalendarImpl.isDatePath(relPath) && !relPath.equals(expectedPath = CqCalendarImpl.getDatePath(event.getStart()))) {
                Node parent = JcrUtil.createPath((String)(cal.getPath() + "/" + expectedPath), (String)"nt:unstructured", (Session)session);
                String targetPath = parent.getPath() + "/" + JcrUtil.createValidChildName((Node)parent, (String)node.getName());
                log.info("moving event from: " + node.getPath() + " to " + targetPath);
                session.move(node.getPath(), targetPath);
                return (EventImpl)resolver.getResource(node.getPath()).adaptTo(Event.class);
            }
        }
        catch (Exception e) {
            log.warn("Could not ensure correct date folder for event: " + event.getPath(), (Throwable)e);
        }
        return event;
    }

    protected void shiftToUTC(javax.jcr.Property dateProperty) throws RepositoryException {
        Calendar utcCal = CalendarUtil.shiftToUTC(dateProperty.getDate());
        dateProperty.setValue(utcCal);
    }

    protected void ensureTimeZone(javax.jcr.Property dateProperty, java.util.TimeZone timeZone) throws RepositoryException {
        Calendar cal = dateProperty.getDate();
        dateProperty.setValue(CalendarUtil.shiftTimeZone(cal, timeZone));
    }

    protected void replaceWithUTCTimeZone(javax.jcr.Property dateProperty) throws RepositoryException {
        Calendar utcCal = CalendarUtil.replaceTimeZone(dateProperty.getDate(), CalendarUtil.UTC);
        dateProperty.setValue(utcCal);
    }

    protected Collection<String> findNodes(Session session, List<Modification> changes, String nodeType, ModificationType ... modTypes) {
        Arrays.sort(modTypes);
        Session adminSession = null;
        HashSet<String> paths = new HashSet<String>();
        for (Modification mod : changes) {
            Item item = null;
            try {
                Node node;
                if (mod.getType().equals((Object)ModificationType.DELETE)) {
                    if (!session.itemExists(mod.getSource())) {
                        if (adminSession == null) {
                            adminSession = this.createAdminSession();
                        }
                        if (adminSession != null && adminSession.itemExists(mod.getSource())) {
                            item = adminSession.getItem(mod.getSource());
                        }
                    }
                } else {
                    try {
                        item = session.getItem(mod.getSource());
                    }
                    catch (PathNotFoundException ignore) {
                        // empty catch block
                    }
                }
                if (item == null) continue;
                ModificationType modType = mod.getType();
                if (item.isNode()) {
                    node = (Node)item;
                } else {
                    node = item.getParent();
                    if (modType.equals((Object)ModificationType.DELETE) || modType.equals((Object)ModificationType.CREATE)) {
                        modType = ModificationType.MODIFY;
                    }
                }
                if (Arrays.binarySearch(modTypes, modType) < 0 || !node.isNodeType(nodeType)) continue;
                paths.add(node.getPath());
            }
            catch (Exception e) {
                log.error("problem analyzing sling post servlet modification list", (Throwable)e);
            }
        }
        if (adminSession != null) {
            adminSession.logout();
        }
        return paths;
    }

    private Session createAdminSession() {
        try {
            return this.repository.loginAdministrative(null);
        }
        catch (RepositoryException re) {
            log.error("unable to acquire admin session", (Throwable)re);
            return null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

