/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.collab.calendar.impl;

import com.day.cq.collab.calendar.CalendarException;
import com.day.cq.collab.calendar.CqCalendar;
import com.day.cq.collab.calendar.Event;
import com.day.cq.collab.calendar.impl.EventImpl;
import com.day.cq.collab.calendar.impl.ICalImporter;
import com.day.cq.commons.Externalizer;
import com.day.cq.commons.jcr.JcrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Url;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.model.property.XProperty;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class CqCalendarImpl
implements CqCalendar {
    private static final Logger log = LoggerFactory.getLogger(CqCalendarImpl.class);
    private Resource resource;
    private Node node;
    private String bundleVersion;
    private ValueMap props;
    private static Pattern DATE_PATH_PATTERN = Pattern.compile("\\d+/\\d+/\\d+");

    public CqCalendarImpl(Resource resource, String bundleVersion) {
        this.resource = resource;
        this.node = (Node)resource.adaptTo(Node.class);
        this.bundleVersion = bundleVersion;
        this.props = (ValueMap)resource.adaptTo(ValueMap.class);
    }

    @Override
    public String getPath() {
        return this.resource.getPath();
    }

    @Override
    public String getName() {
        return (String)this.props.get("jcr:title", (Object)Text.getName((String)this.resource.getPath()));
    }

    @Override
    public void importICS(InputStream iCalendarStream) throws IOException {
        ICalImporter importer = new ICalImporter(this);
        importer.importStream(iCalendarStream);
    }

    @Override
    public void exportICS(OutputStream out) throws IOException, CalendarException {
        CalendarOutputter outputter = new CalendarOutputter(true, 73);
        try {
            outputter.output(this.createICal4jCalendar(true, null), out);
        }
        catch (ValidationException e) {
            throw new CalendarException("Could not build valid icalendar", e);
        }
    }

    @Override
    public Event getEvent(String path) {
        return this.getEventImpl(path);
    }

    @Override
    public Event findEvent(String uid) {
        String query = "/jcr:root" + this.getPath() + "//element(*, " + "cq:CalendarEvent" + ")" + "[@" + "uid" + "='" + uid + "' and not(@" + "recurrenceOf" + ")]";
        Iterator resourceIter = this.resource.getResourceResolver().findResources(query, "xpath");
        if (resourceIter.hasNext()) {
            EventImpl event = new EventImpl((Resource)resourceIter.next(), this, this.bundleVersion);
            if (resourceIter.hasNext()) {
                log.error("found more than one event under UID '" + uid + "': '" + event.getPath() + "' and '" + ((Resource)resourceIter.next()).getPath() + "'");
                return null;
            }
            return event;
        }
        return null;
    }

    @Override
    public Iterator<Event> getEvents() {
        return new EventIterator(this.resource);
    }

    public Node getNode() {
        return this.node;
    }

    public EventImpl getEventImpl(String path) {
        Resource eventRes = this.resource.getResourceResolver().getResource(path);
        return eventRes == null ? null : new EventImpl(eventRes, this, this.bundleVersion);
    }

    public Node createNode(java.util.Calendar startDate, String summary, String uid, String fallbackName, String nodeType) throws RepositoryException {
        String relPath = CqCalendarImpl.getRelativePath(startDate, summary, uid, fallbackName);
        String path = this.getNode().getPath() + "/" + relPath;
        return JcrUtil.createPath((String)path, (boolean)true, (String)"nt:unstructured", (String)nodeType, (Session)this.getNode().getSession(), (boolean)false);
    }

    public Calendar createICal4jCalendar(boolean includeEvents, Method method) {
        Calendar iCalendar = new Calendar();
        PropertyList p = iCalendar.getProperties();
        p.add((Property)(method != null ? method : Method.PUBLISH));
        p.add((Property)CalScale.GREGORIAN);
        p.add((Property)Version.VERSION_2_0);
        p.add((Property)new ProdId("-//Day Software//CQ5 Calendar " + this.bundleVersion + "//EN"));
        p.add((Property)new XProperty("X-WR-CALNAME", this.getName()));
        if (includeEvents) {
            ComponentList components = iCalendar.getComponents();
            Iterator<Event> events = this.getEvents();
            while (events.hasNext()) {
                VEvent vEvent;
                EventImpl event = (EventImpl)events.next();
                if (event.isRecurrence() || (vEvent = event.createVEvent()) == null) continue;
                CqCalendarImpl.externalizeUrls(vEvent, this.resource.getResourceResolver());
                components.add((Component)vEvent);
            }
        }
        return iCalendar;
    }

    public static void externalizeUrls(VEvent event, ResourceResolver resourceResolver) {
        URI link;
        if (resourceResolver == null) {
            return;
        }
        Url url = event.getUrl();
        if (url != null && !(link = url.getUri()).isAbsolute()) {
            try {
                String extUrl = ((Externalizer)resourceResolver.adaptTo(Externalizer.class)).absoluteLink(resourceResolver, "http", link.toString());
                url.setValue(extUrl + ".html");
            }
            catch (URISyntaxException e) {
                log.warn("Could not externalize URL in ical event: " + url.getValue(), (Throwable)e);
            }
        }
    }

    public static String getDatePath(java.util.Calendar date) {
        int year = date.get(1);
        int month = date.get(2) + 1;
        int day = date.get(5);
        return String.format("%1$d/%2$02d/%3$02d", year, month, day);
    }

    public static boolean isDatePath(String relPath) {
        if (relPath == null) {
            return false;
        }
        return DATE_PATH_PATTERN.matcher(relPath).matches();
    }

    public static String getRelativePath(java.util.Calendar startDate, String summary, String uid, String fallbackName) {
        if (startDate == null) {
            startDate = java.util.Calendar.getInstance();
        }
        String parentPath = CqCalendarImpl.getDatePath(startDate);
        String nodeName = null;
        if (summary != null && (nodeName = summary) != null) {
            nodeName = nodeName.substring(0, (nodeName = nodeName.trim()).length() > 40 ? 40 : nodeName.length());
        }
        if (nodeName == null) {
            nodeName = uid != null ? uid : fallbackName;
        }
        return parentPath + "/" + JcrUtil.createValidName((String)nodeName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EventIterator
    implements Iterator<Event> {
        final ResourceResolver resolver;
        final Stack<Iterator<Resource>> resourceTreeStack = new Stack();
        Event currentEvent;

        public EventIterator(Resource resource) {
            this.resolver = resource.getResourceResolver();
            this.resourceTreeStack.push(this.resolver.listChildren(resource));
            this.currentEvent = this.seek();
        }

        private Event seek() {
            while (this.resourceTreeStack.size() > 0) {
                Iterator<Resource> iter = this.resourceTreeStack.peek();
                while (iter.hasNext()) {
                    Resource resource = iter.next();
                    if (this.isNodeType((Node)resource.adaptTo(Node.class), "cq:CalendarEvent")) {
                        return new EventImpl(resource, CqCalendarImpl.this, CqCalendarImpl.this.bundleVersion);
                    }
                    this.resourceTreeStack.push(this.resolver.listChildren(resource));
                    Event event = this.seek();
                    if (event == null) continue;
                    return event;
                }
                try {
                    this.resourceTreeStack.pop();
                }
                catch (EmptyStackException e) {
                    log.info("Empty Event, The iterator should just continue");
                }
            }
            return null;
        }

        private boolean isNodeType(Node node, String type) {
            if (node != null) {
                try {
                    return node.isNodeType(type);
                }
                catch (RepositoryException e) {
                    log.error("Could not check node type while retrieving calendar events", (Throwable)e);
                }
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.currentEvent != null;
        }

        @Override
        public Event next() {
            Event event = this.currentEvent;
            this.currentEvent = this.seek();
            return event;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not possible on event iterator returned by CqCalendar.getEvents()");
        }
    }
}

