/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.collab.calendar.impl;

import com.day.cq.collab.calendar.CalendarException;
import com.day.cq.collab.calendar.CqCalendar;
import com.day.cq.collab.calendar.Event;
import com.day.cq.collab.calendar.impl.CalendarManagerImpl;
import com.day.cq.collab.calendar.impl.CqCalendarImpl;
import com.day.cq.collab.calendar.impl.ICalEventMapper;
import com.day.cq.collab.calendar.impl.RecurrenceHandler;
import java.util.Calendar;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import net.fortuna.ical4j.model.component.VEvent;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class EventImpl
implements Event {
    private static final Logger log = LoggerFactory.getLogger(EventImpl.class);
    public static final String IMPORTCOPY_UID_SUFFIX = "-day-cq5-importcopy";
    protected Resource resource;
    protected Node node;
    protected ValueMap props;
    private CqCalendarImpl calendar;
    private String bundleVersion;

    public EventImpl(Resource resource, CqCalendarImpl calendar, String bundleVersion) {
        this.resource = resource;
        this.props = (ValueMap)resource.adaptTo(ValueMap.class);
        this.calendar = calendar;
        this.bundleVersion = bundleVersion;
    }

    @Override
    public String getPath() {
        return this.resource.getPath();
    }

    @Override
    public String getUid() {
        return (String)this.props.get((Object)"uid");
    }

    @Override
    public Calendar getStart() {
        return (Calendar)this.props.get("start", Calendar.class);
    }

    @Override
    public Calendar getEnd() {
        return (Calendar)this.props.get("end", Calendar.class);
    }

    @Override
    public boolean isDate() {
        return (Boolean)this.props.get("isDate", (Object)false);
    }

    @Override
    public ValueMap getProperties() {
        return this.props;
    }

    @Override
    public CqCalendar getCalendar() {
        return this.getCalendarImpl();
    }

    @Override
    public boolean isRecurringSeries() {
        if (this.isRecurrence()) {
            return true;
        }
        try {
            return this.getNode().hasNode("recurrence");
        }
        catch (RepositoryException e) {
            log.error("Cannot check if event node has recurrence subnode", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isRecurrence() {
        return this.props.get((Object)"recurrenceOf") != null;
    }

    @Override
    public Event getOriginal() {
        Resource original = this.getResolver().getResource((String)this.props.get("recurrenceOf", (Object)""));
        return original == null ? this : new EventImpl(original, this.calendar, this.bundleVersion);
    }

    @Override
    public Iterator<Event> getRecurrences() {
        if (this.isRecurrence()) {
            return EmptyIterator.INSTANCE;
        }
        return new EventIteratorAdapter(RecurrenceHandler.getRecurrences(this.resource.getResourceResolver(), this.getPath()));
    }

    @Override
    public void updateRecurrences(boolean save) throws CalendarException {
        try {
            RecurrenceHandler.replaceRecurrences(this, null);
            if (save) {
                this.getNode().getSession().save();
            }
        }
        catch (RepositoryException e) {
            throw new CalendarException("Could not update recurrences for " + this.getPath(), e);
        }
    }

    @Override
    public void takeOutOfRecurrence(boolean save) throws CalendarException {
        try {
            RecurrenceHandler.takeOutOfRecurrence(this, false);
            if (save) {
                this.getNode().getSession().save();
            }
        }
        catch (RepositoryException e) {
            throw new CalendarException("Could not take out of recurrences: " + this.getPath(), e);
        }
    }

    @Override
    public void deleteFromRecurrence(boolean save) throws CalendarException {
        try {
            RecurrenceHandler.takeOutOfRecurrence(this, true);
            if (save) {
                this.getNode().getSession().save();
            }
        }
        catch (RepositoryException e) {
            throw new CalendarException("Could not delete from recurrences: " + this.getPath(), e);
        }
    }

    @Override
    public String toICalendarString() {
        VEvent vEvent = this.createVEvent();
        if (vEvent != null) {
            CqCalendarImpl.externalizeUrls(vEvent, this.getResolver());
            return vEvent.toString();
        }
        return "";
    }

    public Node getNode() {
        if (this.node == null) {
            this.node = (Node)this.resource.adaptTo(Node.class);
        }
        return this.node;
    }

    public CqCalendarImpl getCalendarImpl() {
        if (this.calendar == null) {
            CalendarManagerImpl calMgr = new CalendarManagerImpl(this.resource.getResourceResolver(), this.bundleVersion);
            this.calendar = (CqCalendarImpl)calMgr.findCalendar(ResourceUtil.getParent((String)this.resource.getPath()), true);
        }
        return this.calendar;
    }

    public String getBundleVersion() {
        return this.bundleVersion;
    }

    public VEvent createVEvent() {
        return ICalEventMapper.createVEvent(this.getNode());
    }

    public String getRemoteLastImportMD5() {
        return (String)this.props.get((Object)"remoteLastImportMD5");
    }

    public boolean isModifiedSinceLastImport() {
        return !ICalEventMapper.generateMD5(this.createVEvent()).equals(this.getLocalLastImportMD5());
    }

    public String getLocalLastImportMD5() {
        return (String)this.props.get((Object)"localLastImportMD5");
    }

    public boolean isImportCopy() {
        return ((String)this.props.get("uid", (Object)"")).endsWith(IMPORTCOPY_UID_SUFFIX);
    }

    public static String getImportCopyUIDFor(String uid) {
        return uid + IMPORTCOPY_UID_SUFFIX;
    }

    public String getImportCopyUID() {
        if (this.isImportCopy()) {
            return this.getUid();
        }
        return EventImpl.getImportCopyUIDFor(this.getUid());
    }

    private ResourceResolver getResolver() {
        return this.resource.getResourceResolver();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public class EventIteratorAdapter
    implements Iterator<Event> {
        private Iterator<Resource> resourceIter;

        public EventIteratorAdapter(Iterator<Resource> resourceIter) {
            this.resourceIter = resourceIter;
        }

        @Override
        public boolean hasNext() {
            return this.resourceIter.hasNext();
        }

        @Override
        public Event next() {
            return new EventImpl(this.resourceIter.next(), EventImpl.this.calendar, EventImpl.this.bundleVersion);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not allowd on getRecurrences() event iterator");
        }
    }
}

