/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.collab.calendar.impl;

import com.day.cq.collab.calendar.CalendarUtil;
import com.day.cq.collab.calendar.impl.JcrUtils;
import com.day.cq.commons.jcr.JcrUtil;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.NumberList;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.WeekDayList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.parameter.Dir;
import net.fortuna.ical4j.model.parameter.SentBy;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Created;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.Geo;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.RDate;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.Sequence;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Transp;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Url;
import net.fortuna.ical4j.model.property.UtcProperty;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.util.TimeZones;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.resource.JcrPropertyMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class ICalEventMapper {
    private static final Logger log = LoggerFactory.getLogger(ICalEventMapper.class);
    private static final String UTC_ICS_DEFINITION = "BEGIN:VCALENDAR\nPRODID:-//tzurl.org//NONSGML Olson 2009g//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:Etc/UTC\nX-LIC-LOCATION:Etc/UTC\nBEGIN:STANDARD\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0000\nTZNAME:UTC\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n";
    public static final net.fortuna.ical4j.model.TimeZone UTC_TIMEZONE = new net.fortuna.ical4j.model.TimeZone(ICalEventMapper.loadVTimeZone("BEGIN:VCALENDAR\nPRODID:-//tzurl.org//NONSGML Olson 2009g//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:Etc/UTC\nX-LIC-LOCATION:Etc/UTC\nBEGIN:STANDARD\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0000\nTZNAME:UTC\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"));

    public static void writeStartEnd(VEvent icalEvent, Node node) throws RepositoryException {
        DtStart startDate = icalEvent.getStartDate();
        boolean isDate = ICalEventMapper.isPureDate((DateProperty)startDate);
        net.fortuna.ical4j.model.TimeZone timeZone = ICalEventMapper.normalizeTimeZone(startDate.getTimeZone(), startDate.isUtc());
        ICalEventMapper.writeDate(node, ICalEventMapper.normalizeDateProperty((DateProperty)startDate, isDate, timeZone, false), "start");
        ICalEventMapper.writeDate(node, ICalEventMapper.normalizeDateProperty((DateProperty)icalEvent.getEndDate(), isDate, timeZone, true), "end");
    }

    public static void writeEventNode(VEvent icalEvent, Node node) throws RepositoryException {
        ICalEventMapper.writeString(node, (Property)icalEvent.getUid(), "uid");
        ICalEventMapper.writeSequence(node, icalEvent.getSequence(), "sequence");
        ICalEventMapper.writeUTCDateProperty(node, (UtcProperty)icalEvent.getDateStamp(), "stamp");
        ICalEventMapper.writeCreatedAndLastModifiedMetaData(node, icalEvent);
        DtStart startDate = icalEvent.getStartDate();
        boolean isDate = ICalEventMapper.isPureDate((DateProperty)startDate);
        net.fortuna.ical4j.model.TimeZone timeZone = ICalEventMapper.normalizeTimeZone(startDate.getTimeZone(), startDate.isUtc());
        ICalEventMapper.writeBoolean(node, isDate, "isDate");
        ICalEventMapper.writeTimeZone(node, timeZone, "timeZone");
        ICalEventMapper.writeStartEnd(icalEvent, node);
        ICalEventMapper.writeString(node, (Property)icalEvent.getSummary(), "jcr:title");
        ICalEventMapper.writeString(node, (Property)icalEvent.getDescription(), "jcr:description");
        ICalEventMapper.writeString(node, (Property)icalEvent.getLocation(), "location");
        ICalEventMapper.writeGeoLocation(node, icalEvent.getGeographicPos());
        ICalEventMapper.writeString(node, (Property)icalEvent.getUrl(), "url");
        ICalEventMapper.writeString(node, (Property)icalEvent.getClassification(), "class");
        ICalEventMapper.writeString(node, (Property)icalEvent.getStatus(), "status");
        ICalEventMapper.writeBooleanIfValueEquals(node, (Property)icalEvent.getTransparency(), (Property)Transp.TRANSPARENT, "transparent");
        ICalEventMapper.writePriority(node, icalEvent.getPriority(), "priority");
        ICalEventMapper.writeOrganizer(icalEvent, node);
        ICalEventMapper.writeRecurrenceNode(icalEvent, node, isDate, timeZone);
        VEvent localEvent = ICalEventMapper.createVEvent(node);
        if (localEvent != null) {
            node.setProperty("remoteLastImportMD5", ICalEventMapper.generateMD5(icalEvent));
            node.setProperty("localLastImportMD5", ICalEventMapper.generateMD5(localEvent));
        }
    }

    private static void writeCreatedAndLastModifiedMetaData(Node node, VEvent icalEvent) throws RepositoryException {
        Created created = icalEvent.getCreated();
        if (created != null && created.getDate() != null) {
            JcrUtils.setJcrCreated(node, ICalEventMapper.icalDate2Calendar(created.getDate()), node.getSession().getUserID());
        } else {
            JcrUtils.setJcrCreated(node, Calendar.getInstance((TimeZone)UTC_TIMEZONE), node.getSession().getUserID());
        }
        LastModified lastModified = icalEvent.getLastModified();
        if (lastModified != null && lastModified.getDate() != null) {
            JcrUtils.setJcrLastModified(node, ICalEventMapper.icalDate2Calendar(lastModified.getDate()), node.getSession().getUserID());
        } else {
            JcrUtils.setJcrLastModified(node, Calendar.getInstance((TimeZone)UTC_TIMEZONE), node.getSession().getUserID());
        }
    }

    public static VEvent createVEvent(Node node) {
        try {
            JcrPropertyMap props = new JcrPropertyMap(node);
            PropertyList list = new PropertyList();
            ICalEventMapper.addString(list, (Property)new Uid(), (ValueMap)props, "uid");
            list.add((Property)new Sequence(((Integer)props.get("sequence", (Object)0)).intValue()));
            ICalEventMapper.addUTCDate(list, (UtcProperty)new DtStamp(), (ValueMap)props, "stamp");
            ICalEventMapper.addUTCDate(list, (UtcProperty)new LastModified(), (ValueMap)props, "jcr:lastModified");
            ICalEventMapper.addUTCDate(list, (UtcProperty)new Created(), (ValueMap)props, "jcr:created");
            boolean isDate = (Boolean)props.get("isDate", (Object)false);
            net.fortuna.ical4j.model.TimeZone timeZone = ICalEventMapper.getTimeZone((String)props.get("timeZone", (Object)null), TimeZoneRegistryFactory.getInstance().createRegistry());
            ICalEventMapper.addDate(list, (DateProperty)new DtStart(), (ValueMap)props, "start", isDate, timeZone, false);
            ICalEventMapper.addDate(list, (DateProperty)new DtEnd(), (ValueMap)props, "end", isDate, timeZone, true);
            ICalEventMapper.addString(list, (Property)new Summary(), (ValueMap)props, "jcr:title");
            ICalEventMapper.addString(list, (Property)new Description(), (ValueMap)props, "jcr:description");
            ICalEventMapper.addString(list, (Property)new Location(), (ValueMap)props, "location");
            ICalEventMapper.addGeo(list, new Geo(), (ValueMap)props);
            ICalEventMapper.addString(list, (Property)new Url(), (ValueMap)props, "url");
            ICalEventMapper.addString(list, (Property)new Clazz(), (ValueMap)props, "class");
            ICalEventMapper.addString(list, (Property)new Status(), (ValueMap)props, "status");
            ICalEventMapper.addBoolean(list, (Property)Transp.TRANSPARENT, (ValueMap)props, "transparent");
            ICalEventMapper.addPriority(list, new Priority(), (ValueMap)props, "priority");
            ICalEventMapper.addOrganizer(list, node);
            if (node.hasNode("recurrence")) {
                Node recurNode = node.getNode("recurrence");
                ICalEventMapper.addRecurrence(list, recurNode, isDate, timeZone);
            }
            return new VEvent(list);
        }
        catch (RepositoryException e) {
            log.error("problem converting node to VEVENT: '" + JcrUtils.safeGetPath(node, log) + "'", (Throwable)e);
            return null;
        }
    }

    public static String generateMD5(VEvent icalEvent) {
        return Text.md5((String)icalEvent.toString());
    }

    private static void writeRecurrenceNode(VEvent icalEvent, Node node, boolean isDate, net.fortuna.ical4j.model.TimeZone timeZone) throws RepositoryException {
        PropertyList recurDates = icalEvent.getProperties("RDATE");
        PropertyList exceptionDates = icalEvent.getProperties("EXDATE");
        PropertyList recurRules = icalEvent.getProperties("RRULE");
        PropertyList exceptionRules = icalEvent.getProperties("EXRULE");
        if (exceptionRules.size() > 0) {
            log.warn("iCalendar exception rules (EXRULE) are not supported. ignoring for " + icalEvent.getUid());
        }
        if (recurDates.size() > 0 || exceptionDates.size() > 0 || recurRules.size() > 0) {
            Node recurrenceNode = node.addNode("recurrence", "cq:CalendarRecurrence");
            ValueFactory valueFactory = node.getSession().getValueFactory();
            if (recurDates.size() > 0) {
                ArrayList<Value> dateValues = new ArrayList<Value>();
                ArrayList periodValues = new ArrayList();
                for (Object obj : recurDates) {
                    PeriodList recurPeriods;
                    RDate rdate = (RDate)obj;
                    DateList recurDateList = rdate.getDates();
                    if (recurDateList != null) {
                        for (Object dateObj : recurDateList) {
                            Date date = (Date)dateObj;
                            dateValues.add(valueFactory.createValue(ICalEventMapper.icalDate2Calendar(ICalEventMapper.normalizeDate(date, isDate, timeZone, "RDATE", false))));
                        }
                    }
                    if ((recurPeriods = rdate.getPeriods()) == null) continue;
                    for (Object periodObj : recurPeriods) {
                        Period period = (Period)periodObj;
                        dateValues.add(valueFactory.createValue(ICalEventMapper.icalDate2Calendar(ICalEventMapper.normalizeDate((Date)period.getStart(), isDate, timeZone, "RDATE", false))));
                        dateValues.add(valueFactory.createValue(ICalEventMapper.icalDate2Calendar(ICalEventMapper.normalizeDate((Date)period.getEnd(), isDate, timeZone, "RDATE", false))));
                    }
                }
                if (dateValues.size() > 0) {
                    recurrenceNode.setProperty("dates", dateValues.toArray(new Value[0]));
                }
                if (periodValues.size() > 0) {
                    recurrenceNode.setProperty("periods", periodValues.toArray(new Value[0]));
                }
            }
            if (exceptionDates.size() > 0) {
                ArrayList<Value> exdateValues = new ArrayList<Value>();
                for (Object obj : exceptionDates) {
                    ExDate exdate = (ExDate)obj;
                    DateList exceptionDateList = exdate.getDates();
                    if (exceptionDateList == null) continue;
                    for (Object dateObj : exceptionDateList) {
                        Date date = (Date)dateObj;
                        exdateValues.add(valueFactory.createValue(ICalEventMapper.icalDate2Calendar(ICalEventMapper.normalizeDate(date, isDate, timeZone, "EXDATE", false))));
                    }
                }
                if (exdateValues.size() > 0) {
                    recurrenceNode.setProperty("exceptions", exdateValues.toArray(new Value[0]));
                }
            }
            if (recurRules.size() > 0) {
                for (Object obj : recurRules) {
                    long interval;
                    Node ruleNode = JcrUtil.createUniqueNode((Node)recurrenceNode, (String)"rule", (String)"cq:CalendarRecurrenceRule", (Session)recurrenceNode.getSession());
                    Recur recurRule = ((RRule)obj).getRecur();
                    ICalEventMapper.writeLowerCaseString(ruleNode, recurRule.getFrequency(), "frequency");
                    ICalEventMapper.writeDate(ruleNode, ICalEventMapper.normalizeDate(recurRule.getUntil(), isDate, UTC_TIMEZONE, "UNTIL", false), "until");
                    long count = recurRule.getCount();
                    if (count >= 0L) {
                        ruleNode.setProperty("count", count);
                    }
                    if ((interval = (long)recurRule.getInterval()) >= 0L) {
                        ruleNode.setProperty("interval", interval);
                    }
                    ruleNode.setProperty("weekStart", recurRule.getWeekStartDay());
                    WeekDayList weekDayList = recurRule.getDayList();
                    if (weekDayList != null) {
                        ArrayList<String> weekDayStrList = new ArrayList<String>();
                        ArrayList<Value> weekDayOffsetList = new ArrayList<Value>();
                        for (Object weekDayObj : weekDayList) {
                            WeekDay weekDay = (WeekDay)weekDayObj;
                            weekDayStrList.add(weekDay.getDay());
                            weekDayOffsetList.add(valueFactory.createValue((long)weekDay.getOffset()));
                        }
                        if (weekDayStrList.size() > 0) {
                            ruleNode.setProperty("byWeekDay", weekDayStrList.toArray(new String[0]));
                            ruleNode.setProperty("byWeekDayOffset", weekDayOffsetList.toArray(new Value[0]));
                        }
                    }
                    ICalEventMapper.writeNumberList(ruleNode, recurRule.getMonthDayList(), "byMonthDay", valueFactory);
                    ICalEventMapper.writeNumberList(ruleNode, recurRule.getYearDayList(), "byYearDay", valueFactory);
                    ICalEventMapper.writeNumberList(ruleNode, recurRule.getWeekNoList(), "byWeekNr", valueFactory);
                    ICalEventMapper.writeNumberList(ruleNode, recurRule.getMonthList(), "byMonth", valueFactory);
                    ICalEventMapper.writeNumberList(ruleNode, recurRule.getHourList(), "byHour", valueFactory);
                    ICalEventMapper.writeNumberList(ruleNode, recurRule.getMinuteList(), "byMinute", valueFactory);
                    ICalEventMapper.writeNumberList(ruleNode, recurRule.getSecondList(), "bySecond", valueFactory);
                    ICalEventMapper.writeNumberList(ruleNode, recurRule.getSetPosList(), "bySetPos", valueFactory);
                }
            }
        }
    }

    private static void writeNumberList(Node node, NumberList list, String name, ValueFactory valueFactory) throws RepositoryException {
        if (node == null || list == null || name == null || name.length() == 0) {
            return;
        }
        ArrayList<Value> numberList = new ArrayList<Value>();
        for (Object numberObj : list) {
            int number = (Integer)numberObj;
            numberList.add(valueFactory.createValue((long)number));
        }
        if (numberList.size() > 0) {
            node.setProperty(name, numberList.toArray(new Value[0]));
        }
    }

    private static void writeString(Node node, Property prop, String name) throws RepositoryException {
        if (node == null || prop == null || name == null || name.length() == 0) {
            return;
        }
        node.setProperty(name, prop.getValue());
    }

    private static void writeLowerCaseString(Node node, String value, String name) throws RepositoryException {
        if (node == null || value == null || name == null || name.length() == 0) {
            return;
        }
        node.setProperty(name, value.toLowerCase());
    }

    private static void writeSequence(Node node, Sequence prop, String name) throws RepositoryException {
        if (node == null || prop == null || name == null || name.length() == 0) {
            return;
        }
        node.setProperty(name, (long)prop.getSequenceNo());
    }

    private static void writeUTCDateProperty(Node node, UtcProperty utcProp, String name) throws RepositoryException {
        if (node == null || utcProp == null || utcProp.getDate() == null || name == null || name.length() == 0) {
            return;
        }
        node.setProperty(name, ICalEventMapper.icalDate2Calendar(utcProp.getDate()));
    }

    private static void writeDate(Node node, Date date, String name) throws RepositoryException {
        if (node == null || date == null || name == null || name.length() == 0) {
            return;
        }
        Calendar cal = ICalEventMapper.icalDate2Calendar(date);
        node.setProperty(name, cal);
        log.debug("writing calendar value " + (name.equals("end") ? "end  " : name) + ": " + Strings.valueOf((Object)date) + " => " + CalendarUtil.calendarToString(cal));
        log.debug("jcr property value          : " + node.getProperty(name).getString());
    }

    private static void writeTimeZone(Node node, net.fortuna.ical4j.model.TimeZone timeZone, String name) throws RepositoryException {
        if (timeZone == null) {
            node.setProperty(name, (Value)null);
        } else {
            node.setProperty(name, timeZone.getID());
        }
    }

    private static void writeGeoLocation(Node node, Geo geo) throws RepositoryException {
        if (node == null || geo == null) {
            return;
        }
        node.setProperty("latitude", geo.getLatitude().doubleValue());
        node.setProperty("longitude", geo.getLongitude().doubleValue());
    }

    private static void writeBoolean(Node node, boolean isDate, String name) throws RepositoryException {
        if (node == null || name == null || name.length() == 0) {
            return;
        }
        if (isDate) {
            node.setProperty(name, true);
        } else {
            node.setProperty(name, (Value)null);
        }
    }

    private static void writeBooleanIfValueEquals(Node node, Property property, Property compareTo, String name) throws RepositoryException {
        if (node == null || property == null || compareTo == null || name == null || name.length() == 0) {
            return;
        }
        if (compareTo.getValue().equals(property.getValue())) {
            node.setProperty(name, true);
        }
    }

    private static void writePriority(Node node, Priority priority, String name) throws RepositoryException {
        if (node == null || priority == null || name == null || name.length() == 0) {
            return;
        }
        node.setProperty(name, (long)priority.getLevel());
    }

    private static void writeOrganizer(VEvent icalEvent, Node node) throws RepositoryException {
        Parameter dir;
        SentBy sentBy;
        Organizer organizer = icalEvent.getOrganizer();
        if (organizer == null) {
            return;
        }
        URI calAddress = organizer.getCalAddress();
        if (calAddress == null) {
            return;
        }
        String scheme = calAddress.getScheme();
        if (scheme == null) {
            return;
        }
        Node organizerNode = node.addNode("organizer", "nt:unstructured");
        organizerNode.setProperty("email", calAddress.getSchemeSpecificPart());
        Parameter cn = organizer.getParameter("CN");
        if (cn != null) {
            organizerNode.setProperty("jcr:title", cn.getValue());
        }
        if ((sentBy = (SentBy)organizer.getParameter("SENT-BY")) != null && sentBy.getAddress() != null) {
            organizerNode.setProperty("sentBy", sentBy.getAddress().getSchemeSpecificPart());
        }
        if ((dir = organizer.getParameter("DIR")) != null) {
            organizerNode.setProperty("directoryEntry", dir.getValue());
        }
    }

    public static void addRecurrence(PropertyList eventProps, Node node, boolean isDate, net.fortuna.ical4j.model.TimeZone timeZone) throws RepositoryException {
        Value[] exceptionValues;
        JcrPropertyMap props = new JcrPropertyMap(node);
        Value[] dateValues = (Value[])props.get("dates", Value[].class);
        if (dateValues != null) {
            DateList dateList = ICalEventMapper.createDateList(isDate, timeZone);
            for (Value val : dateValues) {
                try {
                    dateList.add(ICalEventMapper.calendar2icalDate(val.getDate(), isDate, timeZone));
                }
                catch (RepositoryException e) {
                    log.error("Could not read date value from '" + node.getPath() + "/" + "dates" + "'", (Throwable)e);
                }
            }
            eventProps.add((Property)new RDate(dateList));
        }
        boolean isUtc = timeZone != null && TimeZones.isUtc((TimeZone)timeZone);
        Value[] periodValues = (Value[])props.get("periods", Value[].class);
        if (periodValues != null) {
            PeriodList periodList = new PeriodList(isUtc);
            for (int i = 0; i < periodValues.length; i += 2) {
                if (i + 1 >= periodValues.length) continue;
                try {
                    Date start = ICalEventMapper.calendar2icalDate(periodValues[i].getDate(), isDate, timeZone);
                    Date end = ICalEventMapper.calendar2icalDate(periodValues[i + 1].getDate(), isDate, timeZone);
                    periodList.add(new Period(new DateTime((java.util.Date)start), new DateTime((java.util.Date)end)));
                    continue;
                }
                catch (RepositoryException e) {
                    log.error("Could not read date value from '" + node.getPath() + "/" + "periods" + "'", (Throwable)e);
                }
            }
            eventProps.add((Property)new RDate(periodList));
        }
        if ((exceptionValues = (Value[])props.get("exceptions", Value[].class)) != null) {
            DateList exceptionList = ICalEventMapper.createDateList(isDate, timeZone);
            for (Value val : exceptionValues) {
                try {
                    exceptionList.add(ICalEventMapper.calendar2icalDate(val.getDate(), isDate, timeZone));
                }
                catch (RepositoryException e) {
                    log.error("Could not read date value from '" + node.getPath() + "/" + "exceptions" + "'", (Throwable)e);
                }
            }
            eventProps.add((Property)new ExDate(exceptionList));
        }
        NodeIterator ruleNodes = node.getNodes();
        while (ruleNodes.hasNext()) {
            Node rule = ruleNodes.nextNode();
            try {
                String weekStart;
                if (!rule.isNodeType("cq:CalendarRecurrenceRule")) continue;
                JcrPropertyMap ruleProps = new JcrPropertyMap(rule);
                String frequency = (String)ruleProps.get("frequency", String.class);
                if (frequency == null) {
                    log.warn("Calendar rule without frequency. Ignoring. '" + rule.getPath() + "'");
                    continue;
                }
                frequency = frequency.toUpperCase();
                Calendar until = (Calendar)ruleProps.get("until", Calendar.class);
                int count = (Integer)ruleProps.get("count", (Object)-1);
                Recur recur = until != null ? new Recur(frequency, ICalEventMapper.calendar2icalDate(until, isDate, UTC_TIMEZONE)) : (count >= 0 ? new Recur(frequency, count) : new Recur(frequency, null));
                int interval = (Integer)ruleProps.get("interval", (Object)-1);
                if (interval >= 0) {
                    recur.setInterval(interval);
                }
                if ((weekStart = (String)ruleProps.get("weekStart", String.class)) != null) {
                    recur.setWeekStartDay(weekStart);
                }
                String[] weekDays = (String[])ruleProps.get("byWeekDay", String[].class);
                Integer[] weekDayOffsets = (Integer[])ruleProps.get("byWeekDayOffset", Integer[].class);
                if (weekDays != null && weekDayOffsets != null) {
                    WeekDayList weekDayList = recur.getDayList();
                    for (int i = 0; i < weekDays.length && i < weekDayOffsets.length; ++i) {
                        weekDayList.add(new WeekDay(new WeekDay(weekDays[i]), weekDayOffsets[i].intValue()));
                    }
                }
                ICalEventMapper.fillNumberList((ValueMap)ruleProps, "byMonthDay", recur.getMonthDayList());
                ICalEventMapper.fillNumberList((ValueMap)ruleProps, "byYearDay", recur.getYearDayList());
                ICalEventMapper.fillNumberList((ValueMap)ruleProps, "byWeekNr", recur.getWeekNoList());
                ICalEventMapper.fillNumberList((ValueMap)ruleProps, "byMonth", recur.getMonthList());
                ICalEventMapper.fillNumberList((ValueMap)ruleProps, "byHour", recur.getHourList());
                ICalEventMapper.fillNumberList((ValueMap)ruleProps, "byMinute", recur.getMinuteList());
                ICalEventMapper.fillNumberList((ValueMap)ruleProps, "bySecond", recur.getSecondList());
                ICalEventMapper.fillNumberList((ValueMap)ruleProps, "bySetPos", recur.getSetPosList());
                eventProps.add((Property)new RRule(recur));
            }
            catch (RepositoryException e) {
                log.error("Cannot identify primary node type of '" + rule.getPath() + "'", (Throwable)e);
            }
        }
    }

    private static DateList createDateList(boolean isDate, net.fortuna.ical4j.model.TimeZone timeZone) {
        DateList dateList = isDate ? new DateList(net.fortuna.ical4j.model.parameter.Value.DATE) : new DateList(net.fortuna.ical4j.model.parameter.Value.DATE_TIME);
        if (timeZone != null && TimeZones.isUtc((TimeZone)timeZone)) {
            dateList.setUtc(true);
        } else {
            dateList.setTimeZone(timeZone);
        }
        return dateList;
    }

    private static void fillNumberList(ValueMap props, String name, NumberList numberList) {
        Integer[] numbers = (Integer[])props.get(name, Integer[].class);
        if (numbers != null) {
            for (int i = 0; i < numbers.length; ++i) {
                numberList.add(numbers[i]);
            }
        }
    }

    private static void addString(PropertyList list, Property property, ValueMap props, String name) {
        Object value = props.get((Object)name);
        if (value != null && value instanceof String) {
            try {
                property.setValue((String)value);
                list.add(property);
            }
            catch (Exception e) {
                log.warn("problem setting value '" + value + "' on ical4j property", (Throwable)e);
            }
        }
    }

    private static void addUTCDate(PropertyList list, UtcProperty property, ValueMap props, String name) {
        Object value = props.get((Object)name);
        if (value != null && value instanceof Calendar) {
            Calendar cal = (Calendar)value;
            property.setDate(ICalEventMapper.calendar2icalDate(cal, false, UTC_TIMEZONE));
            list.add((Property)property);
        }
    }

    private static void addDate(PropertyList list, DateProperty property, ValueMap props, String name, boolean isDate, net.fortuna.ical4j.model.TimeZone timeZone, boolean makeExclusive) {
        Object value = props.get((Object)name);
        if (value != null && value instanceof Calendar) {
            Calendar cal = (Calendar)value;
            Date date = ICalEventMapper.calendar2icalDate(cal, isDate, timeZone);
            if (!(date instanceof DateTime) && makeExclusive) {
                date = ICalEventMapper.addOneDay(date);
            }
            property.setDate(date);
            list.add((Property)property);
        }
    }

    private static void addGeo(PropertyList list, Geo geo, ValueMap props) {
        Object latitude = props.get((Object)"latitude");
        Object longitude = props.get((Object)"longitude");
        if (latitude != null || longitude != null) {
            if (latitude != null && latitude instanceof Double) {
                geo.setLatitude(new BigDecimal((Double)latitude));
            }
            if (longitude != null && longitude instanceof Double) {
                geo.setLongitude(new BigDecimal((Double)longitude));
            }
            list.add((Property)geo);
        }
    }

    private static void addBoolean(PropertyList list, Property property, ValueMap props, String name) {
        boolean isTrue = (Boolean)props.get(name, (Object)false);
        if (isTrue) {
            list.add(property);
        }
    }

    private static void addPriority(PropertyList list, Priority priority, ValueMap props, String name) {
        Object prioObj = props.get((Object)name);
        if (prioObj != null && prioObj instanceof Long) {
            long prio = (Long)prioObj;
            priority.setLevel((int)prio);
            list.add((Property)priority);
        }
    }

    private static void addOrganizer(PropertyList list, Node node) throws RepositoryException {
        if (!node.hasNode("organizer")) {
            return;
        }
        Node organizerNode = node.getNode("organizer");
        if (!organizerNode.hasProperty("email")) {
            return;
        }
        try {
            String mail = organizerNode.getProperty("email").getString();
            Organizer organizer = new Organizer("MAILTO:" + mail);
            ParameterList params = organizer.getParameters();
            if (organizerNode.hasProperty("jcr:title")) {
                final String name = organizerNode.getProperty("jcr:title").getString();
                Parameter cn = new Parameter("CN", null){

                    public String getValue() {
                        return Strings.quote((Object)name);
                    }
                };
                params.add(cn);
            }
            if (organizerNode.hasProperty("sentBy")) {
                params.add((Parameter)new SentBy("MAILTO:" + organizerNode.getProperty("sentBy").getString()));
            }
            if (organizerNode.hasProperty("directoryEntry")) {
                params.add((Parameter)new Dir(organizerNode.getProperty("directoryEntry").getString()));
            }
            list.add((Property)organizer);
        }
        catch (URISyntaxException e) {
            log.warn("Could not export ORGANIZER field", (Throwable)e);
            return;
        }
    }

    private static Date normalizeDateProperty(DateProperty dateProp, boolean shouldBeDate, net.fortuna.ical4j.model.TimeZone expectedTimeZone, boolean makeInclusive) {
        if (dateProp == null) {
            return null;
        }
        return ICalEventMapper.normalizeDate(dateProp.getDate(), shouldBeDate, expectedTimeZone, dateProp.getName(), makeInclusive);
    }

    private static Date normalizeDate(Date date, boolean shouldBeDate, net.fortuna.ical4j.model.TimeZone expectedTimeZone, String name, boolean makeInclusive) {
        if (date == null) {
            return null;
        }
        if (date instanceof DateTime) {
            if (shouldBeDate) {
                log.warn("Unexpected DateTime found where a Date should be present at " + name + ": " + date.toString() + ". Converting.");
                return new Date((java.util.Date)date);
            }
            DateTime dateTime = new DateTime((java.util.Date)date);
            net.fortuna.ical4j.model.TimeZone timeZone = ICalEventMapper.normalizeTimeZone(dateTime.getTimeZone(), dateTime.isUtc());
            if (timeZone == null && expectedTimeZone == null) {
                return date;
            }
            if (timeZone == null && expectedTimeZone != null) {
                log.warn("Unexpected floating time found at " + name + ": " + date.toString() + ". Forcing timezone " + expectedTimeZone.getID());
                dateTime.setTimeZone(expectedTimeZone);
            } else if (timeZone != null && expectedTimeZone == null) {
                log.warn("Unexpected non-floating time found at " + name + ": " + date.toString() + ". Removing timezone.");
                dateTime.setTimeZone(null);
            } else {
                if (timeZone.getID().equals(expectedTimeZone.getID())) {
                    return date;
                }
                log.warn("Non-matching timezone found at " + name + ": " + date.toString() + ". Changing timezone from " + timeZone.getID() + " to " + expectedTimeZone.getID());
                dateTime.setTimeZone(expectedTimeZone);
            }
            return dateTime;
        }
        if (shouldBeDate) {
            if (makeInclusive) {
                return ICalEventMapper.subtractOneDay(date);
            }
            return date;
        }
        log.warn("Unexpected Date where a DateTime should be present at " + name + ": " + date.toString() + ". Converting.");
        DateTime dt = new DateTime((java.util.Date)date);
        dt.setTimeZone(expectedTimeZone);
        return dt;
    }

    private static Date subtractOneDay(Date date) {
        Date dayBefore = new Date((java.util.Date)date);
        dayBefore.setTime(dayBefore.getTime() - 86400000L);
        return dayBefore;
    }

    private static Date addOneDay(Date date) {
        Date dayAfter = new Date((java.util.Date)date);
        dayAfter.setTime(dayAfter.getTime() + 86400000L);
        return dayAfter;
    }

    private static net.fortuna.ical4j.model.TimeZone normalizeTimeZone(net.fortuna.ical4j.model.TimeZone timeZone, boolean isUtc) {
        if (isUtc) {
            return UTC_TIMEZONE;
        }
        if (timeZone != null && TimeZones.isUtc((TimeZone)timeZone)) {
            return UTC_TIMEZONE;
        }
        return timeZone;
    }

    private static net.fortuna.ical4j.model.TimeZone getTimeZone(String tzID, TimeZoneRegistry tzRegistry) {
        net.fortuna.ical4j.model.TimeZone timeZone = tzID == null ? null : ("Etc/UTC".equals(tzID) ? UTC_TIMEZONE : tzRegistry.getTimeZone(tzID));
        return timeZone;
    }

    public static boolean isPureDate(DateProperty dateProp) {
        return !(dateProp.getDate() instanceof DateTime);
    }

    public static int getDefaultTZOffset(long time) {
        return net.fortuna.ical4j.model.TimeZone.getDefault().getOffset(time);
    }

    public static Calendar icalDate2Calendar(Date date) {
        Calendar cal = Calendar.getInstance();
        if (date instanceof DateTime) {
            DateTime dateTime = (DateTime)date;
            if (dateTime.isUtc()) {
                cal.setTimeZone((TimeZone)UTC_TIMEZONE);
            } else {
                net.fortuna.ical4j.model.TimeZone tz = dateTime.getTimeZone();
                if (tz == null) {
                    cal.setTimeZone((TimeZone)UTC_TIMEZONE);
                    cal.setTimeInMillis(date.getTime() + (long)ICalEventMapper.getDefaultTZOffset(date.getTime()));
                    return cal;
                }
                cal.setTimeZone((TimeZone)tz);
            }
        } else {
            cal.setTimeZone((TimeZone)UTC_TIMEZONE);
        }
        cal.setTimeInMillis(date.getTime());
        return cal;
    }

    public static Date calendar2icalDate(Calendar cal, boolean isDate, net.fortuna.ical4j.model.TimeZone timeZone) {
        Date date;
        if (isDate) {
            date = new Date(cal.getTimeInMillis());
        } else {
            if (timeZone == null) {
                DateTime date2 = new DateTime();
                date2.setTimeZone(null);
                date2.setTime(cal.getTimeInMillis() - (long)ICalEventMapper.getDefaultTZOffset(cal.getTimeInMillis()));
                return date2;
            }
            date = new DateTime();
            if (TimeZones.isUtc((TimeZone)timeZone)) {
                ((DateTime)date).setUtc(true);
            } else {
                ((DateTime)date).setTimeZone(timeZone);
            }
            date.setTime(cal.getTimeInMillis());
        }
        return date;
    }

    private static VTimeZone loadVTimeZone(String ics) {
        try {
            CalendarBuilder builder = new CalendarBuilder();
            net.fortuna.ical4j.model.Calendar calendar = builder.build((Reader)new StringReader(ics));
            VTimeZone vTimeZone = (VTimeZone)calendar.getComponent("VTIMEZONE");
            return vTimeZone;
        }
        catch (Exception e) {
            log.error("Could not parse built-in timezone definition: " + ics, (Throwable)e);
            return null;
        }
    }

    public static String generateUID() {
        return UUID.randomUUID().toString().toUpperCase();
    }
}

