/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.collab.calendar.impl;

import com.day.cq.collab.calendar.impl.CqCalendarImpl;
import com.day.cq.collab.calendar.impl.EventImpl;
import com.day.cq.collab.calendar.impl.ICalEventMapper;
import com.day.cq.collab.calendar.impl.JcrUtils;
import com.day.cq.collab.calendar.impl.RecurrenceHandler;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.util.CompatibilityHints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ICalImporter {
    private static final Logger log = LoggerFactory.getLogger(ICalImporter.class);
    private CqCalendarImpl calendar;

    public ICalImporter(CqCalendarImpl calendar) {
        this.calendar = calendar;
    }

    public void importStream(InputStream iCalendarStream) throws IOException {
        CalendarBuilder builder = new CalendarBuilder();
        Node node = this.calendar.getNode();
        try {
            CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
            CompatibilityHints.setHintEnabled((String)"ical4j.parsing.relaxed", (boolean)true);
            CompatibilityHints.setHintEnabled((String)"ical4j.validation.relaxed", (boolean)true);
            CompatibilityHints.setHintEnabled((String)"ical4j.compatibility.notes", (boolean)true);
            CompatibilityHints.setHintEnabled((String)"ical4j.compatibility.outlook", (boolean)true);
            Calendar calendar = builder.build(iCalendarStream);
            log.info("importing icalendar into " + JcrUtils.safeGetPath(node, log));
            for (Component component : calendar.getComponents()) {
                if (!(component instanceof VEvent)) continue;
                this.storeEvent((VEvent)component);
            }
            node.save();
        }
        catch (ParserException e) {
            IOException ioe = new IOException("Could not import icalendar at " + JcrUtils.safeGetPath(node, log));
            ioe.initCause(e);
            throw ioe;
        }
        catch (RepositoryException e) {
            IOException ioe = new IOException("Could not import icalendar at " + JcrUtils.safeGetPath(node, log));
            ioe.initCause(e);
            throw ioe;
        }
    }

    private void storeEvent(VEvent icalEvent) throws RepositoryException {
        Summary summary = icalEvent.getSummary();
        Uid uid = icalEvent.getUid();
        if (uid == null) {
            log.warn("ignoring event without UID" + (summary != null ? " ('" + summary.getValue() + "')" : ""));
            return;
        }
        DtStart startDate = icalEvent.getStartDate();
        if (startDate == null) {
            log.warn("ignoring event without start date (" + (summary != null ? "'" + summary.getValue() + "'" : uid) + ")");
            return;
        }
        DtEnd endDate = icalEvent.getEndDate();
        if (endDate == null) {
            log.warn("ignoring event without end date (" + (summary != null ? "'" + summary.getValue() + "'" : uid) + ")");
            return;
        }
        Node node = null;
        String importCopyUID = EventImpl.getImportCopyUIDFor(uid.getValue());
        EventImpl event = (EventImpl)this.calendar.findEvent(importCopyUID);
        if (event != null) {
            log.info("local modification found for already imported event, overwriting cloned event: UID '" + uid.getValue() + "', path of cloned event '" + event.getPath() + "'");
            uid.setValue(importCopyUID);
            node = this.replaceNode(event.getNode());
            ICalEventMapper.writeEventNode(icalEvent, node);
            event = this.calendar.getEventImpl(node.getPath());
            RecurrenceHandler.replaceRecurrences(event, icalEvent);
        } else {
            event = (EventImpl)this.calendar.findEvent(uid.getValue());
            if (event != null) {
                String previousMD5 = event.getRemoteLastImportMD5();
                String currentMD5 = ICalEventMapper.generateMD5(icalEvent);
                if (currentMD5.equals(previousMD5)) {
                    log.info("no changes found for already imported event: UID '" + uid.getValue() + "', path '" + event.getPath() + "'");
                } else if (event.isModifiedSinceLastImport()) {
                    log.info("local modification found for already imported event: UID '" + uid.getValue() + "', path '" + event.getPath() + "'");
                    uid.setValue(importCopyUID);
                    node = this.createNode((DateProperty)startDate, summary, uid, "event", "cq:CalendarEvent");
                    log.info("adding cloned event: UID '" + uid.getValue() + "', path '" + node.getPath() + "'");
                    ICalEventMapper.writeEventNode(icalEvent, node);
                    event = this.calendar.getEventImpl(node.getPath());
                    RecurrenceHandler.addRecurrences(event, null);
                } else {
                    log.info("no local changes found for already imported event, overwriting with import: UID '" + uid.getValue() + "', path '" + event.getPath() + "'");
                    node = this.replaceNode(event.getNode());
                    ICalEventMapper.writeEventNode(icalEvent, node);
                    event = this.calendar.getEventImpl(node.getPath());
                    RecurrenceHandler.replaceRecurrences(event, icalEvent);
                }
            } else {
                node = this.createNode((DateProperty)startDate, summary, uid, "event", "cq:CalendarEvent");
                log.info("importing new event: UID '" + uid.getValue() + "', path '" + node.getPath() + "'");
                ICalEventMapper.writeEventNode(icalEvent, node);
                event = this.calendar.getEventImpl(node.getPath());
                RecurrenceHandler.addRecurrences(event, icalEvent);
            }
        }
    }

    private Node createNode(DateProperty startDate, Summary summary, Uid uid, String fallbackName, String nodeType) throws RepositoryException {
        return this.calendar.createNode(ICalEventMapper.icalDate2Calendar(startDate.getDate()), summary != null ? summary.getValue() : null, uid != null ? uid.getValue() : null, fallbackName, nodeType);
    }

    private Node replaceNode(Node node) throws RepositoryException {
        String name = node.getName();
        String type = node.getPrimaryNodeType().getName();
        Node parent = node.getParent();
        node.remove();
        return parent.addNode(name, type);
    }
}

