/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.collab.calendar.impl;

import com.day.cq.collab.calendar.impl.EventImpl;
import com.day.cq.collab.calendar.impl.ICalEventMapper;
import com.day.cq.collab.calendar.impl.JcrUtils;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class RecurrenceHandler {
    private static final Logger log = LoggerFactory.getLogger(RecurrenceHandler.class);

    public static void replaceRecurrences(EventImpl originalEvent, VEvent icalEvent) throws RepositoryException {
        RecurrenceHandler.deleteAllRecurrences(originalEvent.resource.getResourceResolver(), originalEvent.getPath());
        RecurrenceHandler.addRecurrences(originalEvent, icalEvent);
    }

    public static Dur getStandardRecurDuration() {
        return new Dur(520);
    }

    public static void addRecurrences(EventImpl jcrEvent, VEvent originalEvent) throws RepositoryException {
        if (jcrEvent == null) {
            return;
        }
        if (originalEvent == null) {
            if (!jcrEvent.getNode().hasNode("recurrence")) {
                return;
            }
            originalEvent = jcrEvent.createVEvent();
        }
        List<VEvent> recurrences = RecurrenceHandler.calculateRecurrences(originalEvent, RecurrenceHandler.getStandardRecurDuration(), 0);
        for (VEvent recurrence : recurrences) {
            Node node = jcrEvent.getCalendarImpl().createNode(ICalEventMapper.icalDate2Calendar(recurrence.getStartDate().getDate()), recurrence.getSummary() != null ? recurrence.getSummary().getValue() : null, recurrence.getUid() != null ? recurrence.getUid().getValue() : null, "event", "cq:CalendarEvent");
            log.info("adding recurring event instance: path '" + node.getPath() + "' " + "(start " + (ICalEventMapper.isPureDate((DateProperty)recurrence.getStartDate()) ? "DATE" : "DATE-TIME") + ": " + recurrence.getStartDate().getDate() + ")");
            JcrUtils.copy(jcrEvent.getNode(), node, true);
            ICalEventMapper.writeStartEnd(recurrence, node);
            node.setProperty("recurrenceOf", jcrEvent.getPath(), 8);
            if (node.hasNode("recurrence")) {
                node.getNode("recurrence").remove();
            }
            node.setProperty("remoteLastImportMD5", (String)null);
            node.setProperty("localLastImportMD5", (String)null);
        }
    }

    public static void deleteRecurrences(EventImpl event, Set<String> exclusions) throws RepositoryException {
        RecurrenceHandler.deleteRecurrences(event.resource.getResourceResolver(), event.getPath(), exclusions);
    }

    public static void deleteAllRecurrences(ResourceResolver resolver, String pathOfOriginalEvent) throws RepositoryException {
        RecurrenceHandler.deleteRecurrences(resolver, pathOfOriginalEvent, null);
    }

    public static void deleteRecurrences(ResourceResolver resolver, String pathOfOriginalEvent, Set<String> exclusions) throws RepositoryException {
        Iterator<Resource> recurrences = RecurrenceHandler.getRecurrences(resolver, pathOfOriginalEvent);
        while (recurrences.hasNext()) {
            Node node = (Node)recurrences.next().adaptTo(Node.class);
            if (node == null || exclusions != null && exclusions.contains(node.getPath())) continue;
            node.remove();
        }
    }

    public static Iterator<Resource> getRecurrences(ResourceResolver resolver, String pathOfOriginalEvent) {
        return resolver.findResources("//element(*, cq:CalendarEvent)[@recurrenceOf='" + pathOfOriginalEvent + "'] order by @" + "start", "xpath");
    }

    public static void takeOutOfRecurrence(EventImpl event, boolean delete) throws RepositoryException {
        Iterator<Resource> recurrences;
        Node node = event.getNode();
        if (event.isRecurrence()) {
            Node original = ((EventImpl)event.getOriginal()).getNode();
            RecurrenceHandler.addDateToExceptions(original, node.getProperty("start").getDate());
        } else if (event.isRecurringSeries() && (recurrences = RecurrenceHandler.getRecurrences(event.resource.getResourceResolver(), event.getPath())).hasNext()) {
            Resource firstRecurRes = recurrences.next();
            Node firstRecurrence = (Node)firstRecurRes.adaptTo(Node.class);
            RecurrenceHandler.deleteRecurrences(event, RecurrenceHandler.arrayAsSet(firstRecurrence.getPath()));
            firstRecurrence.setProperty("recurrenceOf", (String)null);
            JcrUtil.copy((Node)node.getNode("recurrence"), (Node)firstRecurrence, null, (boolean)true);
            if (firstRecurrence.hasNode("recurrence")) {
                javax.jcr.Property exceptionsProp;
                Calendar start = firstRecurrence.getProperty("start").getDate();
                Node recur = firstRecurrence.getNode("recurrence");
                int exceptionsToIgnore = 0;
                if (recur.hasProperty("exceptions") && (exceptionsProp = recur.getProperty("exceptions")).isMultiple()) {
                    Value[] values = exceptionsProp.getValues();
                    ArrayList<Value> newValues = new ArrayList<Value>();
                    for (Value v : values) {
                        if (v.getDate().before(start)) continue;
                        newValues.add(v);
                    }
                    exceptionsToIgnore = values.length - newValues.size();
                    exceptionsProp.setValue(newValues.toArray(new Value[0]));
                }
                NodeIterator ruleNodes = recur.getNodes();
                while (ruleNodes.hasNext()) {
                    long count;
                    javax.jcr.Property countProp;
                    Node rule = ruleNodes.nextNode();
                    if (!rule.isNodeType("cq:CalendarRecurrenceRule") || !rule.hasProperty("count") || (countProp = rule.getProperty("count")).getType() != 3 || (count = countProp.getLong()) <= 0L) continue;
                    countProp.setValue(count - (long)exceptionsToIgnore - 1L);
                }
            }
            RecurrenceHandler.addRecurrences(new EventImpl(firstRecurRes, event.getCalendarImpl(), event.getBundleVersion()), null);
        }
        if (delete) {
            node.remove();
        } else {
            node.setProperty("uid", ICalEventMapper.generateUID());
            if (node.hasNode("recurrence")) {
                node.getNode("recurrence").remove();
            }
            node.setProperty("recurrenceOf", (Value)null);
        }
    }

    private static void addDateToExceptions(Node eventNode, Calendar exDate) throws RepositoryException {
        Node recurNode = eventNode.hasNode("recurrence") ? eventNode.getNode("recurrence") : eventNode.addNode("recurrence", "cq:CalendarRecurrence");
        Value dateValue = eventNode.getSession().getValueFactory().createValue(exDate);
        JcrUtils.addValue(recurNode, "exceptions", dateValue);
    }

    public static List<VEvent> calculateRecurrences(VEvent originalEvent, Dur duration, int limit) {
        ArrayList<VEvent> events = new ArrayList<VEvent>();
        boolean startIsDate = ICalEventMapper.isPureDate((DateProperty)originalEvent.getStartDate());
        boolean endIsDate = ICalEventMapper.isPureDate((DateProperty)originalEvent.getEndDate());
        Period recurrencePeriod = new Period(new DateTime((java.util.Date)originalEvent.getStartDate().getDate()), duration);
        PeriodList periods = originalEvent.calculateRecurrenceSet(recurrencePeriod);
        for (Period period : periods) {
            VEvent recurrence;
            if (!period.getStart().after((java.util.Date)originalEvent.getStartDate().getDate())) continue;
            try {
                recurrence = (VEvent)originalEvent.copy();
            }
            catch (Exception e) {
                log.error("Could not create recurrence copy of ical4j VEvent", (Throwable)e);
                continue;
            }
            recurrence.getProperties().remove((Property)recurrence.getStartDate());
            recurrence.getProperties().remove((Property)recurrence.getEndDate());
            recurrence.getProperties().remove((Property)recurrence.getDuration());
            if (startIsDate) {
                recurrence.getProperties().add((Property)new DtStart(new Date((java.util.Date)period.getStart())));
            } else {
                recurrence.getProperties().add((Property)new DtStart((Date)period.getStart()));
            }
            if (endIsDate) {
                recurrence.getProperties().add((Property)new DtEnd(new Date((java.util.Date)period.getEnd())));
            } else {
                recurrence.getProperties().add((Property)new DtEnd((Date)period.getEnd()));
            }
            events.add(recurrence);
            if (limit <= 0 || events.size() != limit) continue;
            break;
        }
        return events;
    }

    public static <T> Set<T> arrayAsSet(T ... array) {
        HashSet<T> set = new HashSet<T>(array.length);
        for (T obj : array) {
            set.add(obj);
        }
        return set;
    }
}

