/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.collab.calendar.impl.workflow;

import com.day.cq.collab.calendar.CalendarComponent;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.ArrayList;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(metatype=false)
@Service(value={WorkflowProcess.class})
@Property(name="process.label", value={"Calendar Subscription"})
public class CalendarSubscriptionProcess
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(CalendarSubscriptionProcess.class);
    public static final String TARGET_METADATA = "target";
    @Reference
    protected JcrResourceResolverFactory jcrResourceResolverFactory;
    private static final String TYPE_JCR_PATH = "JCR_PATH";
    private static final String TYPE_JCR_UUID = "JCR_UUID";

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData) throws WorkflowException {
        block5: {
            try {
                String[] args = this.buildArguments(metaData);
                Session session = workflowSession.getSession();
                ResourceResolver resolver = this.jcrResourceResolverFactory.getResourceResolver(session);
                Node sourceNode = CalendarSubscriptionProcess.getNodeFromPayload(workItem, workflowSession);
                Resource target = CalendarSubscriptionProcess.getTarget(workItem, resolver);
                if (sourceNode != null && target != null) {
                    CalendarComponent targetCalendar = new CalendarComponent(target);
                    if (CalendarSubscriptionProcess.unsubscribe(args)) {
                        log.info("Unsubscribing '" + sourceNode.getPath() + "' from '" + target.getPath() + "'");
                        targetCalendar.unsubscribeFrom(sourceNode.getPath());
                    } else {
                        log.info("Subscribing '" + sourceNode.getPath() + "' to '" + target.getPath() + "'");
                        targetCalendar.subscribeTo(sourceNode.getPath());
                    }
                    break block5;
                }
                throw new WorkflowException("Could not subscribe calendar or event as source or target are missing.");
            }
            catch (RepositoryException e) {
                throw new WorkflowException((Throwable)e);
            }
        }
    }

    protected static Resource getTarget(WorkItem workItem, ResourceResolver resolver) {
        String target = (String)workItem.getWorkflow().getMetaDataMap().get(TARGET_METADATA, String.class);
        if (target != null) {
            return resolver.getResource(target);
        }
        return null;
    }

    protected static boolean unsubscribe(String[] args) {
        if (args != null && args.length > 0) {
            return SubscriptionModes.UNSUBSCRIBE.getArgumentValue().equals(args[0]);
        }
        return false;
    }

    public static Node getNodeFromPayload(WorkItem workItem, WorkflowSession wfSession) {
        Session session = wfSession.getSession();
        WorkflowData data = workItem.getWorkflowData();
        if (data.getPayload() == null) {
            return null;
        }
        String payloadData = data.getPayload().toString();
        String type = data.getPayloadType();
        try {
            if (TYPE_JCR_PATH.equals(type)) {
                Item item = session.getItem(payloadData);
                if (item.isNode()) {
                    return (Node)item;
                }
                log.warn("Workflow payload path points to a JCR property instead of a node: '" + payloadData + "'");
            } else {
                if (TYPE_JCR_UUID.equals(type)) {
                    return session.getNodeByUUID(payloadData);
                }
                log.warn("Workflow payload is not the expected JCR path or UUID: '" + payloadData + "'");
            }
        }
        catch (PathNotFoundException e) {
            log.warn("JCR path in workflow payload not found: '" + payloadData + "'");
        }
        catch (ItemNotFoundException e) {
            log.warn("JCR UUID in workflow payload not found: '" + payloadData + "'");
        }
        catch (RepositoryException e) {
            log.error("Error while retrieving JCR node from workflow payload '" + payloadData + "'", (Throwable)e);
        }
        return null;
    }

    public String[] buildArguments(MetaDataMap metaData) {
        String processArgs = (String)metaData.get(Arguments.PROCESS_ARGS.name(), String.class);
        if (processArgs != null && !processArgs.equals("")) {
            return processArgs.split(",");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        String value = (String)metaData.get(Arguments.MODE.name(), String.class);
        if (StringUtils.isNotBlank((String)value)) {
            try {
                SubscriptionModes mode = SubscriptionModes.valueOf(value.toUpperCase());
                arguments.add(mode.getArgumentValue());
            }
            catch (IllegalArgumentException e) {
                log.error("illegal process argument [{}].", (Object)value);
            }
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    protected void bindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.jcrResourceResolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.jcrResourceResolverFactory == jcrResourceResolverFactory) {
            this.jcrResourceResolverFactory = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SubscriptionModes {
        UNSUBSCRIBE("unsubscribe"),
        SUBSCRIBE("subscribe");

        private String argumentValue;

        private SubscriptionModes(String argumentValue) {
            this.argumentValue = argumentValue;
        }

        public String getArgumentValue() {
            return this.argumentValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Arguments {
        PROCESS_ARGS,
        MODE;

    }
}

