/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.collab.calendar.servlets;

import com.day.cq.collab.calendar.CqCalendar;
import com.day.cq.collab.calendar.Event;
import com.day.cq.collab.calendar.impl.CqCalendarImpl;
import com.day.cq.collab.calendar.impl.EventImpl;
import com.day.cq.collab.calendar.impl.JcrTimeZoneRegistry;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.fortuna.ical4j.data.FoldingWriter;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.property.Method;
import org.apache.commons.lang.ArrayUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;

@Deprecated
@Component(metatype=false)
@Service
@Properties(value={@Property(name="service.description", value={"CQ SocialCollab iCalendar Export Servlet"}), @Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}), @Property(name="sling.servlet.extensions", value={"ics"})})
public class ICalExportServlet
extends SlingSafeMethodsServlet {
    public static final String EVENT_SELECTOR = "event";
    public static final String METHOD_REQUEST_SELECTOR = "request";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/calendar");
        response.setCharacterEncoding("utf-8");
        Resource resource = request.getResource();
        Boolean includeTimezone = false;
        if (this.isCalendar(request)) {
            CqCalendarImpl cal = (CqCalendarImpl)resource.adaptTo(CqCalendar.class);
            StringBuffer icalStart = new StringBuffer();
            icalStart.append("BEGIN");
            icalStart.append(':');
            icalStart.append("VCALENDAR");
            icalStart.append("\r\n");
            Method method = Method.PUBLISH;
            if (ArrayUtils.contains((Object[])request.getRequestPathInfo().getSelectors(), (Object)METHOD_REQUEST_SELECTOR)) {
                method = Method.REQUEST;
            }
            icalStart.append(cal.createICal4jCalendar(false, method).getProperties());
            this.printFoldedString(icalStart.toString(), response.getWriter());
            this.include(request.getResource(), EVENT_SELECTOR, request, response);
            StringBuffer icalEnd = new StringBuffer();
            icalEnd.append("END");
            icalEnd.append(':');
            icalEnd.append("VCALENDAR");
            icalEnd.append("\r\n");
            this.printFoldedString(icalEnd.toString(), response.getWriter());
        } else {
            EventImpl event = (EventImpl)resource.adaptTo(Event.class);
            if (event != null && !event.isRecurrence()) {
                String timezone;
                JcrTimeZoneRegistry tzRegistry;
                TimeZone timeZone;
                if (!includeTimezone.booleanValue() && (timeZone = (tzRegistry = new JcrTimeZoneRegistry()).getTimeZone(timezone = (String)event.getProperties().get("timeZone", String.class))) != null) {
                    this.printFoldedString(timeZone.getVTimeZone().toString(), response.getWriter());
                    includeTimezone = true;
                }
                this.printFoldedString(event.toICalendarString(), response.getWriter());
            } else {
                this.includeChildren(request.getResource(), EVENT_SELECTOR, request, response);
            }
        }
    }

    private boolean isCalendar(SlingHttpServletRequest request) {
        return !ArrayUtils.contains((Object[])request.getRequestPathInfo().getSelectors(), (Object)EVENT_SELECTOR);
    }

    private void include(Resource resource, String selector, SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("com.day.cq.wcm.api.components.ComponentContext/bypass", (Object)"true");
        String includeURL = resource.getPath() + "." + selector + "." + request.getRequestPathInfo().getExtension();
        request.getRequestDispatcher(includeURL).include((ServletRequest)request, (ServletResponse)response);
    }

    private void includeChildren(Resource resource, String selector, SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("com.day.cq.wcm.api.components.ComponentContext/bypass", (Object)"true");
        Iterator iter = request.getResourceResolver().listChildren(resource);
        while (iter.hasNext()) {
            Resource res = (Resource)iter.next();
            String includeURL = res.getPath() + "." + selector + "." + request.getRequestPathInfo().getExtension();
            request.getRequestDispatcher(includeURL).include((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void printFoldedString(String icalString, PrintWriter writer) throws IOException {
        FoldingWriter foldingWriter = new FoldingWriter((Writer)writer, 73);
        foldingWriter.write(icalString);
    }
}

