/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.collab.calendar.servlets;

import com.day.cq.collab.calendar.CalendarException;
import com.day.cq.collab.calendar.CalendarManager;
import com.day.cq.collab.calendar.CqCalendar;
import com.day.cq.commons.servlets.NonExistingResourceServlet;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;

@Deprecated
@Component(metatype=false)
@Service(value={NonExistingResourceServlet.class})
@Property(name="service.ranking", intValue={0})
public class ICalNewImportServlet
extends SlingAllMethodsServlet
implements NonExistingResourceServlet {
    private static final String ICS_EXTENSION = "ics";

    public boolean accepts(SlingHttpServletRequest request) {
        RequestParameter fileParam = request.getRequestParameter("file");
        String extension = this.getExtension(request.getResource().getPath());
        return ICS_EXTENSION.equals(extension) && fileParam != null;
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        RequestParameter fileParam = request.getRequestParameter("file");
        if (fileParam == null) {
            response.sendError(400, "Request parameter 'file' containing calendar data is missing");
            return;
        }
        CalendarManager calendarManager = (CalendarManager)request.getResourceResolver().adaptTo(CalendarManager.class);
        String path = this.getPathWithoutExtension(request.getResource().getPath());
        try {
            CqCalendar calendar = calendarManager.createCalendar(path);
            calendar.importICS(fileParam.getInputStream());
            HtmlResponse htmlResponse = new HtmlResponse();
            htmlResponse.setPath(calendar.getPath());
            htmlResponse.setStatus(200, "OK");
            htmlResponse.send((HttpServletResponse)response, true);
        }
        catch (CalendarException e) {
            response.sendError(500, e.getMessage() + ": " + e.getCause().getMessage());
            return;
        }
    }

    private String getExtension(String path) {
        int lastDot = path.lastIndexOf(".");
        if (lastDot >= 0) {
            return path.substring(lastDot + 1);
        }
        return null;
    }

    private String getPathWithoutExtension(String path) {
        int lastDot = path.lastIndexOf(".");
        if (lastDot >= 0) {
            return path.substring(0, lastDot);
        }
        return path;
    }
}

