/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.collab.calendar.servlets;

import com.day.cq.collab.calendar.Event;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import net.fortuna.ical4j.data.FoldingWriter;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.model.property.XProperty;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(metatype=false)
@Service
@Property(name="sling.servlet.paths", value={"/bin/querybuilder.ics"})
public class QueryBuilderICalServlet
extends SlingAllMethodsServlet {
    private static Logger log = LoggerFactory.getLogger(QueryBuilderICalServlet.class);
    @Reference
    protected QueryBuilder queryBuilder;
    private String bundleVersion;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.handleQuery(request, response);
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.handleQuery(request, response);
    }

    private void handleQuery(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/calendar");
        response.setCharacterEncoding("utf-8");
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        Query query = this.queryBuilder.createQuery(PredicateGroup.create((Map)request.getParameterMap()), session);
        SearchResult result = query.getResult();
        FoldingWriter foldingWriter = new FoldingWriter((Writer)response.getWriter(), 73);
        StringBuffer icalStart = new StringBuffer();
        icalStart.append("BEGIN");
        icalStart.append(':');
        icalStart.append("VCALENDAR");
        icalStart.append("\r\n");
        Calendar iCalendar = new Calendar();
        PropertyList p = iCalendar.getProperties();
        p.add((net.fortuna.ical4j.model.Property)Method.PUBLISH);
        p.add((net.fortuna.ical4j.model.Property)CalScale.GREGORIAN);
        p.add((net.fortuna.ical4j.model.Property)Version.VERSION_2_0);
        p.add((net.fortuna.ical4j.model.Property)new ProdId("-//Day Software//CQ5 Calendar " + this.bundleVersion + "//EN"));
        String calName = request.getParameter("p.calname");
        p.add((net.fortuna.ical4j.model.Property)new XProperty("X-WR-CALNAME", calName != null ? calName : "cq5 export"));
        icalStart.append(iCalendar.getProperties());
        foldingWriter.write(icalStart.toString());
        for (Hit hit : result.getHits()) {
            try {
                Event event = (Event)hit.getResource().adaptTo(Event.class);
                if (event == null || event.isRecurrence()) continue;
                foldingWriter.write(event.toICalendarString());
            }
            catch (RepositoryException e) {
                log.error("Error reading result of querybuilder", (Throwable)e);
            }
        }
        StringBuffer icalEnd = new StringBuffer();
        icalEnd.append("END");
        icalEnd.append(':');
        icalEnd.append("VCALENDAR");
        icalEnd.append("\r\n");
        foldingWriter.write(icalEnd.toString());
    }

    protected void activate(ComponentContext context) {
        this.bundleVersion = (String)context.getBundleContext().getBundle().getHeaders().get("Bundle-Version");
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }
}

