/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.collab.calendar.servlets;

import com.day.cq.collab.calendar.CalendarUtil;
import com.day.cq.collab.calendar.impl.JcrTimeZoneRegistry;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.ServletException;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.NumberList;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.WeekDayList;
import net.fortuna.ical4j.model.component.Daylight;
import net.fortuna.ical4j.model.component.Observance;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.RDate;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.TzName;
import net.fortuna.ical4j.model.property.TzUrl;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;

@Deprecated
@Component(label="Day CQ Social Collaboration TimeZone Servlet", description="Servlet that provides JSON formatted olson timezone data")
@Service
@Properties(value={@Property(name="service.description", value={"CQ Social Collaboration TimeZone Servlet"}), @Property(propertyPrivate=true, name="sling.servlet.resourceTypes", value={"sling/servlet/default"}), @Property(propertyPrivate=true, name="sling.servlet.selectors", value={"timezones"}), @Property(propertyPrivate=true, name="sling.servlet.extensions", value={"json"})})
public class TimeZoneServlet
extends SlingSafeMethodsServlet {
    private static final long MS_PER_MINUTE = 60000L;
    @Property(intValue={10080})
    private static final String EXPIRY_TIME = "timezones.expirytime";
    private long expiryTime;
    private static final String UTC_PATTERN = "yyyyMMdd'T'HHmmss";
    private static final DateFormat UTC_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HHmmss", Locale.US);
    private static final DateFormat ECMA_DATE_FORMAT = CalendarUtil.getEcmaDateFormat(false, "Etc/UTC");

    protected void activate(ComponentContext context) {
        this.expiryTime = OsgiUtil.toLong(context.getProperties().get(EXPIRY_TIME), (long)10080L);
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        response.setDateHeader("Expires", System.currentTimeMillis() + this.expiryTime * 60000L);
        JcrTimeZoneRegistry registry = new JcrTimeZoneRegistry();
        PrintWriter out = response.getWriter();
        JSONWriter writer = new JSONWriter((Writer)out);
        try {
            String suffix = request.getRequestPathInfo().getSuffix();
            if (suffix != null) {
                TimeZone tz;
                if (suffix.startsWith("/")) {
                    suffix = suffix.substring(1);
                }
                if ((tz = registry.getTimeZone(suffix)) != null) {
                    this.writeVTimeZone(tz.getVTimeZone(), writer);
                } else {
                    response.sendError(404, "Timezone was not found: " + suffix);
                }
            } else {
                writer.array();
                for (String tzID : registry.getTimeZoneIDs()) {
                    writer.object();
                    TimeZone tz = registry.getTimeZone(tzID);
                    writer.key("value").value((Object)tzID);
                    writer.key("text");
                    Calendar now = Calendar.getInstance();
                    int offset = tz.getOffset(now.getTimeInMillis());
                    int hours = offset / 3600000;
                    int minutes = Math.abs(offset % 3600000 / 60000);
                    Observance observance = tz.getVTimeZone().getApplicableObservance(new Date(now.getTimeInMillis()));
                    TzName tzName = (TzName)observance.getProperty("TZNAME");
                    if (tzName != null) {
                        writer.value((Object)(tzID + " (" + TimeZoneServlet.twoDigitSigned(hours) + ":" + TimeZoneServlet.twoDigit(minutes) + ", " + tzName.getValue() + ")"));
                    } else {
                        writer.value((Object)(tzID + " (" + TimeZoneServlet.twoDigitSigned(hours) + ":" + TimeZoneServlet.twoDigit(minutes) + ")"));
                    }
                    writer.endObject();
                }
                writer.endArray();
            }
        }
        catch (JSONException e) {
            ServletException se = new ServletException("Error creating timezone json response", (Throwable)e);
            se.initCause((Throwable)e);
            throw se;
        }
    }

    private void writeVTimeZone(VTimeZone vtz, JSONWriter writer) throws JSONException {
        LastModified lastModified;
        writer.object();
        writer.key("tzID").value((Object)vtz.getTimeZoneId().getValue());
        TzUrl tzUrl = vtz.getTimeZoneUrl();
        if (tzUrl != null) {
            writer.key("tzURL").value((Object)tzUrl.getValue());
        }
        if ((lastModified = vtz.getLastModified()) != null) {
            writer.key("lastMod").value((Object)ECMA_DATE_FORMAT.format((java.util.Date)lastModified.getDateTime()));
        }
        writer.key("observances");
        writer.array();
        ComponentList observances = vtz.getObservances();
        Collections.sort(observances);
        for (Object obj : observances) {
            Observance observance = (Observance)obj;
            this.writeObservance(observance, writer);
        }
        writer.endArray();
        writer.endObject();
    }

    private void writeObservance(Observance observance, JSONWriter writer) throws JSONException {
        PropertyList rules;
        TzName tzName;
        writer.object();
        if (observance instanceof Daylight) {
            writer.key("daylight").value(true);
        }
        if ((tzName = (TzName)observance.getProperty("TZNAME")) != null) {
            writer.key("tzName").value((Object)tzName.getValue());
        }
        writer.key("offsetFrom").value(observance.getOffsetFrom().getOffset().getOffset());
        writer.key("offsetTo").value(observance.getOffsetTo().getOffset().getOffset());
        writer.key("start").value((Object)this.utcToEcmaDateFormat(observance.getStartDate().getValue()));
        PropertyList rdates = observance.getProperties("RDATE");
        if (rdates.size() > 0) {
            writer.key("dates");
            writer.array();
            for (RDate rdate : rdates) {
                for (Date d : rdate.getDates()) {
                    writer.value((Object)this.utcToEcmaDateFormat(d.toString()));
                }
            }
            writer.endArray();
        }
        if ((rules = observance.getProperties("RRULE")).size() > 0) {
            writer.key("rules");
            writer.array();
            Iterator i = rules.iterator();
            while (i.hasNext()) {
                this.writeRule((RRule)i.next(), writer);
            }
            writer.endArray();
        }
        writer.endObject();
    }

    private void writeRule(RRule rule, JSONWriter writer) throws JSONException {
        WeekDayList weekDayList;
        Recur recur = rule.getRecur();
        writer.object();
        writer.key("frequency").value((Object)recur.getFrequency().toLowerCase());
        int interval = recur.getInterval();
        if (interval > 0) {
            writer.key("interval").value((long)interval);
        }
        if ((weekDayList = recur.getDayList()) != null) {
            writer.key("byWeekDay");
            writer.array();
            for (Object weekDayObj : weekDayList) {
                writer.value((Object)((WeekDay)weekDayObj).getDay());
            }
            writer.endArray();
            writer.key("byWeekDayOffset");
            writer.array();
            for (Object weekDayObj : weekDayList) {
                writer.value((long)((WeekDay)weekDayObj).getOffset());
            }
            writer.endArray();
        }
        this.writeNumberList("byMonthDay", recur.getMonthDayList(), writer);
        this.writeNumberList("byMonth", recur.getMonthList(), writer);
        writer.endObject();
    }

    private void writeNumberList(String key, NumberList list, JSONWriter writer) throws JSONException {
        if (list.size() > 0) {
            writer.key(key);
            writer.array();
            for (Object numberObj : list) {
                int number = (Integer)numberObj;
                writer.value((long)number);
            }
            writer.endArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String utcToEcmaDateFormat(String utcDateTime) {
        java.util.Date start;
        DateFormat dateFormat;
        try {
            dateFormat = UTC_FORMAT;
            synchronized (dateFormat) {
                start = UTC_FORMAT.parse(utcDateTime);
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        dateFormat = ECMA_DATE_FORMAT;
        synchronized (dateFormat) {
            return ECMA_DATE_FORMAT.format(start.getTime());
        }
    }

    private static String twoDigit(int number) {
        if (number >= 0 && number < 10) {
            return "0" + String.valueOf(number);
        }
        return String.valueOf(number);
    }

    private static String twoDigitSigned(int number) {
        String sign = number >= 0 ? "+" : "-";
        if ((number = Math.abs(number)) >= 0 && number < 10) {
            return sign + "0" + String.valueOf(number);
        }
        return sign + String.valueOf(number);
    }

    static {
        UTC_FORMAT.setTimeZone(TimeZone.getTimeZone((String)"Etc/UTC"));
        UTC_FORMAT.setLenient(false);
        ECMA_DATE_FORMAT.setLenient(false);
    }
}

