/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.impl;

import com.day.cq.analytics.Account;
import com.day.cq.analytics.AccountManager;
import com.day.cq.analytics.AccountResourceProvider;
import com.day.cq.analytics.AnalyticsException;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountManagerImpl
implements AccountManager {
    private static final Logger log = LoggerFactory.getLogger(AccountManagerImpl.class);
    private final Session session;
    private final ResourceResolver resolver;

    public AccountManagerImpl(ResourceResolver resolver) {
        this.session = (Session)resolver.adaptTo(Session.class);
        if (this.session == null) {
            throw new IllegalArgumentException("resolver argument must be adaptable to session");
        }
        this.resolver = resolver;
    }

    @Override
    public Account saveAccount(Account account) throws AnalyticsException {
        try {
            Resource accRoot = this.resolver.getResource(account.getAccountsBase());
            if (accRoot != null) {
                Node accRootNode = (Node)accRoot.adaptTo(Node.class);
                Node tmp = null;
                if (account.isNew().booleanValue()) {
                    Long num = accRootNode.getNodes().getSize();
                    tmp = accRootNode.addNode("account" + num);
                } else {
                    tmp = (Node)this.resolver.getResource(account.getPath()).adaptTo(Node.class);
                }
                for (String name : account.getProperties().keySet()) {
                    if (name.startsWith("jcr")) continue;
                    Object v = account.getProperties().get(name);
                    if (v instanceof String) {
                        tmp.setProperty(name, (String)String.class.cast(v));
                        continue;
                    }
                    if (v instanceof Calendar) {
                        tmp.setProperty(name, (Calendar)Calendar.class.cast(v));
                        continue;
                    }
                    if (!(v instanceof BigDecimal)) continue;
                    tmp.setProperty(name, (BigDecimal)BigDecimal.class.cast(v));
                }
                tmp.getSession().save();
                return this.getAccount(account.getClass(), tmp.getPath());
            }
        }
        catch (RepositoryException e) {
            try {
                if (this.session.hasPendingChanges()) {
                    this.session.refresh(false);
                }
            }
            catch (RepositoryException rei) {
                log.error("Unable to refresh session: ", (Throwable)rei);
            }
            throw new AnalyticsException("failed to create account", e);
        }
        return null;
    }

    @Override
    public <T extends Account> T getAccount(Class<T> type, AccountResourceProvider provider) {
        try {
            Resource account = provider.findAccountResource(this.resolver);
            return account == null ? null : (T)this.getInstance(type, account);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public <T extends Account> T getAccount(Class<T> type, String path) {
        Resource account = this.resolver.getResource(path);
        return account == null ? null : (T)this.getInstance(type, account);
    }

    private <T extends Account> T getInstance(Class<T> type, Resource resource) {
        try {
            Constructor<T> cstr = type.getConstructor(Resource.class);
            return (T)((Account)cstr.newInstance(resource));
        }
        catch (Exception e) {
            return null;
        }
    }
}

