/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.impl;

import com.day.cq.analytics.AccountManager;
import com.day.cq.analytics.AnalyticsConfiguration;
import com.day.cq.analytics.AnalyticsException;
import com.day.cq.analytics.impl.AccountManagerImpl;
import com.day.cq.analytics.impl.AnalyticsConfigurationImpl;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyticsAdapterFactory
implements AdapterFactory {
    private static final Logger log = LoggerFactory.getLogger(AnalyticsAdapterFactory.class);
    private static final Class<AnalyticsConfiguration> ANALYTICSCONFIGURATION_CLASS = AnalyticsConfiguration.class;
    private static final Class<AccountManager> ACCOUNTMANAGER_CLASS = AccountManager.class;
    public static final String[] ADAPTER_CLASSES = new String[]{ACCOUNTMANAGER_CLASS.getName(), ANALYTICSCONFIGURATION_CLASS.getName()};
    public static final String[] ADAPTABLE_CLASSES = new String[]{ResourceResolver.class.getName(), Resource.class.getName()};

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        if (adaptable instanceof ResourceResolver) {
            return this.getAdapter((ResourceResolver)adaptable, type);
        }
        if (adaptable instanceof Resource) {
            return this.getAdapter((Resource)adaptable, type);
        }
        return null;
    }

    private <AdapterType> AdapterType getAdapter(Resource resource, Class<AdapterType> type) {
        if (type == ANALYTICSCONFIGURATION_CLASS && resource != null) {
            try {
                return (AdapterType)new AnalyticsConfigurationImpl(resource);
            }
            catch (AnalyticsException e) {
                log.debug("Unable to adapt resource of {} to type {}: {}", new Object[]{resource.getResourceType(), type.getName(), e.getMessage()});
            }
        }
        log.debug("Unable to adapt resource of {} to type {}", (Object)resource.getResourceType(), (Object)type.getName());
        return null;
    }

    private <AdapterType> AdapterType getAdapter(ResourceResolver resolver, Class<AdapterType> type) {
        if (type == ACCOUNTMANAGER_CLASS && resolver != null) {
            return (AdapterType)new AccountManagerImpl(resolver);
        }
        log.debug("Unable to adapt resolver to requested type {}", (Object)type.getName());
        return null;
    }
}

