/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.impl;

import com.day.cq.analytics.AnalyticsConfiguration;
import com.day.cq.analytics.AnalyticsException;
import com.day.cq.analytics.sitecatalyst.SitecatalystAccount;
import com.day.cq.analytics.sitecatalyst.SitecatalystAccountResourceProvider;
import com.day.cq.wcm.api.Page;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyticsConfigurationImpl
implements AnalyticsConfiguration {
    public static final String PN_CLIENTCODE = "cq:ttclientcode";
    public static final String PN_COMPANY = "cq:wsCompany";
    public static final String PN_USERNAME = "cq:wsUsername";
    private Resource resource;
    private Node node;
    private ValueMap valueMap;

    public AnalyticsConfigurationImpl(Resource resource) throws AnalyticsException {
        this.resource = AnalyticsConfigurationImpl.findAnalyticsResource(resource);
        if (this.resource == null) {
            throw new AnalyticsException("No analytics configuration on the resource or one of its ancestors found.");
        }
        this.node = (Node)this.resource.adaptTo(Node.class);
        this.valueMap = ResourceUtil.getValueMap((Resource)this.resource);
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public String getPath() {
        return this.resource.getPath();
    }

    @Override
    public String getPagePath() {
        return this.getPath().replace("/jcr:content/analytics", "");
    }

    @Override
    public String getFormattedPagePath(Page page) {
        String fmtPath = page.getPath();
        String analyticsPath = this.getPagePath();
        if (analyticsPath != null && fmtPath.startsWith(analyticsPath)) {
            fmtPath = fmtPath.replaceFirst(analyticsPath, "");
        }
        if (fmtPath.startsWith("/")) {
            fmtPath = fmtPath.replaceFirst("/", "");
        }
        fmtPath = fmtPath.replaceAll("/", ":");
        return fmtPath;
    }

    @Override
    public Object get(String name) {
        return this.valueMap.get((Object)name);
    }

    @Override
    public <T> T get(String name, Class<T> type) {
        return (T)this.valueMap.get(name, type);
    }

    @Override
    public <T> T get(String name, T defaultValue) {
        return (T)this.valueMap.get(name, defaultValue);
    }

    @Override
    public ValueMap getValueMap() {
        return this.valueMap;
    }

    @Override
    public SitecatalystAccount getSitecatalystAccount() {
        ResourceResolver resolver = this.resource.getResourceResolver();
        SitecatalystAccountResourceProvider scarp = new SitecatalystAccountResourceProvider(this.valueMap.get((Object)PN_COMPANY).toString(), this.valueMap.get((Object)PN_USERNAME).toString());
        Resource accRes = scarp.findAccountResource(resolver);
        if (accRes != null) {
            return new SitecatalystAccount(accRes);
        }
        return null;
    }

    @Override
    public Boolean hasService(String servicename) {
        block4: {
            try {
                Property services = this.node.getProperty("./cq:services");
                if (services.isMultiple()) {
                    for (Value v : services.getValues()) {
                        if (!servicename.equals(v.getString())) continue;
                        return Boolean.TRUE;
                    }
                    break block4;
                }
                return servicename.equals(services.getString());
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return Boolean.FALSE;
    }

    protected static Resource findAnalyticsResource(Resource resource) {
        ResourceResolver resolver = resource.getResourceResolver();
        try {
            String resourcePath = resource.getPath();
            while (resourcePath.lastIndexOf("/") > 0) {
                Resource res;
                Page page;
                resource = resolver.getResource(resourcePath);
                if (resource != null && (page = (Page)resource.adaptTo(Page.class)) != null && (res = page.getContentResource("analytics")) != null) {
                    Node jcrContent = (Node)page.getContentResource().adaptTo(Node.class);
                    Node node = (Node)res.adaptTo(Node.class);
                    if (node.hasProperty("cq:services") || jcrContent.hasProperty("cq:cloudserviceconfigs")) {
                        return res;
                    }
                }
                resourcePath = resourcePath.substring(0, resourcePath.lastIndexOf("/"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

