/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst;

import com.day.cq.analytics.AccountManager;
import com.day.cq.analytics.AnalyticsConfiguration;
import com.day.cq.analytics.sitecatalyst.ImpressionsEntry;
import com.day.cq.analytics.sitecatalyst.SitecatalystAccount;
import com.day.cq.analytics.sitecatalyst.SitecatalystException;
import com.day.cq.analytics.sitecatalyst.SitecatalystUtil;
import com.day.cq.analytics.sitecatalyst.SitecatalystWebservice;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.polling.importer.ImportException;
import com.day.cq.polling.importer.Importer;
import com.day.cq.statistics.StatisticsService;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import com.day.crx.statistics.Entry;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImpressionsImporter
implements Importer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final String REPORT_INTERVAL = "cq.analytics.sitecatalyst.importer.inverval";
    private SlingSettingsService settingsService;
    private SitecatalystWebservice webservice;
    private StatisticsService statService;
    private ConfigurationManager cfgManager;
    private Long reportInterval = 43200000L;

    public void importData(String scheme, String dataSource, Resource target) throws ImportException {
        block30: {
            try {
                ResourceResolver resolver = target.getResourceResolver();
                Resource pageResource = target.getParent().getParent();
                HierarchyNodeInheritanceValueMap pageProperties = new HierarchyNodeInheritanceValueMap(pageResource);
                Node analytics = (Node)target.getParent().adaptTo(Node.class);
                String lastAttempt = "0";
                if (analytics.hasProperty("cq:lastAttempt")) {
                    lastAttempt = analytics.getProperty("cq:lastAttempt").getString();
                }
                SitecatalystAccount account = null;
                String reportSuiteID = null;
                Configuration configuration = null;
                String[] services = (String[])pageProperties.getInherited("cq:cloudserviceconfigs", (Object)new String[0]);
                if (this.cfgManager != null && services.length > 0) {
                    configuration = this.cfgManager.getConfiguration("sitecatalyst", services);
                }
                if (configuration != null) {
                    AccountManager accountMgr = (AccountManager)resolver.adaptTo(AccountManager.class);
                    account = new SitecatalystAccount((String)configuration.getInherited("company", (Object)""), (String)configuration.getInherited("username", (Object)""), (String)configuration.getInherited("secret", (Object)""), (String)configuration.getInherited("server", (Object)""));
                    reportSuiteID = SitecatalystUtil.getReportSuites(this.settingsService, configuration);
                } else {
                    AnalyticsConfiguration analyticsConfig = (AnalyticsConfiguration)target.adaptTo(AnalyticsConfiguration.class);
                    if (analyticsConfig != null) {
                        account = analyticsConfig.getSitecatalystAccount();
                        reportSuiteID = this.getReportSuites(this.settingsService, analytics);
                    }
                }
                if (account == null) {
                    this.log.error("SiteCatalyst configuration not found");
                    return;
                }
                if (!account.isValid().booleanValue()) {
                    this.log.error("SiteCatalyst account['" + account.getCompany() + "/" + account.getUsername() + "'] is corrupt, please check or reconfigure");
                    return;
                }
                if (lastAttempt.startsWith("waiting")) {
                    String reportID = lastAttempt.replace("waiting-", "");
                    try {
                        String response = this.webservice.getReportStatus(account, reportID);
                        JSONObject jsonObj = new JSONObject(response);
                        if (jsonObj.getString("status").equals("done")) {
                            response = this.webservice.getReport(account, reportID);
                            jsonObj = new JSONObject(response);
                            JSONArray data = jsonObj.getJSONObject("report").getJSONArray("data");
                            String lastAttemptDate = analytics.getProperty("cq:lastAttemptDate").getString();
                            String statsBasePath = "/var/statistics/pages" + analytics.getPath().replace("/jcr:content/analytics", "");
                            this.log.info("Report contains data items: " + data.length());
                            for (int i = 0; i < data.length(); ++i) {
                                JSONObject pageData = data.getJSONObject(i);
                                this.setStatsData(statsBasePath, lastAttemptDate, pageData.getString("name"), pageData.getJSONArray("counts").getString(0), target.getResourceResolver(), this.statService);
                            }
                            this.log.info("Report " + reportID + " imported");
                            analytics.setProperty("cq:lastAttempt", Long.toString(System.currentTimeMillis()));
                            analytics.getSession().save();
                        } else if (jsonObj.getString("status").equals("failed")) {
                            String errorMsg = "";
                            if (jsonObj.has("error_msg")) {
                                errorMsg = jsonObj.getString("error_msg");
                            } else if (jsonObj.has("statusMsg")) {
                                errorMsg = jsonObj.getString("statusMsg");
                            }
                            this.log.info("Report " + reportID + " failed due to (" + jsonObj.getInt("error_code") + ") " + errorMsg);
                            analytics.setProperty("cq:lastAttempt", Long.toString(System.currentTimeMillis() - this.reportInterval));
                            analytics.getSession().save();
                        }
                    }
                    catch (SitecatalystException e) {
                        this.log.error("Call to Sitecatalyst failed", (Throwable)e);
                        analytics.setProperty("cq:lastAttempt", Long.toString(System.currentTimeMillis() - this.reportInterval));
                        analytics.getSession().save();
                    }
                    catch (JSONException e) {
                        this.log.error("Parsing JSON response failed", (Throwable)e);
                        analytics.setProperty("cq:lastAttempt", Long.toString(System.currentTimeMillis() - this.reportInterval));
                        analytics.getSession().save();
                    }
                    return;
                }
                long last = Long.parseLong(lastAttempt);
                if (last + this.reportInterval >= System.currentTimeMillis()) break block30;
                if (reportSuiteID == null) {
                    this.log.warn("cannot import data since no valid report suite ID was found");
                    return;
                }
                try {
                    Calendar cal = Calendar.getInstance();
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    cal.add(5, -1);
                    String date = dateFormat.format(cal.getTime());
                    String response = this.webservice.queuePageViewReport(account, reportSuiteID, date);
                    JSONObject jsonObj = new JSONObject(response);
                    Long reportID = jsonObj.getLong("reportID");
                    if (jsonObj.getString("status").equals("queued")) {
                        analytics.setProperty("cq:lastAttempt", "waiting-" + reportID);
                        analytics.setProperty("cq:lastAttemptDate", date);
                        analytics.getSession().save();
                        this.log.info("Report queued: " + reportID + " for " + reportSuiteID + " and " + date);
                    } else {
                        String errorMsg = "";
                        if (jsonObj.has("error_msg")) {
                            errorMsg = jsonObj.getString("error_msg");
                        } else if (jsonObj.has("statusMsg")) {
                            errorMsg = jsonObj.getString("statusMsg");
                        }
                        this.log.warn(jsonObj.toString());
                        this.log.warn("queueing report failed with status '" + jsonObj.getString("status") + "' and error message '" + errorMsg + "'");
                    }
                }
                catch (SitecatalystException e) {
                    this.log.error("Call to SiteCatalyst failed", (Throwable)e);
                }
                catch (JSONException e) {
                    this.log.error("Parsing JSON response failed", (Throwable)e);
                }
                return;
            }
            catch (PathNotFoundException e) {
                this.log.error("Reading analytics data failed for " + target.getPath(), (Throwable)e);
            }
            catch (RepositoryException e) {
                this.log.error("Reading analytics data failed", (Throwable)e);
            }
        }
    }

    private String getReportSuites(SlingSettingsService settingsService, Node analytics) throws RepositoryException {
        String reportSuiteID = null;
        Property reportSuiteIDs = analytics.getProperty("./cq:s_account");
        Set runModes = settingsService.getRunModes();
        if (reportSuiteIDs.isMultiple()) {
            Value v;
            Value[] values;
            Value[] arr$ = values = reportSuiteIDs.getValues();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (reportSuiteID = this.getReportSuiteID((v = arr$[i$]).getString(), runModes)) == null; ++i$) {
            }
        } else {
            reportSuiteID = this.getReportSuiteID(reportSuiteIDs.getString(), runModes);
        }
        return reportSuiteID;
    }

    private String getReportSuiteID(String reportSuite, Set<String> runModes) {
        String runMode;
        String rsid;
        if (reportSuite.indexOf(";") != -1) {
            rsid = reportSuite.substring(0, reportSuite.indexOf(";"));
            runMode = reportSuite.substring(reportSuite.indexOf(";") + 1);
        } else {
            rsid = reportSuite;
            runMode = "";
        }
        if (runMode.equals("") || runModes.contains(runMode)) {
            return rsid;
        }
        return "";
    }

    private void setStatsData(String basePath, String date, String name, String count, ResourceResolver resolver, StatisticsService statService) {
        ValueMap statsConfig;
        long views;
        String statsPath = basePath;
        name = !name.equals("home") ? "/" + name.replace(":", "/") : "";
        statsPath = statsPath + name + "/.stats/";
        Resource dayStats = resolver.getResource(statsPath = statsPath + date.replace("-", "/"));
        if (dayStats != null && (views = ((Long)(statsConfig = (ValueMap)dayStats.adaptTo(ValueMap.class)).get("views", Long.class)).longValue()) == Long.parseLong(count)) {
            return;
        }
        ImpressionsEntry view = new ImpressionsEntry(basePath, name, date, Long.parseLong(count));
        try {
            statService.addEntry((Entry)view);
        }
        catch (RepositoryException e) {
            this.log.error("adding stats entry failed", (Throwable)e);
        }
    }

    protected void activate(ComponentContext componentContext) {
        Dictionary config = componentContext.getProperties();
        this.reportInterval = (Long)config.get(REPORT_INTERVAL);
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindWebservice(SitecatalystWebservice sitecatalystWebservice) {
        this.webservice = sitecatalystWebservice;
    }

    protected void unbindWebservice(SitecatalystWebservice sitecatalystWebservice) {
        if (this.webservice == sitecatalystWebservice) {
            this.webservice = null;
        }
    }

    protected void bindStatService(StatisticsService statisticsService) {
        this.statService = statisticsService;
    }

    protected void unbindStatService(StatisticsService statisticsService) {
        if (this.statService == statisticsService) {
            this.statService = null;
        }
    }

    protected void bindCfgManager(ConfigurationManager configurationManager) {
        this.cfgManager = configurationManager;
    }

    protected void unbindCfgManager(ConfigurationManager configurationManager) {
        if (this.cfgManager == configurationManager) {
            this.cfgManager = null;
        }
    }
}

