/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl;

import com.day.cq.analytics.sitecatalyst.FrameworkComponent;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkComponentImpl
extends HierarchyNodeInheritanceValueMap
implements FrameworkComponent {
    private CqValueMap cqMappings = null;
    protected String[] contextStores = new String[]{"eventdata", "pagedata", "profile", "surferinfo", "tagcloud", "resolvedsegments", "geolocation"};
    protected String[] trackedVars = new String[0];
    protected String[] trackedEvents = new String[0];
    protected String[] trackedVarsEvents;
    protected Resource resource;
    protected ValueMap cqComp;
    private Set<String> keySet = null;

    public FrameworkComponentImpl(Resource mappingComp) {
        super(mappingComp);
        String trackEvents;
        this.resource = mappingComp;
        this.cqComp = (ValueMap)mappingComp.getResourceResolver().getResource(this.get("cq:componentPath") + "/analytics").adaptTo(ValueMap.class);
        String trackVars = ((String)this.cqComp.get("cq:trackvars", (Object)"")).trim();
        if (!"".equals(trackVars)) {
            this.trackedVars = trackVars.split(",");
        }
        if (!"".equals(trackEvents = ((String)this.cqComp.get("cq:trackevents", (Object)"")).trim())) {
            this.trackedEvents = trackEvents.split(",");
        }
        this.trackedVarsEvents = (String[])ArrayUtils.addAll((Object[])this.qualifyCqVars(this.trackedVars, "eventdata"), (Object[])this.qualifyCqVars(this.trackedEvents, "eventdata.events"));
    }

    protected String[] qualifyCqVars(String[] vars, String defaultStore) {
        String[] qualified = (String[])ArrayUtils.clone((Object[])vars);
        for (int i = 0; i < qualified.length; ++i) {
            String[] valueParts = qualified[i].split("\\.");
            if (valueParts.length != 0 && ArrayUtils.contains((Object[])this.contextStores, (Object)qualified[i].split("\\.")[0])) continue;
            qualified[i] = defaultStore + "." + qualified[i].trim();
        }
        return qualified;
    }

    @Override
    public String getType() {
        return this.resource.getResourceType();
    }

    @Override
    public String getPath() {
        return this.resource.getPath();
    }

    @Override
    public String[] getTrackedVarsEvents() {
        return this.trackedVarsEvents;
    }

    @Override
    public MultiValueMap getCqMappings() {
        if (this.cqMappings == null) {
            this.cqMappings = new CqValueMap();
            for (String scVar : this.inheritedKeySet()) {
                String cqVar = (String)this.getInherited(scVar, "");
                if (cqVar.length() > 0) {
                    this.cqMappings.put(cqVar, scVar);
                    continue;
                }
                for (String var : this.getTrackedVarsEvents()) {
                    if (!this.cqMappings.containsValue(var, scVar)) continue;
                    this.cqMappings.remove(var, scVar);
                }
            }
        }
        return this.cqMappings;
    }

    @Override
    public JSONArray getScVars(String cqVar) {
        return new JSONArray((Collection)this.getCqMappings().get((Object)cqVar));
    }

    public <T> T getInherited(String scKey, Class<T> type) {
        Object value = super.getInherited(scKey, type);
        if (value == null) {
            value = this.cqComp.get((Object)scKey);
        }
        String[] valueParts = ((String)value).split("\\.");
        if (!(scKey.contains(":") || valueParts.length != 0 && ArrayUtils.contains((Object[])this.contextStores, (Object)valueParts[0]))) {
            if (ArrayUtils.contains((Object[])this.trackedVars, (Object)value)) {
                value = "eventdata." + value;
            } else if (ArrayUtils.contains((Object[])this.trackedEvents, (Object)value)) {
                value = "eventdata.events." + value;
            }
        }
        return (T)((String)value).trim();
    }

    public Object get(Object key) {
        String cqVar = (String)super.get(key);
        if (cqVar == null) {
            return null;
        }
        String[] valueParts = cqVar.split("\\.");
        if (!(((String)key).contains(":") || valueParts.length != 0 && ArrayUtils.contains((Object[])this.contextStores, (Object)cqVar.split("\\.")[0]))) {
            if (ArrayUtils.contains((Object[])this.trackedVars, (Object)cqVar)) {
                cqVar = "eventdata." + cqVar;
            } else if (ArrayUtils.contains((Object[])this.trackedEvents, (Object)cqVar)) {
                cqVar = "eventdata.events." + cqVar;
            }
        }
        return cqVar.trim();
    }

    public Set<String> keySet() {
        if (this.keySet == null) {
            this.keySet = new HashSet<String>(super.keySet());
            for (String key : super.keySet()) {
                if (!key.contains(":")) continue;
                this.keySet.remove(key);
            }
        }
        return this.keySet;
    }

    @Override
    public Set<String> inheritedKeySet() {
        String innerResource = FrameworkComponentImpl.getInnerPath((Resource)this.resource);
        HashSet<String> keySet = new HashSet<String>(this.keySet());
        keySet.addAll(this.cqComp.keySet());
        for (String key : this.cqComp.keySet()) {
            if (!key.contains(":")) continue;
            keySet.remove(key);
        }
        String fwPath = this.resource.getPath().split("jcr:content/" + innerResource)[0];
        Resource parentComp = null;
        for (Resource parentFw = this.resource.getResourceResolver().getResource(fwPath).getParent(); parentFw != null && (parentComp = this.resource.getResourceResolver().getResource(parentFw.getPath() + "/" + "jcr:content" + "/" + innerResource)) == null; parentFw = parentFw.getParent()) {
        }
        if (parentComp != null) {
            keySet.addAll(new FrameworkComponentImpl(parentComp).inheritedKeySet());
        }
        return keySet;
    }

    class CqValueMap
    extends MultiValueMap {
        public CqValueMap() {
            super(new HashMap(), new Factory(){

                public Object create() {
                    return new HashSet<String>(){

                        @Override
                        public String toString() {
                            return StringUtils.join((Collection)this, (String)",");
                        }
                    };
                }
            });
        }
    }
}

