/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl;

import com.day.cq.analytics.sitecatalyst.Framework;
import com.day.cq.analytics.sitecatalyst.FrameworkComponent;
import com.day.cq.analytics.sitecatalyst.impl.FrameworkImpl;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SitecatalystAdapterFactory
implements AdapterFactory {
    private static final Logger log = LoggerFactory.getLogger(SitecatalystAdapterFactory.class);
    private static final Class<Framework> FRAMEWORK_CLASS = Framework.class;
    private static final Class<FrameworkComponent> FRAMEWORKCOMPONENT_CLASS = FrameworkComponent.class;
    public static final String[] ADAPTER_CLASSES = new String[]{FRAMEWORKCOMPONENT_CLASS.getName(), FRAMEWORK_CLASS.getName()};
    public static final String[] ADAPTABLE_CLASSES = new String[]{ResourceResolver.class.getName(), Resource.class.getName()};

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        if (adaptable instanceof ResourceResolver) {
            return this.getAdapter((ResourceResolver)adaptable, type);
        }
        if (adaptable instanceof Resource) {
            return this.getAdapter((Resource)adaptable, type);
        }
        return null;
    }

    private <AdapterType> AdapterType getAdapter(Resource resource, Class<AdapterType> type) {
        if (type == FRAMEWORK_CLASS && resource != null) {
            return (AdapterType)new FrameworkImpl(resource);
        }
        if (type == FRAMEWORKCOMPONENT_CLASS && resource != null) {
            ValueMap mainProps = (ValueMap)resource.adaptTo(ValueMap.class);
            String componentPath = (String)mainProps.get("cq:componentPath", (Object)"");
            if ("".equals(componentPath)) {
                return null;
            }
            Resource component = resource.getResourceResolver().getResource(componentPath);
            if (component == null) {
                return null;
            }
            ValueMap componentProps = (ValueMap)component.adaptTo(ValueMap.class);
            String mappingComponent = (String)componentProps.get("cq:mappingComponent", (Object)"");
            mappingComponent = StringUtils.capitalize((String)mappingComponent);
            try {
                Class<?> c = Class.forName("com.day.cq.analytics.sitecatalyst.impl." + mappingComponent + "FrameworkComponentImpl");
                return (AdapterType)c.getConstructor(Resource.class).newInstance(resource);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        log.debug("Unable to adapt resource of {} to type {}", (Object)resource.getResourceType(), (Object)type.getName());
        return null;
    }
}

