/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl;

import com.day.cq.analytics.sitecatalyst.SitecatalystAccount;
import com.day.cq.analytics.sitecatalyst.SitecatalystException;
import com.day.cq.analytics.sitecatalyst.SitecatalystHttpClient;
import com.day.cq.analytics.sitecatalyst.util.AuthenticationHelper;
import com.day.cq.wcm.webservicesupport.Configuration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SitecatalystHttpClientImpl
implements SitecatalystHttpClient {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DATACENTER_URLS = "cq.analytics.sitecatalyst.service.datacenter.url";
    private static final String[] DATACENTER_DEFAULT = new String[]{"https://sitecatalyst.omniture.com/p/am/1.2/"};
    private static final Integer PRIME = 78593;
    private List<String> dataCenterURLs = new ArrayList<String>();

    public String execute(String method, String data, SitecatalystAccount userAccount) throws SitecatalystException {
        try {
            if (userAccount.getServer() == null || "".equals(userAccount.getServer())) {
                URI endpoint = this.getCompanyEndpoint(userAccount);
                if (endpoint == null) {
                    throw new SitecatalystException("Could not determine endpoint");
                }
                userAccount.setServer(endpoint.toString());
            }
            PostMethod request = new PostMethod(userAccount.getServer() + "?method=" + method);
            request.setRequestEntity((RequestEntity)new StringRequestEntity(data, "application/json", "UTF-8"));
            return this.execute((HttpMethod)request, userAccount, method);
        }
        catch (IOException e) {
            boolean reachable = false;
            try {
                InetAddress address = InetAddress.getByName("www.adobe.com");
                reachable = address.isReachable(1000);
            }
            catch (IOException e1) {
                // empty catch block
            }
            if (reachable) {
                throw new SitecatalystException(e.getMessage(), e);
            }
            throw new SitecatalystException("not online", e);
        }
    }

    public String execute(String method, String data, Configuration configuration) throws SitecatalystException {
        SitecatalystAccount account = new SitecatalystAccount((String)configuration.getInherited("company", (Object)""), (String)configuration.getInherited("username", (Object)""), (String)configuration.getInherited("secret", (Object)""), (String)configuration.getInherited("server", (Object)""));
        return this.execute(method, data, account);
    }

    public String execute(URI uri, String data, Configuration configuration) throws SitecatalystException {
        SitecatalystAccount account = new SitecatalystAccount((String)configuration.getInherited("company", (Object)""), (String)configuration.getInherited("username", (Object)""), (String)configuration.getInherited("secret", (Object)""), (String)configuration.getInherited("server", (Object)""));
        return this.execute(uri, data, account);
    }

    public String execute(URI uri, String data, SitecatalystAccount userAccount) throws SitecatalystException {
        try {
            PostMethod request = new PostMethod(uri.toString());
            request.setRequestEntity((RequestEntity)new StringRequestEntity(data, "application/xml", "UTF-8"));
            Pattern methodPattern = Pattern.compile("[\\?\\&]method=([^&]*)");
            Matcher matcher = methodPattern.matcher(uri.toString());
            String apiMethod = matcher.find() ? matcher.group(1) : null;
            return this.execute((HttpMethod)request, userAccount, apiMethod);
        }
        catch (IOException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    private String execute(HttpMethod method, SitecatalystAccount userAccount, String apiMethod) throws HttpException, IOException {
        return this.execute(method, userAccount.getUsername(), userAccount.getWSUsername(), userAccount.getCompany(), userAccount.getSecret(), apiMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String execute(HttpMethod method, String username, String wsUsername, String companyname, String secret, String apiMethod) throws HttpException, IOException {
        HttpClient http = new HttpClient();
        try {
            Date now = new Date();
            byte[] nonce = this.generateNonce();
            String created = this.generateTimestamp(now);
            String securityHeader = null;
            securityHeader = apiMethod != null && apiMethod.equals("Suite.GetHeader") ? this.getAppKeySecurityHeader(this.isDev(method), nonce, username, companyname, created) : this.getSecurityHeader(this.isDev(method), nonce, wsUsername, secret, created);
            method.addRequestHeader("X-WSSE", securityHeader);
            http.executeMethod(method);
            String string = this.consumeResponse(method);
            return string;
        }
        finally {
            method.releaseConnection();
        }
    }

    private String consumeResponse(HttpMethod method) throws IOException {
        String line;
        StringBuffer sb = new StringBuffer();
        BufferedReader responseReader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream()));
        while ((line = responseReader.readLine()) != null) {
            sb.append(line);
        }
        return sb.toString();
    }

    URI getCompanyEndpoint(SitecatalystAccount account) throws SitecatalystException {
        for (String datacenter : this.dataCenterURLs) {
            String uri = null;
            try {
                String response = this.getEndpoint(datacenter, account);
                if (response.indexOf("{") != -1) {
                    this.log.warn("Data center '" + datacenter + "' responded with errors " + response);
                    continue;
                }
                uri = response.replaceAll("(\\\\|\")", "");
                uri = uri.indexOf("beta") < 0 ? uri + "rest/" : uri + "rest-api.html";
                String queue = this.getQueue(datacenter, account);
                if (queue.indexOf("[") == -1) {
                    if (queue.indexOf("privileges") != -1) {
                        this.log.warn("authorization failed for " + datacenter);
                        throw new SitecatalystException("not authorized");
                    }
                    this.log.warn("authentication failed for " + datacenter);
                    continue;
                }
                return new URI(uri);
            }
            catch (Exception e) {
                this.log.warn("Request to SiteCatalyst {} failed", (Object)"Company.GetEndPoint", (Object)e);
            }
        }
        throw new SitecatalystException("not authenticated");
    }

    private String getEndpoint(String uri, SitecatalystAccount account) throws IOException, SitecatalystException {
        try {
            return this.execute(new URI(uri + "?method=Company.GetEndpoint"), "{\"company\":\"" + account.getCompany() + "\"}", account);
        }
        catch (URISyntaxException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    private String getQueue(String uri, SitecatalystAccount account) throws IOException, SitecatalystException {
        try {
            return this.execute(new URI(uri + "?method=Company.GetQueue"), "{\"company\":\"" + account.getCompany() + "\"}", account);
        }
        catch (URISyntaxException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    private String getSecurityHeader(boolean dev, byte[] nonce, String username, String secret, String created) throws UnsupportedEncodingException {
        String password64 = AuthenticationHelper.getBase64Digest(nonce, created.getBytes(), secret.getBytes());
        StringBuffer header = new StringBuffer();
        header.append("UsernameToken Username=\"");
        header.append(username);
        header.append("\", ");
        header.append("PasswordDigest=\"");
        header.append(password64.trim());
        header.append("\", ");
        header.append("Nonce=\"");
        header.append(AuthenticationHelper.base64Encode(nonce).trim());
        header.append("\", ");
        header.append("Created=\"");
        header.append(created);
        header.append("\", ");
        header.append("appkey=\"");
        header.append(this.getAppKey(dev, nonce));
        header.append("\", ");
        header.append("appdigest=\"");
        header.append(this.getAppPassword(dev, nonce));
        header.append("\", ");
        header.append("appnonce=\"");
        header.append(AuthenticationHelper.base64Encode(nonce).trim());
        return header.toString();
    }

    private String getAppKeySecurityHeader(boolean dev, byte[] nonce, String username, String companyname, String created) throws UnsupportedEncodingException {
        StringBuffer header = new StringBuffer();
        header.append("UsernameToken ");
        header.append("Created=\"");
        header.append(created);
        header.append("\", ");
        header.append("appkey=\"");
        header.append(this.getAppKey(dev, nonce));
        header.append("\", ");
        header.append("appdigest=\"");
        header.append(this.getAppPassword(dev, nonce));
        header.append("\", ");
        header.append("appnonce=\"");
        header.append(AuthenticationHelper.base64Encode(nonce).trim());
        header.append("\", ");
        header.append("proxyuser=\"");
        header.append(username);
        header.append("\", ");
        header.append("proxycompany=\"");
        header.append(companyname);
        header.append("\"");
        return header.toString();
    }

    private String getAppKey(boolean isDev, byte[] nonce) throws UnsupportedEncodingException {
        if (isDev) {
            return this.getValue("U3EWWQFqDyhLJUYMAH8NLwdzWA9XMV1hUHERXAZgWHoAdhda");
        }
        return this.getValue("B3ZCXApjXXpLcBdbAX9ZdVdzWAgCZwlhVX9GWlJgDn1XfxQP");
    }

    private String getAppPassword(boolean isDev, byte[] nonce) throws UnsupportedEncodingException {
        if (isDev) {
            String appPass = this.getValue("DCRDGldmARsBCw==");
            String digestKey = AuthenticationHelper.getBase64DigestKey(nonce, appPass.getBytes());
            return digestKey.trim();
        }
        String appPass = this.getValue("KyoxXBkdCioDLg==");
        String digestKey = AuthenticationHelper.getBase64DigestKey(nonce, appPass.getBytes());
        return digestKey.trim();
    }

    private boolean isDev(HttpMethod method) {
        try {
            return method.getURI().getHost().endsWith(".dev.omniture.com");
        }
        catch (Exception e) {
            this.log.warn("could not determine hostname from uri");
            return false;
        }
    }

    private String getValue(String hiddenText) throws UnsupportedEncodingException {
        String xorPass = new String(Base64.decodeBase64((String)hiddenText), "UTF-8");
        String value = this.xorString(xorPass, "fGun3RkL");
        return value;
    }

    private byte[] generateNonce() {
        String nonce = String.valueOf(Math.random() * (double)PRIME.intValue());
        return nonce.getBytes();
    }

    private String generateTimestamp(Date date) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        return dateFormatter.format(date);
    }

    private void setDataCenters(String[] datacenter) {
        for (String dc : datacenter) {
            this.dataCenterURLs.add(dc);
        }
    }

    private String xorString(String s, String key) {
        try {
            if (s == null || key == null) {
                return null;
            }
            char[] keys = key.toCharArray();
            char[] mesg = s.toCharArray();
            char[] newmsg = new char[mesg.length];
            for (int i = 0; i < mesg.length; ++i) {
                newmsg[i] = (char)(mesg[i] ^ keys[i % keys.length]);
            }
            mesg = null;
            keys = null;
            return new String(newmsg);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void activate(ComponentContext componentContext) throws RepositoryException {
        this.log.debug("Starting SitecatalystRESTClient...");
        Dictionary properties = componentContext.getProperties();
        String[] dc = OsgiUtil.toStringArray(properties.get(DATACENTER_URLS));
        if (dc == null || dc.length == 0) {
            this.setDataCenters(DATACENTER_DEFAULT);
        } else {
            this.setDataCenters(dc);
        }
        this.log.debug("...SitecatalystRESTClient started");
    }

    protected void deactivate(ComponentContext componentContext) {
        this.log.debug("Stopping SitecatalystRESTClient...");
        this.log.debug("...SitecatalystRESTClient stopped");
    }
}

