/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl;

import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.util.HashSet;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SitecatalystPostProcessor
implements SlingPostProcessor {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final String NT_PAGE = "cq:Page";
    private final String NT_POLLCONFIGFOLDER = "cq:PollConfigFolder";
    private final String RT_SITECATALYST = "cq/analytics/components/sitecatalyst";
    private final String VAL_SOURCE = "sitecatalyst:default";
    private final Long VAL_INTERVAL = 300L;
    private final String PAGE_MARKER = "/jcr:content/";
    private ConfigurationManager configManager;

    public void process(SlingHttpServletRequest request, List<Modification> changes) throws Exception {
        HashSet<String> fixPaths = new HashSet<String>();
        for (Modification mod : changes) {
            switch (mod.getType()) {
                case ORDER: 
                case MOVE: 
                case COPY: {
                    break;
                }
                case MODIFY: {
                    int pageEndPos = mod.getSource().indexOf("/jcr:content/");
                    if (pageEndPos == -1) break;
                    String pagePath = mod.getSource().substring(0, pageEndPos);
                    fixPaths.add(pagePath);
                    break;
                }
            }
        }
        ResourceResolver resolver = request.getResourceResolver();
        for (String pagePath : fixPaths) {
            String contentPath = pagePath + '/' + "jcr:content";
            this.logger.debug("Checking page {} for analytics configuration", (Object)pagePath);
            Resource contentResource = resolver.getResource(contentPath);
            if (contentResource == null) continue;
            this.fixStructure(contentResource);
        }
    }

    private void fixStructure(Resource resource) {
        if (ResourceUtil.isA((Resource)resource.getParent(), (String)"cq:Page")) {
            ValueMap props = (ValueMap)resource.adaptTo(ValueMap.class);
            String[] configurations = (String[])props.get("cq:cloudserviceconfigs", (Object)new String[0]);
            Configuration config = this.configManager.getConfiguration("sitecatalyst", configurations);
            if (config != null) {
                this.addAnalytics(resource);
                this.logger.debug("Adding analytics configuration to page {}", (Object)resource.getPath());
            } else {
                this.removeAnalytics(resource);
                this.logger.debug("Removing analytics configuration from page {}", (Object)resource.getPath());
            }
        }
    }

    private void addAnalytics(Resource resource) {
        Resource analyticsRes = resource.getChild("analytics");
        if (analyticsRes == null) {
            try {
                Node contentNode = (Node)resource.adaptTo(Node.class);
                Node analyticsNode = contentNode.addNode("analytics", "nt:unstructured");
                analyticsNode.setProperty("sling:resourceType", "cq/analytics/components/sitecatalyst");
                this.addPolling(analyticsNode);
            }
            catch (RepositoryException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void addPolling(Node analyticsNode) {
        if (analyticsNode != null) {
            try {
                Node pollNode = analyticsNode.addNode("pollconfig", "cq:PollConfigFolder");
                pollNode.setProperty("source", "sitecatalyst:default");
                pollNode.setProperty("interval", this.VAL_INTERVAL.longValue());
            }
            catch (RepositoryException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void removeAnalytics(Resource resource) {
        Resource analyticsRes = resource.getChild("analytics");
        if (analyticsRes != null) {
            try {
                Node analyticsNode = (Node)analyticsRes.adaptTo(Node.class);
                analyticsNode.remove();
            }
            catch (RepositoryException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void bindConfigManager(ConfigurationManager configurationManager) {
        this.configManager = configurationManager;
    }

    protected void unbindConfigManager(ConfigurationManager configurationManager) {
        if (this.configManager == configurationManager) {
            this.configManager = null;
        }
    }
}

