/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl;

import com.day.cq.analytics.sitecatalyst.SitecatalystAccount;
import com.day.cq.analytics.sitecatalyst.SitecatalystException;
import com.day.cq.analytics.sitecatalyst.SitecatalystHttpClient;
import com.day.cq.analytics.sitecatalyst.SitecatalystWebservice;
import com.day.cq.analytics.sitecatalyst.rsmerger.impl.EVarMerger;
import com.day.cq.analytics.sitecatalyst.rsmerger.impl.EventMerger;
import com.day.cq.analytics.sitecatalyst.rsmerger.impl.TrafficVarMerger;
import com.day.cq.wcm.webservicesupport.Configuration;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class SitecatalystWebserviceImpl
implements SitecatalystWebservice {
    private SitecatalystHttpClient client;

    public void checkCredentials(String company, String username, String secret) throws SitecatalystException {
        this.getReportSuites(new SitecatalystAccount(company, username, secret, null));
    }

    public String getReportSuites(SitecatalystAccount account) throws SitecatalystException {
        return this.client.execute("Company.GetReportSuites", "{\"rs_type\": [\"standard\"], \"sp\":\"\"}", account);
    }

    public String getReportSuites(Configuration configuration) throws SitecatalystException {
        return this.getReportSuites(this.toSitecatalystAccount(configuration));
    }

    public String getTrackingServer(SitecatalystAccount account, String rsid) throws SitecatalystException {
        return this.client.execute("Company.GetTrackingServer", "{\"rsid\": \"" + rsid + "\"}", account);
    }

    public String getTrackingServer(Configuration configuration, String rsid) throws SitecatalystException {
        return this.getTrackingServer(this.toSitecatalystAccount(configuration), rsid);
    }

    public String getEvars(SitecatalystAccount account, String rsid) throws SitecatalystException {
        JSONArray rsidList = this.toJSONArray(rsid);
        String result = this.client.execute("ReportSuite.GetEVars", "{\"rsid_list\": " + rsidList + "}", account);
        try {
            JSONArray array = new JSONArray(result);
            this.checkResults(rsidList, array);
            return new EVarMerger(array).getReportSuite().toString();
        }
        catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    public String getEvars(Configuration configuration, String rsid) throws SitecatalystException {
        return this.getEvars(this.toSitecatalystAccount(configuration), rsid);
    }

    public String getTrafficVars(SitecatalystAccount account, String rsid) throws SitecatalystException {
        JSONArray rsidList = this.toJSONArray(rsid);
        String result = this.client.execute("ReportSuite.GetTrafficVars", "{\"rsid_list\": " + rsidList + "}", account);
        try {
            JSONArray array = new JSONArray(result);
            this.checkResults(rsidList, array);
            return new TrafficVarMerger(array).getReportSuite().toString();
        }
        catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    public String getTrafficVars(Configuration configuration, String rsid) throws SitecatalystException {
        return this.getTrafficVars(this.toSitecatalystAccount(configuration), rsid);
    }

    public String getSuccessEvents(SitecatalystAccount account, String rsid) throws SitecatalystException {
        JSONArray rsidList = this.toJSONArray(rsid);
        try {
            String result = this.client.execute("ReportSuite.GetSuccessEvents", "{\"rsid_list\": " + rsidList + "}", account);
            JSONArray array = new JSONArray(result);
            this.checkResults(rsidList, array);
            return new EventMerger(array).getReportSuite().toString();
        }
        catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    public String getSuccessEvents(Configuration configuration, String rsid) throws SitecatalystException {
        return this.getSuccessEvents(this.toSitecatalystAccount(configuration), rsid);
    }

    public String queuePageViewReport(SitecatalystAccount account, String rsid, String date) throws SitecatalystException {
        try {
            JSONObject reportDescription = new JSONObject();
            reportDescription.put("reportSuiteID", (Object)rsid);
            reportDescription.put("date", (Object)date);
            reportDescription.put("metrics", (Object)new JSONArray("[{\"id\": \"pageViews\"}]"));
            reportDescription.put("elements", (Object)new JSONArray("[{\"id\": \"page\"}]"));
            JSONObject reportQueue = new JSONObject();
            reportQueue.put("reportDescription", (Object)reportDescription);
            return this.client.execute("Report.QueueRanked", reportQueue.toString(), account);
        }
        catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    public String queuePageViewReport(Configuration configuration, String rsid, String date) throws SitecatalystException {
        return this.queuePageViewReport(this.toSitecatalystAccount(configuration), rsid, date);
    }

    public String getReportStatus(SitecatalystAccount account, String reportID) throws SitecatalystException {
        return this.client.execute("Report.GetStatus", "{\"reportID\": " + reportID + "}", account);
    }

    public String getReportStatus(Configuration configuration, String reportID) throws SitecatalystException {
        return this.getReportStatus(this.toSitecatalystAccount(configuration), reportID);
    }

    public String getReport(SitecatalystAccount account, String reportID) throws SitecatalystException {
        return this.client.execute("Report.GetReport", "{\"reportID\": " + reportID + "}", account);
    }

    public String getReport(Configuration configuration, String reportID) throws SitecatalystException {
        return this.getReport(this.toSitecatalystAccount(configuration), reportID);
    }

    public String getPages(SitecatalystAccount account, Integer limit, String pagename, String rsid, Integer start) throws SitecatalystException {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            JSONObject json = new JSONObject();
            json.put("limit", (Object)limit);
            json.put("page_search", (Object)pagename);
            json.put("rsid_list", (Object)this.toJSONArray(rsid));
            json.put("sc_period", (Object)sdf.format(new Date()));
            json.put("start_point", (Object)start);
            return this.client.execute("ReportSuite.GetPages", json.toString(), account);
        }
        catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    public String getPages(Configuration configuration, Integer limit, String pagename, String rsid, Integer start) throws SitecatalystException {
        return this.getPages(this.toSitecatalystAccount(configuration), limit, pagename, rsid, start);
    }

    private final JSONArray toJSONArray(String s) {
        JSONArray array = new JSONArray();
        for (String piece : s.split(",")) {
            array.put((Object)piece);
        }
        return array;
    }

    private final void checkResults(JSONArray requestArray, JSONArray resultArray) throws JSONException, SitecatalystException {
        int i;
        HashSet<String> rsidSet = new HashSet<String>();
        for (i = 0; i < resultArray.length(); ++i) {
            rsidSet.add(resultArray.getJSONObject(i).getString("rsid"));
        }
        for (i = 0; i < requestArray.length(); ++i) {
            String rsid = requestArray.getString(i);
            if (rsidSet.contains(rsid)) continue;
            throw new SitecatalystException("Report suite with ID " + rsid + "  was not in result");
        }
    }

    private SitecatalystAccount toSitecatalystAccount(Configuration configuration) {
        SitecatalystAccount account = new SitecatalystAccount((String)configuration.getInherited("company", (Object)""), (String)configuration.getInherited("username", (Object)""), (String)configuration.getInherited("secret", (Object)""), (String)configuration.getInherited("server", (Object)""));
        return account;
    }

    protected void bindClient(SitecatalystHttpClient sitecatalystHttpClient) {
        this.client = sitecatalystHttpClient;
    }

    protected void unbindClient(SitecatalystHttpClient sitecatalystHttpClient) {
        if (this.client == sitecatalystHttpClient) {
            this.client = null;
        }
    }
}

