/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl.servlets;

import com.day.cq.analytics.sitecatalyst.SitecatalystException;
import com.day.cq.analytics.sitecatalyst.impl.servlets.AbstractOptionsServlet;
import com.day.cq.wcm.webservicesupport.Configuration;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportSuitesServlet
extends AbstractOptionsServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();
        try {
            Configuration config = this.getConfiguration(request, "sitecatalyst");
            String jsonResponse = this.catalystService.getReportSuites(config);
            out.write(jsonResponse);
        }
        catch (SitecatalystException e) {
            this.log.error("Call to SiteCatalyst method 'Company.GetReportSuites' failed", (Throwable)e);
            out.write("[]");
        }
        catch (Exception e) {
            this.log.error("Exception occured while calling Sitecatalyst service", (Throwable)e);
            throw new ServletException("Exception occured while calling Sitecatalyst service", (Throwable)e);
        }
        finally {
            out.flush();
        }
    }
}

