/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl.servlets;

import com.day.cq.analytics.sitecatalyst.FrameworkComponent;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SitecatalystComponentMappingsServlet
extends SlingAllMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        ValueMap props = (ValueMap)request.getResource().adaptTo(ValueMap.class);
        Long expiryTime = (Long)props.get("expiryTime", (Object)120L) * 60L * 1000L;
        if (expiryTime > 0L) {
            response.setDateHeader("Expires", System.currentTimeMillis() + expiryTime);
        }
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        JSONWriter writer = new JSONWriter((Writer)response.getWriter());
        try {
            writer.array();
            FrameworkComponent fwComp = (FrameworkComponent)request.getResource().getResourceResolver().getResource(request.getParameter("path")).adaptTo(FrameworkComponent.class);
            for (String cqVar : fwComp.getTrackedVarsEvents()) {
                writer.object();
                writer.key("scVar").value((Object)fwComp.getScVars(cqVar));
                writer.key("cqVar").value((Object)cqVar);
                writer.endObject();
            }
            writer.endArray();
        }
        catch (JSONException e) {
            ServletException se = new ServletException("Error creating component mappings json response", (Throwable)e);
            se.initCause((Throwable)e);
            this.log.debug(se.toString());
            throw se;
        }
    }
}

