/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl.servlets;

import com.day.cq.analytics.sitecatalyst.SitecatalystAccount;
import com.day.cq.analytics.sitecatalyst.SitecatalystException;
import com.day.cq.analytics.sitecatalyst.SitecatalystWebservice;
import com.day.cq.analytics.sitecatalyst.util.AuthenticationHelper;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import com.day.cq.wcm.webservicesupport.ConfigurationUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SitecatalystServlet
extends SlingAllMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String PARAMETER_METHOD = "method";
    private static final String PARAMETER_CONFIG_PATH = "configPath";
    private static final String PARAMETER_COMPANY = "company";
    private static final String PARAMETER_USERNAME = "username";
    private static final String PARAMETER_PASSWORD = "password";
    private static final String PARAMETER_RSID = "rsid";
    private ConfigurationManager configManager;
    protected SitecatalystWebservice catalystService;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();
        String method = request.getParameter(PARAMETER_METHOD);
        try {
            if ("Connect".equals(method)) {
                this.handleConnect(request, out);
            } else {
                this.handleAPICall(request, out, method);
            }
        }
        catch (SitecatalystException e) {
            this.log.error("Call to SiteCatalyst method '" + request.getParameter(PARAMETER_METHOD) + "' failed", (Throwable)e);
            out.write("{error: '" + e.getMessage() + "'}");
        }
        catch (Exception e) {
            this.log.error("Exception occured while calling Sitecatalyst service", (Throwable)e);
            throw new ServletException("Exception occured while calling Sitecatalyst service", (Throwable)e);
        }
        finally {
            out.flush();
        }
    }

    private void handleConnect(SlingHttpServletRequest request, Writer out) throws Exception {
        String jsonResponse = "{}";
        String company = request.getParameter(PARAMETER_COMPANY);
        String username = request.getParameter(PARAMETER_USERNAME);
        String password = request.getParameter(PARAMETER_PASSWORD);
        try {
            String secret = AuthenticationHelper.generateSharedSecret(password);
            this.catalystService.checkCredentials(company, username, secret);
            JSONObject json = new JSONObject();
            if (password != null) {
                json.put("secret", (Object)secret);
            }
            jsonResponse = json.toString();
        }
        catch (JSONException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        out.write(jsonResponse);
    }

    private void handleAPICall(SlingHttpServletRequest request, Writer out, String method) throws Exception {
        String jsonResponse = "{}";
        Boolean hasServer = false;
        String rsid = request.getParameter(PARAMETER_RSID);
        String configPath = request.getParameter(PARAMETER_CONFIG_PATH);
        Configuration configuration = this.configManager.getConfiguration(configPath);
        if (configuration == null) {
            throw new SitecatalystException("Configuration has not been found");
        }
        if (rsid == null) {
            rsid = (String)configuration.getInherited("reportsuite", (Object)"");
        }
        hasServer = configuration.getInherited("server", null) != null;
        SitecatalystAccount account = new SitecatalystAccount((String)configuration.getInherited(PARAMETER_COMPANY, (Object)""), (String)configuration.getInherited(PARAMETER_USERNAME, (Object)""), (String)configuration.getInherited("secret", (Object)""), (String)configuration.getInherited("server", (Object)""));
        if (method.equals("Company.GetReportSuites")) {
            jsonResponse = this.catalystService.getReportSuites(account);
        } else if (method.equals("Company.GetTrackingServer")) {
            String[] rsidArray = rsid.split(",");
            if (rsidArray.length > 0) {
                jsonResponse = this.catalystService.getTrackingServer(account, rsidArray[0]);
            }
        } else if (method.equals("ReportSuite.GetEVars")) {
            jsonResponse = this.catalystService.getEvars(account, rsid);
        } else if (method.equals("ReportSuite.GetTrafficVars")) {
            jsonResponse = this.catalystService.getTrafficVars(account, rsid);
        } else if (method.equals("ReportSuite.GetSuccessEvents")) {
            jsonResponse = this.catalystService.getSuccessEvents(account, rsid);
        }
        if (!hasServer.booleanValue()) {
            this.saveConfiguration(account, configuration);
        }
        out.write(jsonResponse);
    }

    private void saveConfiguration(SitecatalystAccount account, Configuration config) {
        try {
            Resource topConfig = config.getResource();
            while (ConfigurationUtil.isConfiguration((Resource)topConfig.getParent()).booleanValue()) {
                topConfig = topConfig.getParent();
            }
            Resource topConfigContent = topConfig.getChild("jcr:content");
            if (topConfigContent != null) {
                Node topConfigNode = (Node)topConfigContent.adaptTo(Node.class);
                topConfigNode.setProperty("server", account.getServer());
                topConfigNode.getSession().save();
            }
        }
        catch (RepositoryException e) {
            this.log.error("Could not save updated configuration", (Throwable)e);
        }
    }

    protected void bindConfigManager(ConfigurationManager configurationManager) {
        this.configManager = configurationManager;
    }

    protected void unbindConfigManager(ConfigurationManager configurationManager) {
        if (this.configManager == configurationManager) {
            this.configManager = null;
        }
    }

    protected void bindCatalystService(SitecatalystWebservice sitecatalystWebservice) {
        this.catalystService = sitecatalystWebservice;
    }

    protected void unbindCatalystService(SitecatalystWebservice sitecatalystWebservice) {
        if (this.catalystService == sitecatalystWebservice) {
            this.catalystService = null;
        }
    }
}

