/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.impl;

import com.day.cq.analytics.testandtarget.TestandtargetException;
import com.day.cq.analytics.testandtarget.TestandtargetHttpClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Dictionary;
import javax.jcr.RepositoryException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestandtargetHttpClientImpl
implements TestandtargetHttpClient {
    private static final Logger log = LoggerFactory.getLogger(TestandtargetHttpClientImpl.class);
    private static final String API_URL = "cq.analytics.testandtarget.api.url";
    private static String DEFAULT_API_URL = "https://admin.testandtarget.omniture.com/api";
    private String apiUrl;

    public String execute(String[] queryKeys, String[] queryValues) throws TestandtargetException {
        GetMethod request = null;
        try {
            HttpClient http = new HttpClient();
            HttpsURL url = new HttpsURL(this.apiUrl);
            url.setQuery(queryKeys, queryValues);
            request = new GetMethod(url.toString());
            http.executeMethod((HttpMethod)request);
            String string = this.consumeResponse((HttpMethod)request);
            return string;
        }
        catch (Exception e) {
            throw new TestandtargetException(e.getMessage(), e);
        }
        finally {
            request.releaseConnection();
        }
    }

    private String consumeResponse(HttpMethod method) throws IOException {
        String line;
        StringBuffer sb = new StringBuffer();
        BufferedReader responseReader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream()));
        while ((line = responseReader.readLine()) != null) {
            sb.append(line);
        }
        return sb.toString();
    }

    protected void activate(ComponentContext componentContext) throws RepositoryException {
        log.debug("Starting " + TestandtargetHttpClientImpl.class.getSimpleName());
        Dictionary properties = componentContext.getProperties();
        this.apiUrl = OsgiUtil.toString(properties.get(API_URL), (String)DEFAULT_API_URL);
        log.debug(TestandtargetHttpClientImpl.class.getSimpleName() + " started");
    }

    protected void deactivate(ComponentContext componentContext) {
        log.debug("Stopping " + TestandtargetHttpClientImpl.class.getSimpleName());
        log.debug(TestandtargetHttpClientImpl.class.getSimpleName() + " stopped");
    }
}

