/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.impl;

import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import com.day.cq.analytics.testandtarget.TestandtargetException;
import com.day.cq.analytics.testandtarget.TestandtargetHttpClient;
import com.day.cq.analytics.testandtarget.TestandtargetService;
import com.day.cq.wcm.webservicesupport.Configuration;
import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestandtargetServiceImpl
implements TestandtargetService {
    private static final String SUCCESS_NODE = "success";
    private static final String ERROR_NODE = "error";
    private static final String OPERATION_NODE = "operation";
    private static final String CAMPAIGNS_NODE = "campaigns";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
    private CryptoSupport cryptoSupport;
    private TestandtargetHttpClient client;

    @Override
    public String publishOffer(Configuration configuration, String name, String url, String id) throws TestandtargetException {
        try {
            Document doc;
            String[] queryKeys = new String[]{"client", "email", "password", OPERATION_NODE, "name", "url", "id"};
            String[] queryValues = new String[]{(String)configuration.getInherited("clientcode", (Object)""), (String)configuration.getInherited("email", (Object)""), this.getPassword(configuration), "saveWidgetOffer", name, url, id};
            String response = this.execute(queryKeys, queryValues);
            if (response != null && (doc = this.getXMLfromResponse(response)) != null && SUCCESS_NODE.equals(doc.getDocumentElement().getNodeName()) && doc.getElementsByTagName("third-party-id").getLength() > 0) {
                return doc.getElementsByTagName("third-party-id").item(0).getFirstChild().getNodeValue();
            }
        }
        catch (TestandtargetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TestandtargetException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public String unpublishOffer(Configuration configuration, String name, String url, String id) throws TestandtargetException {
        try {
            Document doc;
            String[] queryKeys = new String[]{"client", "email", "password", OPERATION_NODE, "name", "url", "id"};
            String[] queryValues = new String[]{(String)configuration.getInherited("clientcode", (Object)""), (String)configuration.getInherited("email", (Object)""), this.getPassword(configuration), "deleteWidgetOffer", name, url, id};
            String response = this.execute(queryKeys, queryValues);
            if (response != null && (doc = this.getXMLfromResponse(response)) != null && SUCCESS_NODE.equals(doc.getDocumentElement().getNodeName()) && doc.getElementsByTagName("third-party-id").getLength() > 0) {
                return doc.getElementsByTagName("third-party-id").item(0).getFirstChild().getNodeValue();
            }
        }
        catch (TestandtargetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TestandtargetException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public Map<Integer, String> listCampaigns(Configuration configuration, Date before, Date after, String environment, String name, String state, String label) throws TestandtargetException {
        try {
            return this.listCampaigns((String)configuration.getInherited("email", (Object)""), this.getPassword(configuration), (String)configuration.getInherited("clientcode", (Object)""), before, after, environment, name, state, label);
        }
        catch (CryptoException e) {
            throw new TestandtargetException(e.getMessage(), e);
        }
    }

    private Map<Integer, String> listCampaigns(String email, String password, String clientcode, Date before, Date after, String environment, String name, String state, String label) throws TestandtargetException {
        try {
            String[] queryKeys = new String[]{"client", "email", "password", OPERATION_NODE, "before", "after", "environment", "name", "state", "label"};
            String[] queryValues = new String[]{clientcode, email, password, "campaignList", before != null ? sdf.format(before) : sdf.format(new Date()), after != null ? sdf.format(after) : "", environment != null ? environment : "", name != null ? name : "", state != null ? state : "", label != null ? label : ""};
            String response = this.execute(queryKeys, queryValues);
            if (response != null) {
                Document doc = this.getXMLfromResponse(response);
                if (doc != null && CAMPAIGNS_NODE.equals(doc.getDocumentElement().getNodeName()) && doc.getElementsByTagName("campaign").getLength() > 0) {
                    HashMap<Integer, String> campaigns = new HashMap<Integer, String>();
                    NodeList nodes = doc.getElementsByTagName("campaign");
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        String id = nodes.item(i).getFirstChild().getFirstChild().getNodeValue();
                        String campaignname = nodes.item(i).getFirstChild().getNextSibling().getFirstChild().getNodeValue();
                        campaigns.put(Integer.parseInt(id), campaignname);
                    }
                    return campaigns;
                }
                String error = this.getErrorMessage(doc);
                if (error != null) {
                    throw new TestandtargetException(error);
                }
            }
        }
        catch (TestandtargetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TestandtargetException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public void checkCredentials(String email, String password, String clientcode) throws TestandtargetException {
        this.listCampaigns(email, password, clientcode, null, null, null, "somedummyname", null, null);
    }

    private String execute(String[] queryKeys, String[] queryValues) throws Exception {
        String response = this.client.execute(queryKeys, queryValues);
        Document doc = this.getXMLfromResponse(response);
        String error = this.getErrorMessage(doc);
        if (error != null) {
            throw new TestandtargetException(error);
        }
        return response;
    }

    private Document getXMLfromResponse(String response) throws IOException, ParserConfigurationException {
        try {
            InputSource is = new InputSource(new StringReader(response));
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            return doc;
        }
        catch (SAXException e) {
            return null;
        }
    }

    private String getErrorMessage(Document document) {
        if (ERROR_NODE.equalsIgnoreCase(document.getDocumentElement().getNodeName())) {
            if (document.getElementsByTagName("message").getLength() > 0) {
                return document.getElementsByTagName("message").item(0).getFirstChild().getNodeValue();
            }
        } else if (OPERATION_NODE.equalsIgnoreCase(document.getDocumentElement().getNodeName()) && document.getElementsByTagName("status").getLength() > 0 && "FAIL".equalsIgnoreCase(document.getElementsByTagName("status").item(0).getFirstChild().getNodeValue()) && document.getElementsByTagName("cause").getLength() > 0) {
            return document.getElementsByTagName("cause").item(0).getFirstChild().getNodeValue();
        }
        return null;
    }

    private String getPassword(Configuration configuration) throws CryptoException {
        String password = (String)configuration.getInherited("password", (Object)"");
        return this.cryptoSupport.isProtected(password) ? this.cryptoSupport.unprotect(password) : password;
    }

    protected void bindCryptoSupport(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    protected void unbindCryptoSupport(CryptoSupport cryptoSupport) {
        if (this.cryptoSupport == cryptoSupport) {
            this.cryptoSupport = null;
        }
    }

    protected void bindClient(TestandtargetHttpClient testandtargetHttpClient) {
        this.client = testandtargetHttpClient;
    }

    protected void unbindClient(TestandtargetHttpClient testandtargetHttpClient) {
        if (this.client == testandtargetHttpClient) {
            this.client = null;
        }
    }
}

