/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.impl.servlets;

import com.day.cq.analytics.testandtarget.TestandtargetService;
import com.day.cq.analytics.testandtarget.util.OfferHelper;
import com.day.cq.commons.Externalizer;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.commons.WCMUtils;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestandtargetServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(TestandtargetServlet.class);
    private static final String OPERATION_CONNECT = "connect";
    private static final String PARAM_PATH = "cfgpath";
    private static final String PARAM_OPERATION = "operation";
    private TestandtargetService service;
    private ConfigurationManager cfgMgr;
    private Externalizer externalizer;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();
        Resource resource = request.getResource();
        Page currentPage = this.getCurrentPage(request);
        String errorMsg = "";
        try {
            Configuration config = null;
            String path = request.getParameter(PARAM_PATH);
            if (path != null) {
                config = this.cfgMgr.getConfiguration(path);
            }
            String operation = request.getParameter(PARAM_OPERATION);
            Node node = (Node)resource.adaptTo(Node.class);
            String name = currentPage.getPath().substring(1).replace("/", "-");
            String offerUrl = this.buildOfferUrl(request.getResourceResolver(), currentPage.getPath());
            String thirdPartyId = OfferHelper.getThirdPartyID(node);
            String responseThirdPartyId = null;
            try {
                if (OPERATION_CONNECT.equals(operation)) {
                    String clientcode = request.getParameter("clientcode");
                    String email = request.getParameter("email");
                    String password = request.getParameter("password");
                    this.service.checkCredentials(email, password, clientcode);
                    this.writeResponse(out, "success", "true");
                    return;
                }
                if (config == null) {
                    this.writeResponse(out, "error", "Configuration '" + path + "' not found");
                    return;
                }
                if ("saveWidgetOffer".equals(operation)) {
                    responseThirdPartyId = this.service.publishOffer(config, name, offerUrl, thirdPartyId);
                } else if ("deleteWidgetOffer".equals(operation)) {
                    responseThirdPartyId = this.service.unpublishOffer(config, name, offerUrl, thirdPartyId);
                } else {
                    throw new ServletException("Unknown API 'operation'.");
                }
                OfferHelper.setConfigurationPath(config.getPath(), currentPage);
                OfferHelper.setThirdPartyID(node, operation, responseThirdPartyId);
                node.getSession().save();
                this.writeResponse(out, "success", thirdPartyId);
                return;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                errorMsg = e.getCause() instanceof UnknownHostException ? "Could not connect to " + e.getCause().getMessage() : "An exception occured.<br>" + e.getMessage();
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            errorMsg = e.getMessage();
        }
        this.writeResponse(out, "error", errorMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse(PrintWriter out, String propertyname, String msg) {
        JSONObject returnValue = new JSONObject();
        try {
            returnValue.put(propertyname, (Object)msg);
            out.write(returnValue.toString());
        }
        catch (JSONException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            out.flush();
        }
    }

    private String buildOfferUrl(ResourceResolver resolver, String pagePath) {
        String url = this.externalizer.externalLink(resolver, "publish", pagePath);
        url = url + "/_jcr_content/par.html";
        return url;
    }

    private Page getCurrentPage(SlingHttpServletRequest request) {
        ResourceResolver resolver = request.getResource().getResourceResolver();
        ComponentContext componentContext = WCMUtils.getComponentContext((ServletRequest)request);
        PageManager pageManager = (PageManager)resolver.adaptTo(PageManager.class);
        Page currentPage = null;
        if (pageManager != null) {
            currentPage = componentContext == null ? null : componentContext.getPage();
        }
        return currentPage;
    }

    protected void bindService(TestandtargetService testandtargetService) {
        this.service = testandtargetService;
    }

    protected void unbindService(TestandtargetService testandtargetService) {
        if (this.service == testandtargetService) {
            this.service = null;
        }
    }

    protected void bindCfgMgr(ConfigurationManager configurationManager) {
        this.cfgMgr = configurationManager;
    }

    protected void unbindCfgMgr(ConfigurationManager configurationManager) {
        if (this.cfgMgr == configurationManager) {
            this.cfgMgr = null;
        }
    }

    protected void bindExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void unbindExternalizer(Externalizer externalizer) {
        if (this.externalizer == externalizer) {
            this.externalizer = null;
        }
    }
}

