/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public class MboxHelper {
    private MboxHelper() {
    }

    public static String getMboxName(Resource rsrc) {
        String mboxName = "";
        ValueMap resourceConfig = (ValueMap)(rsrc = MboxHelper.getStartResource(rsrc)).adaptTo(ValueMap.class);
        if (resourceConfig != null) {
            mboxName = (String)resourceConfig.get("jcr:title", (Object)"");
            if ("".equals(mboxName)) {
                mboxName = MboxHelper.getMboxId(rsrc);
            }
            mboxName = mboxName.replaceAll("\\s", "");
        }
        return mboxName;
    }

    public static String getMboxId(Resource rsrc) {
        String mboxId = "";
        if ((rsrc = MboxHelper.getStartResource(rsrc)) != null) {
            mboxId = rsrc.getPath().replaceAll("/", "-").replaceAll("-jcr:content", "").substring(1);
        }
        return mboxId;
    }

    public static Resource searchStartElement(Resource resource) {
        Resource current;
        if (ResourceUtil.getName((Resource)resource).equals("jcr:content")) {
            return null;
        }
        if (resource.getPath().lastIndexOf("/") == 0) {
            return null;
        }
        if (ResourceUtil.isA((Resource)resource, (String)"cq/personalization/components/mbox/start")) {
            return resource;
        }
        Resource parent = ResourceUtil.getParent((Resource)resource);
        ArrayList<Resource> predecessor = new ArrayList<Resource>();
        Iterator i = ResourceUtil.listChildren((Resource)parent);
        while (i.hasNext() && !(current = (Resource)i.next()).getPath().equals(resource.getPath())) {
            predecessor.add(current);
        }
        Collections.reverse(predecessor);
        for (Resource current2 : predecessor) {
            if (ResourceUtil.isA((Resource)current2, (String)"cq/personalization/components/mbox/start")) {
                return current2;
            }
            if (!ResourceUtil.isA((Resource)current2, (String)"cq/personalization/components/mbox/end")) continue;
            return null;
        }
        return MboxHelper.searchStartElement(parent);
    }

    private static Resource getStartResource(Resource rsrc) {
        Resource startElement;
        if ("cq/personalization/components/mbox/end".equals(rsrc.getResourceType()) && (startElement = MboxHelper.searchStartElement(rsrc)) != null) {
            return startElement;
        }
        return rsrc;
    }
}

