/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst;

import com.day.cq.analytics.sitecatalyst.ImpressionsPathBuilder;
import com.day.crx.statistics.Entry;
import com.day.crx.statistics.PathBuilder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpressionsEntry
extends Entry {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String VIEWS = "views";
    public static final String ROLLING_WEEK_COUNT = "rollingWeekViews";
    public static final String ROLLING_MONTH_COUNT = "rollingMonthViews";
    private final String pagePath;
    private final long count;

    public ImpressionsEntry(String pathPrefix, String pagePath, String date, long count) {
        super(pathPrefix);
        this.pagePath = pagePath;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            this.setTimestamp(format.parse(date).getTime());
        }
        catch (ParseException e) {
            this.log.error("error while parsing date for impressionsentry", (Throwable)e);
        }
        this.count = count;
    }

    protected PathBuilder getPathBuilder() {
        return new ImpressionsPathBuilder(this.pagePath);
    }

    public void write(Node node) throws RepositoryException {
        this.log.info("writing impressions node " + node.getPath());
        node.setProperty(VIEWS, this.count);
        Node month = node.getParent();
        NodeIterator dayIter = month.getNodes();
        long monthCount = 0L;
        while (dayIter.hasNext()) {
            Node tmp = dayIter.nextNode();
            if (!tmp.hasProperty(VIEWS)) continue;
            monthCount += tmp.getProperty(VIEWS).getLong();
        }
        month.setProperty(VIEWS, monthCount);
        Node year = month.getParent();
        NodeIterator monthIter = year.getNodes();
        long yearCount = 0L;
        while (monthIter.hasNext()) {
            Node tmp = monthIter.nextNode();
            if (!tmp.hasProperty(VIEWS)) continue;
            yearCount += tmp.getProperty(VIEWS).getLong();
        }
        year.setProperty(VIEWS, yearCount);
        node.setProperty(ROLLING_WEEK_COUNT, this.getCumulativeCount(node, 7, VIEWS));
        node.setProperty(ROLLING_MONTH_COUNT, this.getCumulativeCount(node, 30, VIEWS));
    }

    private long getCumulativeCount(Node node, int numDays, String propName) throws RepositoryException, ValueFormatException {
        long viewCount = 0L;
        Session session = node.getSession();
        PathBuilder builder = this.getPathBuilder();
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis(this.getTimestamp());
        ImpressionsEntry entry = new ImpressionsEntry(this.getPathPrefix(), this.pagePath, "1970-01-01", 0L);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < numDays; ++i) {
            buffer.setLength(0);
            entry.setTimestamp(date.getTimeInMillis());
            builder.formatPath((Entry)entry, buffer);
            String path = buffer.toString();
            try {
                Node n;
                Item item = session.getItem(path);
                if (item.isNode() && (n = (Node)item).hasProperty(propName)) {
                    viewCount += n.getProperty(propName).getLong();
                }
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            date.add(5, -1);
        }
        return viewCount;
    }
}

