/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.datainsertion.impl;

import com.day.cq.analytics.sitecatalyst.SitecatalystException;
import com.day.cq.analytics.sitecatalyst.datainsertion.DataInsertionClient;
import com.day.cq.analytics.sitecatalyst.datainsertion.DataInsertionRequest;
import com.day.cq.analytics.sitecatalyst.datainsertion.DataInsertionResponse;
import com.day.cq.analytics.sitecatalyst.datainsertion.impl.SiteCatalystDataInsertionResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteCatalystDataInsertionClient
implements DataInsertionClient {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private HttpClient httpClient;

    public DataInsertionResponse execute(DataInsertionRequest request, String url) throws SitecatalystException {
        PostMethod method = new PostMethod(url);
        try {
            StringRequestEntity requestEntity = new StringRequestEntity(request.toString(), "application/x-www-form-urlencoded", "UTF-8");
            method.setRequestEntity((RequestEntity)requestEntity);
            int status = this.getHttpClient().executeMethod((HttpMethod)method);
            switch (status) {
                case 200: {
                    break;
                }
                default: {
                    throw new SitecatalystException("DataInsertion failed with status code [" + status + "]");
                }
            }
            String response = this.consumeResponse((HttpMethod)method);
            SiteCatalystDataInsertionResponse siteCatalystDataInsertionResponse = new SiteCatalystDataInsertionResponse(response);
            return siteCatalystDataInsertionResponse;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new SitecatalystException(e.getMessage(), e);
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(String url) throws SitecatalystException {
        GetMethod method = new GetMethod(url);
        try {
            int status = this.getHttpClient().executeMethod((HttpMethod)method);
            switch (status) {
                case 200: {
                    return;
                }
                default: {
                    throw new SitecatalystException("DataInsertion failed with status code [" + status + "]");
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new SitecatalystException(e.getMessage(), e);
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String consumeResponse(HttpMethod method) throws IOException {
        StringBuffer sb = new StringBuffer();
        InputStream ins = null;
        try {
            String line;
            ins = method.getResponseBodyAsStream();
            BufferedReader responseReader = new BufferedReader(new InputStreamReader(ins));
            while ((line = responseReader.readLine()) != null) {
                sb.append(line);
            }
        }
        finally {
            if (ins != null) {
                ins.close();
            }
        }
        return sb.toString();
    }

    private HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        }
        return this.httpClient;
    }
}

