/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.datainsertion.impl;

import com.day.cq.analytics.sitecatalyst.datainsertion.DataInsertionRequest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;

public class SiteCatalystDataInsertionRequest
implements DataInsertionRequest {
    public static final String XML_V1 = "1.0";
    private static final String DEFAULT_XML_VERSION = "1.0";
    private List<String> requestXML = new ArrayList<String>();

    public SiteCatalystDataInsertionRequest(String xmlVersion, String reportSuiteID, String visitorID, String visitorIP, String pageName, String pageURL) throws IllegalArgumentException {
        if (xmlVersion == null) {
            throw new IllegalArgumentException("xmlVersion can not be null");
        }
        this.requestXML.add(this.tagify("scXmlVer", xmlVersion));
        if (reportSuiteID == null) {
            throw new IllegalArgumentException("reportSuiteID can not be null");
        }
        this.requestXML.add(this.tagify("reportSuiteID", reportSuiteID));
        if (visitorID == null && visitorIP == null) {
            throw new IllegalArgumentException("visitorID or visitorIP can not be null");
        }
        if (visitorID != null) {
            this.requestXML.add(this.tagify("visitorID", visitorID));
        }
        if (visitorIP != null) {
            this.requestXML.add(this.tagify("ipaddress", visitorIP));
        }
        if (pageName == null && pageURL == null) {
            throw new IllegalArgumentException("pageName or pageURL can not be null");
        }
        if (pageName != null) {
            this.requestXML.add(this.tagify("pageName", pageName));
        }
        if (pageURL != null) {
            this.requestXML.add(this.tagify("pageURL", pageURL));
        }
    }

    public SiteCatalystDataInsertionRequest(String reportSuiteID, String visitorID, String visitorIP, String pageName, String pageURL) throws IllegalArgumentException {
        this("1.0", reportSuiteID, visitorID, visitorIP, pageName, pageURL);
    }

    private String tagify(String name, String value) {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(name);
        sb.append(">");
        sb.append(value);
        sb.append("</");
        sb.append(name);
        sb.append(">");
        return sb.toString();
    }

    public DataInsertionRequest set(String tagname, String value) {
        this.requestXML.add(this.tagify(tagname, StringEscapeUtils.escapeXml((String)value)));
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        sb.append("<request>");
        Iterator<String> it = this.requestXML.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
        }
        sb.append("</request>");
        return sb.toString();
    }
}

