/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl;

import com.day.cq.analytics.sitecatalyst.FrameworkComponent;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkComponentImpl
extends HierarchyNodeInheritanceValueMap
implements FrameworkComponent {
    private CqValueMap cqMappings = null;
    protected String[] contextStores = new String[0];
    protected String[] trackedVars = new String[0];
    protected String[] trackedEvents = new String[0];
    protected String[] trackedVarsEvents = new String[0];
    protected String defaultStore;
    protected String defaultEventStore;
    protected Resource resource;
    protected ValueMap cqComp;
    private Set<String> keySet = null;

    public FrameworkComponentImpl(Resource mappingComp, String[] contextstores) {
        super(mappingComp);
        this.resource = mappingComp;
        this.contextStores = contextstores;
        Resource analyticsRes = mappingComp.getResourceResolver().getResource(this.get("cq:componentPath") + "/analytics");
        Node analyticsNode = (Node)analyticsRes.adaptTo(Node.class);
        this.cqComp = (ValueMap)analyticsRes.adaptTo(ValueMap.class);
        this.defaultStore = (String)this.cqComp.get("cq:defaultStore", (Object)"eventdata");
        this.defaultEventStore = (String)this.cqComp.get("cq:defaultEventStore", (Object)"eventdata.events");
        this.trackedVars = this.getListProperty(analyticsNode, "cq:trackvars");
        this.trackedEvents = this.getListProperty(analyticsNode, "cq:trackevents");
        this.trackedVarsEvents = (String[])ArrayUtils.addAll((Object[])this.qualifyCqVars(this.trackedVars, this.defaultStore), (Object[])this.qualifyCqVars(this.trackedEvents, this.defaultEventStore));
    }

    protected String[] getListProperty(Node node, String propertyName) {
        String[] list = new String[]{};
        try {
            Property property = node.getProperty(propertyName);
            while (property.getType() == 8) {
                property = property.getProperty();
            }
            if (property.isMultiple()) {
                Value[] values = property.getValues();
                list = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    list[i] = values[i].getString();
                }
            } else {
                String value = property.getValue().getString().trim();
                if (value != null && value.startsWith("SELECT ")) {
                    Session session = (Session)this.resource.getResourceResolver().adaptTo(Session.class);
                    QueryManager qm = session.getWorkspace().getQueryManager();
                    Query query = qm.createQuery(value, "JCR-SQL2");
                    QueryResult res = query.execute();
                    RowIterator rows = res.getRows();
                    TreeSet<String> listSet = new TreeSet<String>();
                    while (rows.hasNext()) {
                        Row row = rows.nextRow();
                        Value[] props = row.getValues();
                        for (int i = 0; i < props.length; ++i) {
                            listSet.addAll(Arrays.asList(props[i].getString().split("[,\\s]")));
                        }
                    }
                    list = listSet.toArray(list);
                } else if (!"".equals(value)) {
                    list = value.split("[,\\s]");
                }
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return list;
    }

    protected String[] qualifyCqVars(String[] vars, String defaultStore) {
        String[] qualified = (String[])ArrayUtils.clone((Object[])vars);
        for (int i = 0; i < qualified.length; ++i) {
            String[] valueParts = qualified[i].split("\\.");
            if (valueParts.length != 0 && ArrayUtils.contains((Object[])this.contextStores, (Object)qualified[i].split("\\.")[0])) continue;
            qualified[i] = defaultStore + "." + qualified[i].trim();
        }
        return qualified;
    }

    @Override
    public String getType() {
        return this.resource.getResourceType();
    }

    @Override
    public String getPath() {
        return this.resource.getPath();
    }

    @Override
    public String[] getTrackedVarsEvents() {
        return this.trackedVarsEvents;
    }

    @Override
    public MultiValueMap getCqMappings() {
        if (this.cqMappings == null) {
            this.cqMappings = new CqValueMap();
            for (String scVar : this.inheritedKeySet()) {
                String cqVar = (String)this.getInherited(scVar, "");
                if (cqVar.length() > 0) {
                    this.cqMappings.put(cqVar, scVar);
                    continue;
                }
                for (String var : this.getTrackedVarsEvents()) {
                    if (!this.cqMappings.containsValue(var, scVar)) continue;
                    this.cqMappings.remove(var, scVar);
                }
            }
        }
        return this.cqMappings;
    }

    @Override
    public JSONArray getScVars(String cqVar) {
        return new JSONArray((Collection)this.getCqMappings().get((Object)cqVar));
    }

    public <T> T getInherited(String scKey, Class<T> type) {
        Object value = super.getInherited(scKey, type);
        if (value == null) {
            value = this.cqComp.get((Object)scKey);
        }
        String[] valueParts = ((String)value).split("\\.");
        if (!(scKey.contains(":") || valueParts.length != 0 && ArrayUtils.contains((Object[])this.contextStores, (Object)valueParts[0]))) {
            if (ArrayUtils.contains((Object[])this.trackedVars, (Object)value)) {
                value = this.defaultStore + "." + value;
            } else if (ArrayUtils.contains((Object[])this.trackedEvents, (Object)value)) {
                value = this.defaultEventStore + "." + value;
            }
        }
        return (T)((String)value).trim();
    }

    public Object get(Object key) {
        String cqVar = (String)super.get(key);
        if (cqVar == null) {
            return null;
        }
        String[] valueParts = cqVar.split("\\.");
        if (!(((String)key).contains(":") || valueParts.length != 0 && ArrayUtils.contains((Object[])this.contextStores, (Object)cqVar.split("\\.")[0]))) {
            if (ArrayUtils.contains((Object[])this.trackedVars, (Object)cqVar)) {
                cqVar = this.defaultStore + "." + cqVar;
            } else if (ArrayUtils.contains((Object[])this.trackedEvents, (Object)cqVar)) {
                cqVar = this.defaultEventStore + "." + cqVar;
            }
        }
        return cqVar.trim();
    }

    public Set<String> keySet() {
        if (this.keySet == null) {
            this.keySet = new HashSet<String>(super.keySet());
            for (String key : super.keySet()) {
                if (!key.contains(":")) continue;
                this.keySet.remove(key);
            }
        }
        return this.keySet;
    }

    @Override
    public Set<String> inheritedKeySet() {
        String innerResource = FrameworkComponentImpl.getInnerPath((Resource)this.resource);
        HashSet<String> keySet = new HashSet<String>(this.keySet());
        keySet.addAll(this.cqComp.keySet());
        for (String key : this.cqComp.keySet()) {
            if (!key.contains(":")) continue;
            keySet.remove(key);
        }
        String fwPath = this.resource.getPath().split("jcr:content/" + innerResource)[0];
        Resource parentComp = null;
        for (Resource parentFw = this.resource.getResourceResolver().getResource(fwPath).getParent(); parentFw != null && (parentComp = this.resource.getResourceResolver().getResource(parentFw.getPath() + "/" + "jcr:content" + "/" + innerResource)) == null; parentFw = parentFw.getParent()) {
        }
        if (parentComp != null) {
            keySet.addAll(new FrameworkComponentImpl(parentComp, this.contextStores).inheritedKeySet());
        }
        return keySet;
    }

    @Override
    public ValueMap getAnalyticsProperties() {
        return this.cqComp;
    }

    class CqValueMap
    extends MultiValueMap {
        public CqValueMap() {
            super(new HashMap(), new Factory(){

                public Object create() {
                    return new HashSet<String>(){

                        @Override
                        public String toString() {
                            return StringUtils.join((Collection)this, (String)",");
                        }
                    };
                }
            });
        }
    }
}

