/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl;

import com.day.cq.analytics.sitecatalyst.Framework;
import com.day.cq.analytics.sitecatalyst.FrameworkComponent;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkImpl
extends HierarchyNodeInheritanceValueMap
implements Framework {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Node node;
    private Resource resource;
    private Map<String, FrameworkComponent> allComponents = new HashMap<String, FrameworkComponent>();
    private Map<String, String> mappings = new HashMap<String, String>();
    private Map<String, FrameworkComponent> componentMappings = new HashMap<String, FrameworkComponent>();

    public FrameworkImpl(Resource resource) {
        super(resource);
        try {
            this.loadMappings(resource);
        }
        catch (RepositoryException e) {
            this.log.error(e.toString());
        }
    }

    protected void loadMappings(Resource resource) throws RepositoryException, ValueFormatException, PathNotFoundException {
        this.resource = resource;
        Node parent = this.node = (Node)resource.adaptTo(Node.class);
        while (parent != null && parent.hasProperty("sling:resourceType") && this.node.getProperty("sling:resourceType").getString().equals(parent.getProperty("sling:resourceType").getString())) {
            this.collectComponents(parent);
            if (parent.getNode("mappings") != null && parent.getNode("mappings").hasProperty("propagate") && !parent.getNode("mappings").getProperty("propagate").getBoolean()) break;
            try {
                if ((parent = parent.getParent().getParent().getNode("jcr:content")).getNode("mappings") == null || !parent.getNode("mappings").hasProperty("inheritance") || parent.getNode("mappings").getProperty("inheritance").getBoolean()) continue;
                break;
            }
            catch (Exception e) {
                this.log.debug(e.toString());
                break;
            }
        }
        for (FrameworkComponent component : this.allComponents.values()) {
            for (String scVar : component.inheritedKeySet()) {
                String cqVar = (String)component.getInherited(scVar, String.class);
                if (cqVar == null || "".equals(cqVar.trim())) continue;
                this.mappings.put(scVar, cqVar);
                this.componentMappings.put(scVar, component);
            }
        }
    }

    private void collectComponents(Node framework) {
        for (Node componentNode : new ComponentNodes(framework)) {
            try {
                FrameworkComponent component = (FrameworkComponent)this.resource.getResourceResolver().getResource(componentNode.getPath()).adaptTo(FrameworkComponent.class);
                if (component == null || this.allComponents.containsKey(component.get("cq:componentPath"))) continue;
                this.allComponents.put((String)component.get("cq:componentPath"), component);
            }
            catch (RepositoryException e) {
                this.log.error(e.toString());
            }
        }
    }

    @Override
    public Map<String, FrameworkComponent> getAllComponents() {
        return this.allComponents;
    }

    @Override
    public boolean mapsSCVariable(String var) {
        return this.mappings.containsKey(var);
    }

    @Override
    public boolean mapsCQVariable(String var) {
        return this.mappings.containsValue(var);
    }

    @Override
    public String getMapping(String scVar) {
        return this.mappings.get(scVar);
    }

    @Override
    public FrameworkComponent getFrameworkComponent(String scVar) {
        return this.componentMappings.get(scVar);
    }

    @Override
    public Set<String> scVars() {
        return this.mappings.keySet();
    }

    @Override
    public Collection<String> cqVars() {
        return this.mappings.values();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ComponentNodes
    implements Iterable<Node> {
        Node framework;

        public ComponentNodes(Node framework) {
            this.framework = framework;
        }

        @Override
        public Iterator<Node> iterator() {
            try {
                return this.framework.getNode("mappings").getNodes();
            }
            catch (RepositoryException e) {
                FrameworkImpl.this.log.debug(e.toString());
                return new Iterator<Node>(){

                    @Override
                    public boolean hasNext() {
                        return false;
                    }

                    @Override
                    public Node next() {
                        return null;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        }
    }
}

