/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl;

import com.day.cq.analytics.sitecatalyst.SAINTService;
import com.day.cq.analytics.sitecatalyst.SitecatalystException;
import com.day.cq.analytics.sitecatalyst.SitecatalystHttpClient;
import com.day.cq.analytics.sitecatalyst.common.AbstractSiteCatalystService;
import com.day.cq.wcm.webservicesupport.Configuration;
import java.util.Arrays;
import java.util.Collection;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false, label="%cq.analytics.saint.service.name", description="%cq.analytics.saint.service.description")
@Service
public class SAINTServiceImpl
extends AbstractSiteCatalystService
implements SAINTService {
    @Reference
    private SitecatalystHttpClient client;

    @Override
    public JSONObject getJobStatus(Configuration configuration, int jobId) throws SitecatalystException {
        String result = this.client.execute("Saint.CheckJobStatus", "{\"job_id\":\"" + jobId + "\"}", configuration);
        return this.toJSONObject(result);
    }

    @Override
    public JSONArray getCompatabilityMetrics(Configuration configuration, String[] reportSuites) throws SitecatalystException {
        JSONArray rsids = new JSONArray(Arrays.asList(reportSuites));
        String result = this.client.execute("Saint.GetCompatabiltyMetrics", "{\"report_suite_array\":" + rsids.toString() + "}", configuration);
        return this.toJSONArray(result);
    }

    @Override
    public int createImportJob(Configuration configuration, String description, String email, String[] header, int relationId, boolean checkDivisions, boolean exportResults, boolean overwrite, String ... reportSuites) throws SitecatalystException {
        try {
            JSONArray rsids = new JSONArray(Arrays.asList(reportSuites));
            JSONArray headers = new JSONArray(Arrays.asList(header));
            String result = this.client.execute("Saint.ImportCreateJob", "{\"relation_id\": \"" + relationId + "\"," + "\"check_divisions\":\"" + (checkDivisions ? "1" : "0") + "\"," + "\"description\":\"" + description + "\"," + "\"email_address\":\"" + email + "\"," + "\"export_results\":\"" + (exportResults ? "1" : "0") + "\"," + "\"header\":" + headers.toString() + "," + "\"overwrite_conflicts\":\"" + (overwrite ? "1" : "0") + "\"," + "\"report_suite_array\":" + rsids.toString() + "}", configuration);
            String error = this.getError(result);
            if (error != null) {
                throw new SitecatalystException(error);
            }
            return Integer.parseInt(result.replaceAll("\"", ""));
        }
        catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    @Override
    public boolean populateImportJob(Configuration configuration, int jobId, int page, Collection<String[]> rows) throws SitecatalystException {
        try {
            JSONArray rowsArray = new JSONArray();
            for (String[] r : rows) {
                JSONObject row = new JSONObject();
                row.put("row", (Object)new JSONArray(Arrays.asList(r)));
                rowsArray.put((Object)row);
            }
            String result = this.client.execute("Saint.ImportPopulateJob", "{\"job_id\":\"" + jobId + "\"," + "\"page\":\"" + page + "\"," + "\"rows\":" + rowsArray.toString() + "}", configuration);
            String error = this.getError(result);
            if (error != null) {
                throw new SitecatalystException(error);
            }
            return "Success".equals(result.replaceAll("\"", ""));
        }
        catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    @Override
    public boolean commitImportJob(Configuration configuration, int jobId) throws SitecatalystException {
        String result = this.client.execute("Saint.ImportCommitJob", "{\"job_id\":\"" + jobId + "\"}", configuration);
        return "Success".equals(result.replaceAll("\"", ""));
    }

    protected void bindClient(SitecatalystHttpClient sitecatalystHttpClient) {
        this.client = sitecatalystHttpClient;
    }

    protected void unbindClient(SitecatalystHttpClient sitecatalystHttpClient) {
        if (this.client == sitecatalystHttpClient) {
            this.client = null;
        }
    }
}

