/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl;

import com.day.cq.analytics.sitecatalyst.SitecatalystAccount;
import com.day.cq.analytics.sitecatalyst.SitecatalystException;
import com.day.cq.analytics.sitecatalyst.SitecatalystHttpClient;
import com.day.cq.analytics.sitecatalyst.SitecatalystWebservice;
import com.day.cq.analytics.sitecatalyst.common.AbstractSiteCatalystService;
import com.day.cq.analytics.sitecatalyst.rsmerger.impl.EVarMerger;
import com.day.cq.analytics.sitecatalyst.rsmerger.impl.EventMerger;
import com.day.cq.analytics.sitecatalyst.rsmerger.impl.TrafficVarMerger;
import com.day.cq.wcm.webservicesupport.Configuration;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

@Component(metatype=true, label="%cq.analytics.sitecatalyst.service.name", description="%cq.analytics.sitecatalyst.service.description")
@Service
@Properties(value={@Property(name="service.description", value={"SiteCatalyst Client Wrapper"})})
public class SitecatalystWebserviceImpl
extends AbstractSiteCatalystService
implements SitecatalystWebservice {
    @Reference
    private SitecatalystHttpClient client;

    public void checkCredentials(String company, String username, String secret) throws SitecatalystException {
        try {
            JSONObject json = new JSONObject();
            json.put("rs_type", (Object)new JSONArray("['standard']"));
            json.put("sp", (Object)"");
            this.client.execute("Company.GetReportSuites", json.toString(), company, username, secret);
        }
        catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    public String getLoginKey(String company, String username, String password) throws SitecatalystException {
        try {
            JSONObject json = new JSONObject();
            json.put("company", (Object)company);
            json.put("login", (Object)username);
            json.put("password", (Object)password);
            String response = this.client.execute("Company.GetLoginKey", json.toString(), null, null, null);
            String error = this.getError(response);
            if (error != null) {
                throw new SitecatalystException(error);
            }
            return response.replaceAll("\"", "");
        }
        catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    public String getReportSuites(SitecatalystAccount account) throws SitecatalystException {
        throw new UnsupportedOperationException("This method is no longer supported.");
    }

    public String getReportSuites(Configuration configuration) throws SitecatalystException {
        try {
            JSONObject json = new JSONObject();
            json.put("rs_type", (Object)new JSONArray("['standard']"));
            json.put("sp", (Object)"");
            return this.client.execute("Company.GetReportSuites", json.toString(), configuration);
        }
        catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    public String getTrackingServer(SitecatalystAccount account, String rsid) throws SitecatalystException {
        throw new UnsupportedOperationException("This method is no longer supported");
    }

    public String getTrackingServer(Configuration configuration, String rsid) throws SitecatalystException {
        try {
            JSONObject json = new JSONObject();
            json.put("rsid", (Object)rsid);
            return this.client.execute("Company.GetTrackingServer", json.toString(), configuration);
        }
        catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    public String getEvars(SitecatalystAccount account, String rsid) throws SitecatalystException {
        throw new UnsupportedOperationException("This method is no longer supported");
    }

    public String getEvars(Configuration configuration, String rsid) throws SitecatalystException {
        try {
            JSONArray rsidList = this.splitToJSONArray(rsid);
            JSONObject json = new JSONObject();
            json.put("rsid_list", (Object)rsidList);
            String result = this.client.execute("ReportSuite.GetEVars", json.toString(), configuration);
            JSONArray array = this.toJSONArray(result);
            this.checkResults(rsidList, array);
            return new EVarMerger(array).getReportSuite().toString();
        }
        catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    public String getTrafficVars(SitecatalystAccount account, String rsid) throws SitecatalystException {
        throw new UnsupportedOperationException("This method is no longer supported");
    }

    public String getTrafficVars(Configuration configuration, String rsid) throws SitecatalystException {
        try {
            JSONArray rsidList = this.splitToJSONArray(rsid);
            JSONObject json = new JSONObject();
            json.put("rsid_list", (Object)rsidList);
            String result = this.client.execute("ReportSuite.GetTrafficVars", json.toString(), configuration);
            JSONArray array = this.toJSONArray(result);
            this.checkResults(rsidList, array);
            return new TrafficVarMerger(array).getReportSuite().toString();
        }
        catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    public String getSuccessEvents(SitecatalystAccount account, String rsid) throws SitecatalystException {
        throw new UnsupportedOperationException("This method is no longer supported");
    }

    public String getSuccessEvents(Configuration configuration, String rsid) throws SitecatalystException {
        try {
            JSONArray rsidList = this.splitToJSONArray(rsid);
            JSONObject json = new JSONObject();
            json.put("rsid_list", (Object)rsidList);
            String result = this.client.execute("ReportSuite.GetSuccessEvents", json.toString(), configuration);
            JSONArray array = this.toJSONArray(result);
            this.checkResults(rsidList, array);
            return new EventMerger(array).getReportSuite().toString();
        }
        catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    public String queueReport(Configuration configuration, String reportType, JSONObject reportDescription) throws SitecatalystException {
        try {
            JSONObject reportQueue = new JSONObject();
            reportQueue.put("reportDescription", (Object)reportDescription);
            return this.client.execute("Report.Queue" + reportType, reportQueue.toString(), configuration);
        }
        catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    public String queuePageViewReport(SitecatalystAccount account, String rsid, String date) throws SitecatalystException {
        throw new UnsupportedOperationException("This method is no longer supported");
    }

    public String queuePageViewReport(Configuration configuration, String rsid, String date) throws SitecatalystException {
        try {
            JSONObject reportDescription = new JSONObject();
            reportDescription.put("reportSuiteID", (Object)rsid);
            reportDescription.put("date", (Object)date);
            reportDescription.put("metrics", (Object)new JSONArray("[{\"id\": \"pageViews\"}]"));
            reportDescription.put("elements", (Object)new JSONArray("[{\"id\": \"page\"}]"));
            JSONObject reportQueue = new JSONObject();
            reportQueue.put("reportDescription", (Object)reportDescription);
            return this.client.execute("Report.QueueRanked", reportQueue.toString(), configuration);
        }
        catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    public String getReportStatus(SitecatalystAccount account, String rsid) throws SitecatalystException {
        throw new UnsupportedOperationException("This method is no longer supported");
    }

    public String getReportStatus(Configuration configuration, String reportID) throws SitecatalystException {
        try {
            JSONObject json = new JSONObject();
            json.put("reportID", (Object)reportID);
            return this.client.execute("Report.GetStatus", json.toString(), configuration);
        }
        catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    public String getReport(SitecatalystAccount account, String rsid) throws SitecatalystException {
        throw new UnsupportedOperationException("This method is no longer supported");
    }

    public String getReport(Configuration configuration, String reportID) throws SitecatalystException {
        try {
            JSONObject json = new JSONObject();
            json.put("reportID", (Object)reportID);
            return this.client.execute("Report.GetReport", json.toString(), configuration);
        }
        catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    public String getSynchronousReport(Configuration configuration, String reportType, JSONObject reportDescription) throws SitecatalystException {
        try {
            JSONObject reportQueue = new JSONObject();
            reportQueue.put("reportDescription", (Object)reportDescription);
            return this.client.execute("Report.Get" + reportType + "Report", reportQueue.toString(), configuration);
        }
        catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    public String getPages(SitecatalystAccount account, Integer limit, String pagename, String rsid, Integer start) throws SitecatalystException {
        throw new UnsupportedOperationException("This method is no longer supported");
    }

    public String getPages(Configuration configuration, Integer limit, String pagename, String rsid, Integer start) throws SitecatalystException {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            JSONObject json = new JSONObject();
            json.put("limit", (Object)limit);
            json.put("page_search", (Object)pagename);
            json.put("rsid_list", (Object)this.splitToJSONArray(rsid));
            json.put("sc_period", (Object)sdf.format(new Date()));
            json.put("start_point", (Object)start);
            return this.client.execute("ReportSuite.GetPages", json.toString(), configuration);
        }
        catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    private final JSONArray splitToJSONArray(String s) {
        JSONArray array = new JSONArray();
        for (String piece : s.split(",")) {
            array.put((Object)piece);
        }
        return array;
    }

    private final void checkResults(JSONArray requestArray, JSONArray resultArray) throws JSONException, SitecatalystException {
        int i;
        HashSet<String> rsidSet = new HashSet<String>();
        for (i = 0; i < resultArray.length(); ++i) {
            rsidSet.add(resultArray.getJSONObject(i).getString("rsid"));
        }
        for (i = 0; i < requestArray.length(); ++i) {
            String rsid = requestArray.getString(i);
            if (rsidSet.contains(rsid)) continue;
            throw new SitecatalystException("Report suite with ID " + rsid + "  was not in result");
        }
    }

    protected void bindClient(SitecatalystHttpClient sitecatalystHttpClient) {
        this.client = sitecatalystHttpClient;
    }

    protected void unbindClient(SitecatalystHttpClient sitecatalystHttpClient) {
        if (this.client == sitecatalystHttpClient) {
            this.client = null;
        }
    }
}

