/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl.exporter;

import com.adobe.cq.scheduled.exporter.ExportException;
import com.adobe.cq.scheduled.exporter.Exporter;
import com.adobe.cq.scheduled.exporter.TransformationException;
import com.day.cq.analytics.sitecatalyst.SAINTService;
import com.day.cq.analytics.sitecatalyst.SAINTTransformer;
import com.day.cq.wcm.webservicesupport.Configuration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, label="%cq.analytics.saint.exporter.name", description="%cq.analytics.saint.exporter.description")
@Service
@Properties(value={@Property(name="exporter.type", value={"saint-exporter"}, propertyPrivate=true)})
public class SAINTExporter
implements Exporter {
    private static final int DEFAULT_PAGE_SIZE = 1000;
    private static final int MAX_PAGESIZE = 25000;
    @Property(intValue={1000})
    private static final String PAGE_SIZE = "cq.analytics.saint.exporter.pagesize";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private SAINTService saintService;
    @Reference(referenceInterface=SAINTTransformer.class, name="transformer", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE)
    private Map<String, SAINTTransformer> transformers = new HashMap<String, SAINTTransformer>();
    private int pageSize = 1000;
    private ComponentContext context;
    private Set<ServiceReference> delayedTransformers = new HashSet<ServiceReference>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportData(Resource config, Resource source) throws ExportException {
        block23: {
            ResourceResolver resolver = source.getResourceResolver();
            Session session = (Session)resolver.adaptTo(Session.class);
            LockManager lockMgr = null;
            Node sourceNode = (Node)source.adaptTo(Node.class);
            try {
                this.log.debug("exportData: Locking source node for export");
                sourceNode.addMixin("mix:lockable");
                sourceNode.getSession().save();
                lockMgr = session.getWorkspace().getLockManager();
                lockMgr.lock(sourceNode.getPath(), true, true, Long.MAX_VALUE, null);
                if (source.listChildren().hasNext()) {
                    ValueMap props = (ValueMap)config.getParent().adaptTo(ValueMap.class);
                    Resource configPageResource = config.getParent().getParent().getParent();
                    Configuration configuration = (Configuration)configPageResource.adaptTo(Configuration.class);
                    String transformerClass = (String)props.get("transformer", null);
                    SAINTTransformer transformer = this.transformers.get(transformerClass);
                    if (transformer == null) {
                        throw new ExportException("exportData: No bound transformer {" + transformerClass + "} found");
                    }
                    this.log.debug("exportData: Using transformer {}", (Object)transformer.getClass().getName());
                    Object[] header = transformer.getHeader((Resource)source.listChildren().next());
                    String description = (String)props.get("description", (Object)"CQ SAINT Export");
                    String email = (String)props.get("email", (Object)"");
                    boolean checkCompatability = (Boolean)props.get("checkdivisons", (Object)true);
                    boolean overwrite = (Boolean)props.get("overwrite", (Object)false);
                    int dataset = (Integer)props.get("dataset", (Object)0);
                    Object[] reportsuites = (String[])props.get("reportsuites", (Object)new String[0]);
                    boolean deleteProcessed = (Boolean)props.get("deleteprocessed", (Object)false);
                    this.log.debug("exportData: Create import job (description=" + description + ",email=" + email + ",header=" + Arrays.toString(header) + ",relation-id=" + dataset + ",check-divisions=" + checkCompatability + ",export=" + false + ",overwrite=" + overwrite + ",reportsuites=" + Arrays.toString(reportsuites) + ")", (Object)Arrays.toString(header));
                    int jobId = this.saintService.createImportJob(configuration, description, email, (String[])header, dataset, checkCompatability, false, overwrite, (String[])reportsuites);
                    Iterator it = source.listChildren();
                    int page = 1;
                    ArrayList<String[]> rows = new ArrayList<String[]>();
                    ArrayList<Resource> processed = new ArrayList<Resource>();
                    while (it.hasNext()) {
                        Resource data = (Resource)it.next();
                        try {
                            Object[] row = (String[])transformer.transform(data);
                            this.log.debug("exportData: Adding data entry {}: {}", (Object)data.getPath(), (Object)Arrays.toString(row));
                            rows.add((String[])row);
                            processed.add(data);
                        }
                        catch (TransformationException te) {
                            this.log.error("exportData: Error occurred during transformation", (Throwable)te);
                            continue;
                        }
                        if (it.hasNext() && rows.size() < this.pageSize) continue;
                        this.log.debug("exportData: SAINT ImportPopulateJob(jobId={},page={})", (Object)jobId, (Object)page);
                        boolean success = this.saintService.populateImportJob(configuration, jobId, page, rows);
                        if (!success) {
                            this.log.error("exportData: SAINT ImportPopulateJob was not successful.");
                            throw new ExportException("exportData: SAINT ImportPopulateJob was not successful.");
                        }
                        rows.clear();
                        ++page;
                    }
                    if (!this.saintService.commitImportJob(configuration, jobId)) {
                        this.log.error("exportData: SAINT ImportCommitJob was not successful.");
                        throw new ExportException("exportData: SAINT ImportCommitJob was not successful.");
                    }
                    if (deleteProcessed) {
                        this.log.debug("exportData: Deleting processed nodes.");
                        this.deleteProcessedNodes(session, processed);
                        processed.clear();
                    }
                    break block23;
                }
                this.log.info("exportData: No data available for export");
            }
            catch (Exception e) {
                this.log.error("exportData: An error occurred during export", (Throwable)e);
            }
            finally {
                try {
                    if (lockMgr != null && sourceNode.isLocked()) {
                        this.log.debug("exportData: Unlocking node");
                        lockMgr.unlock(source.getPath());
                    }
                }
                catch (LockException le) {
                    this.log.warn("exportData: Unlocking node failed.");
                }
                catch (RepositoryException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void deleteProcessedNodes(Session session, List<Resource> processed) throws RepositoryException {
        for (Resource proc : processed) {
            Node procNode = (Node)proc.adaptTo(Node.class);
            procNode.remove();
        }
        session.save();
    }

    @Activate
    protected void activate(ComponentContext context) {
        Dictionary properties = context.getProperties();
        this.context = context;
        this.pageSize = OsgiUtil.toInteger(properties.get(PAGE_SIZE), (int)1000);
        if (this.pageSize > 25000) {
            this.pageSize = 25000;
        }
        for (ServiceReference serviceReference : this.delayedTransformers) {
            this.bindSAINTTransformer(serviceReference);
        }
        this.delayedTransformers.clear();
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.context = null;
    }

    protected void bindSAINTTransformer(ServiceReference ref) {
        ComponentContext context = this.context;
        if (context != null) {
            SAINTTransformer transformer = (SAINTTransformer)context.locateService("transformer", ref);
            if (transformer != null) {
                SAINTTransformer registeredTransformer = this.transformers.get(transformer.getClass().getName());
                if (registeredTransformer == null) {
                    this.log.info("bindSAINTTransformer: Registering class {}", (Object)transformer.getClass().getName());
                    this.transformers.put(transformer.getClass().getName(), transformer);
                } else {
                    this.log.warn("bindSAINTTransformer: Class {} already registered by exporter {}", (Object)ref.getClass().getName(), (Object)registeredTransformer);
                }
            }
        } else {
            this.delayedTransformers.add(ref);
        }
    }

    protected void unbindSAINTTransformer(ServiceReference ref) {
        SAINTTransformer transformer;
        ComponentContext context = this.context;
        if (context != null && (transformer = (SAINTTransformer)context.locateService("transformer", ref)) != null) {
            this.log.info("unbindSAINTTransformer: Unregistering class {}", (Object)transformer.getClass().getName());
            this.transformers.remove(transformer.getClass().getName());
        }
        this.delayedTransformers.remove(ref);
    }

    protected void bindSaintService(SAINTService sAINTService) {
        this.saintService = sAINTService;
    }

    protected void unbindSaintService(SAINTService sAINTService) {
        if (this.saintService == sAINTService) {
            this.saintService = null;
        }
    }
}

