/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl.importer;

import com.day.cq.analytics.sitecatalyst.Framework;
import com.day.cq.analytics.sitecatalyst.impl.importer.ReportPathBuilder;
import com.day.cq.analytics.sitecatalyst.util.SitecatalystJsonItemReader;
import com.day.crx.statistics.Entry;
import com.day.crx.statistics.PathBuilder;
import java.net.URL;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportEntry
extends Entry {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected JSONObject report;
    protected String[] elementIds;
    protected String[] metricIds;
    protected int numMetrics;
    protected Framework framework;

    public ReportEntry(String pathPrefix, JSONObject report, ResourceResolver resolver, Framework framework) throws JSONException {
        super(pathPrefix);
        this.framework = framework;
        this.log.info("scvars: " + framework.scVars().toString());
        this.report = this.prepareReport(report, resolver);
    }

    protected JSONObject prepareReport(JSONObject report, ResourceResolver resolver) throws JSONException {
        int i;
        int numElements = report.getJSONArray("elements").length();
        this.numMetrics = report.getJSONArray("metrics").length();
        String reportType = report.getString("type");
        this.elementIds = new String[numElements];
        for (i = 0; i < numElements; ++i) {
            this.elementIds[i] = report.getJSONArray("elements").getJSONObject(i).getString("id");
            if (!this.framework.mapsSCVariable(this.elementIds[i])) continue;
            this.log.info("mapping element " + this.elementIds[i] + " to " + this.framework.getMapping(this.elementIds[i]));
            this.elementIds[i] = this.framework.getMapping(this.elementIds[i]);
            report.getJSONArray("elements").getJSONObject(i).put("mapping", (Object)this.elementIds[i]);
        }
        this.metricIds = new String[this.numMetrics];
        for (i = 0; i < this.numMetrics; ++i) {
            this.metricIds[i] = report.getJSONArray("metrics").getJSONObject(i).getString("id");
            if (!this.framework.mapsSCVariable(this.metricIds[i])) continue;
            this.log.info("mapping metric " + this.metricIds[i] + " to " + this.framework.getMapping(this.metricIds[i]));
            this.metricIds[i] = this.framework.getMapping(this.metricIds[i]);
            report.getJSONArray("metrics").getJSONObject(i).put("mapping", (Object)this.metricIds[i]);
        }
        if (numElements > 0) {
            JSONArray dataEntries = report.getJSONArray("data");
            JSONArray preparedEntires = new JSONArray();
            for (int i2 = 0; i2 < dataEntries.length(); ++i2) {
                preparedEntires.put((Object)this.prepareElement(dataEntries.getJSONObject(i2), 0, resolver));
            }
            report.put(this.elementIds[0], (Object)preparedEntires);
            report.remove("data");
        }
        report = this.prepareMetrics(report, "totals");
        this.log.info("preparing report type: " + reportType + " #elements: " + numElements + " #metrics: " + this.numMetrics);
        return report;
    }

    protected JSONObject prepareElement(JSONObject data, int level, ResourceResolver resolver) throws JSONException {
        if (data.has("breakdown")) {
            JSONArray dataEntries = data.getJSONArray("breakdown");
            JSONArray preparedEntires = new JSONArray();
            for (int i = 0; i < dataEntries.length(); ++i) {
                preparedEntires.put((Object)this.prepareElement(dataEntries.getJSONObject(i), level + 1, resolver));
            }
            data.put(this.elementIds[level + 1], (Object)preparedEntires);
            data.remove("breakdown");
        }
        if (this.elementIds[level].equals("page")) {
            String url = data.optString("url");
            try {
                URL urlObj = new URL(url);
                Resource resource = resolver.getResource(urlObj.getPath().replace(".html", ""));
                if (resource != null) {
                    data.put("cq:path", (Object)resource.getPath());
                }
            }
            catch (Exception e) {
                this.log.warn("Error parsing ur {}", (Object)url);
            }
        }
        data = this.prepareMetrics(data, "counts");
        return data;
    }

    protected JSONObject prepareMetrics(JSONObject data, String key) throws JSONException {
        Object countsObj = data.get(key);
        if (countsObj instanceof JSONArray) {
            JSONArray counts = (JSONArray)countsObj;
            for (int i = 0; i < this.numMetrics; ++i) {
                data.put(this.metricIds[i], counts.optLong(i));
            }
        } else if (countsObj instanceof JSONObject) {
            JSONObject counts = (JSONObject)countsObj;
            for (int i = 0; i < this.numMetrics; ++i) {
                data.put(this.metricIds[i], counts.optLong(Integer.toString(i)));
            }
        }
        data.remove(key);
        return data;
    }

    protected PathBuilder getPathBuilder() {
        return new ReportPathBuilder();
    }

    public void write(Node node) throws RepositoryException {
        this.log.info("writing report node " + node.getPath());
        SitecatalystJsonItemReader reader = new SitecatalystJsonItemReader();
        try {
            reader.readObject(node.getParent(), node.getName(), this.report);
        }
        catch (Exception e) {
            this.log.error("error while storing report", (Throwable)e);
        }
    }

    public JSONObject getReport() {
        return this.report;
    }
}

