/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl.importer;

import com.day.cq.analytics.sitecatalyst.Framework;
import com.day.cq.analytics.sitecatalyst.SitecatalystException;
import com.day.cq.analytics.sitecatalyst.SitecatalystUtil;
import com.day.cq.analytics.sitecatalyst.SitecatalystWebservice;
import com.day.cq.analytics.sitecatalyst.impl.importer.ReportEntry;
import com.day.cq.analytics.sitecatalyst.util.RelativeDateFormat;
import com.day.cq.analytics.sitecatalyst.util.SitecatalystJsonItemWriter;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.polling.importer.ImportException;
import com.day.cq.polling.importer.Importer;
import com.day.cq.statistics.StatisticsService;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import com.day.crx.statistics.Entry;
import java.io.CharArrayWriter;
import java.util.Date;
import java.util.Dictionary;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="%cq.analytics.sitecatalyst.reportpolling.reportimporter.name", description="%cq.analytics.sitecatalyst.reportpolling.reportimporter.description")
@Service
@Properties(value={@Property(name="importer.scheme", value={"screport"}, propertyPrivate=true)})
public class ReportImporter
implements Importer,
TopologyEventListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_REPORT_TYPE = "ranked";
    private static final String DEFAULT_REPORT_BASEPATH = "/var/statistics/sitecatalyst";
    @Property(longValue={43200000L})
    protected static final String REPORT_INTERVAL = "cq.analytics.sitecatalyst.reportpolling.importer.inverval";
    @Reference
    private SitecatalystWebservice webservice;
    @Reference
    private ConfigurationManager cfgManager;
    @Reference
    private StatisticsService statService;
    @Reference
    private SlingSettingsService settingsService;
    private Long reportInterval = 43200000L;
    private boolean isMasterInstance = false;

    public void importData(String scheme, String dataSource, Resource target) throws ImportException {
        if (!this.isMasterInstance) {
            this.log.info("Import skipped on slave instance");
            return;
        }
        Node reportNode = (Node)target.adaptTo(Node.class);
        if (reportNode == null) {
            this.log.error("Report node [{}] not found.", (Object)target.getPath());
            return;
        }
        try {
            String lastAttempt = "0";
            if (reportNode.hasProperty("cq:lastAttempt")) {
                lastAttempt = reportNode.getProperty("cq:lastAttempt").getString();
            }
            Configuration configuration = null;
            if (reportNode.hasProperty("cq:cloudserviceconfig")) {
                if (this.cfgManager != null) {
                    configuration = this.cfgManager.getConfiguration(reportNode.getProperty("cq:cloudserviceconfig").getString());
                }
            } else {
                PageManager pm = (PageManager)target.getResourceResolver().adaptTo(PageManager.class);
                Page page = pm.getContainingPage(target);
                Resource contentResource = page.getContentResource();
                HierarchyNodeInheritanceValueMap pageProperties = new HierarchyNodeInheritanceValueMap(contentResource);
                String[] services = (String[])pageProperties.getInherited("cq:cloudserviceconfigs", (Object)new String[0]);
                if (this.cfgManager != null && services.length > 0) {
                    configuration = this.cfgManager.getConfiguration("sitecatalyst", services);
                }
            }
            if (configuration != null) {
                if (lastAttempt.startsWith("waiting")) {
                    String reportID = lastAttempt.replace("waiting-", "");
                    this.retrieveReport(reportID, configuration, target, reportNode);
                    return;
                }
                long last = Long.parseLong(lastAttempt);
                if (last + this.reportInterval < System.currentTimeMillis()) {
                    this.log.info("importing report from sitecatalyst: " + dataSource + " " + target.getPath());
                    String reportSuiteID = SitecatalystUtil.getReportSuites(this.settingsService, configuration);
                    if (reportSuiteID == null) {
                        this.log.warn("cannot import data since no valid report suite ID was found");
                        return;
                    }
                    this.queueReport(reportSuiteID, configuration, target, reportNode);
                    return;
                }
            } else {
                this.log.info("No valid sitecatalyst config found for {}, skipping report", (Object)target.getPath());
            }
        }
        catch (Exception e) {
            this.log.error("error while triggering report", (Throwable)e);
        }
    }

    protected void queueReport(String reportSuiteID, Configuration configuration, Resource target, Node reportNode) throws RepositoryException, ValueFormatException, AccessDeniedException {
        try {
            ValueMap reportValueMap = (ValueMap)target.adaptTo(ValueMap.class);
            String reportType = StringUtils.capitalize((String)((String)reportValueMap.get("cq:reportType", (Object)DEFAULT_REPORT_TYPE)));
            this.log.info("queueing a " + reportType + " report for " + reportSuiteID);
            SitecatalystJsonItemWriter itemWriter = new SitecatalystJsonItemWriter();
            CharArrayWriter charArray = new CharArrayWriter();
            itemWriter.dump((Node)target.getChild("reportDescription").adaptTo(Node.class), charArray, -1);
            this.log.debug("report config is: " + charArray.toString());
            JSONObject reportDescription = new JSONObject(charArray.toString());
            reportDescription = ReportImporter.adjustDates(reportDescription);
            reportDescription.put("reportSuiteID", (Object)reportSuiteID);
            String response = this.webservice.queueReport(configuration, reportType, reportDescription);
            this.log.debug("queue report: " + response);
            JSONObject jsonObj = new JSONObject(response);
            Long reportID = jsonObj.getLong("reportID");
            if (jsonObj.getString("status").equals("queued")) {
                reportNode.setProperty("cq:lastAttempt", "waiting-" + reportID);
                reportNode.getSession().save();
                this.log.info("Report queued: " + reportID + " for " + reportSuiteID);
            } else {
                String errorMsg = "";
                if (jsonObj.has("error_msg")) {
                    errorMsg = jsonObj.getString("error_msg");
                } else if (jsonObj.has("statusMsg")) {
                    errorMsg = jsonObj.getString("statusMsg");
                }
                this.log.warn(jsonObj.toString());
                this.log.warn("queueing report failed with status '" + jsonObj.getString("status") + "' and error message '" + errorMsg + "'");
            }
        }
        catch (SitecatalystException e) {
            this.log.error("Call to SiteCatalyst failed", (Throwable)e);
        }
        catch (JSONException e) {
            this.log.error("Parsing JSON response failed", (Throwable)e);
        }
    }

    protected void retrieveReport(String reportID, Configuration configuration, Resource target, Node reportNode) throws RepositoryException, ValueFormatException, AccessDeniedException {
        try {
            ResourceResolver resolver = target.getResourceResolver();
            ValueMap reportValueMap = (ValueMap)target.adaptTo(ValueMap.class);
            String response = this.webservice.getReportStatus(configuration, reportID);
            JSONObject jsonObj = new JSONObject(response);
            if (jsonObj.getString("status").equals("done")) {
                response = this.webservice.getReport(configuration, reportID);
                this.log.debug("get report: " + response);
                jsonObj = new JSONObject(response);
                JSONObject report = jsonObj.getJSONObject("report");
                boolean clearPrevious = (Boolean)reportValueMap.get("cq:clearPrevious", (Object)false);
                if (clearPrevious) {
                    this.clearReportData(resolver, reportNode, reportValueMap);
                }
                this.saveReportData(reportNode, reportValueMap, report, resolver, configuration);
                this.log.info("Report " + reportID + " imported");
                reportNode.setProperty("cq:lastAttempt", Long.toString(System.currentTimeMillis()));
                reportNode.getSession().save();
            } else if (jsonObj.getString("status").equals("failed")) {
                String errorMsg = "";
                if (jsonObj.has("error_msg")) {
                    errorMsg = jsonObj.getString("error_msg");
                } else if (jsonObj.has("statusMsg")) {
                    errorMsg = jsonObj.getString("statusMsg");
                }
                this.log.info("Report " + reportID + " failed due to (" + jsonObj.getInt("error_code") + ") " + errorMsg);
                reportNode.setProperty("cq:lastAttempt", Long.toString(System.currentTimeMillis() - this.reportInterval));
                reportNode.getSession().save();
            } else {
                this.log.info("Report " + reportID + " status is " + jsonObj.getString("status"));
            }
        }
        catch (SitecatalystException e) {
            this.log.error("Call to Sitecatalyst failed", (Throwable)e);
            reportNode.setProperty("cq:lastAttempt", Long.toString(System.currentTimeMillis() - this.reportInterval));
            reportNode.getSession().save();
        }
        catch (JSONException e) {
            this.log.error("Parsing JSON response failed", (Throwable)e);
            reportNode.setProperty("cq:lastAttempt", Long.toString(System.currentTimeMillis() - this.reportInterval));
            reportNode.getSession().save();
        }
    }

    protected void saveReportData(Node reportNode, ValueMap reportValueMap, JSONObject report, ResourceResolver resolver, Configuration configuration) {
        try {
            String reportBasePath = (String)reportValueMap.get("cq:reportBasePath", (Object)DEFAULT_REPORT_BASEPATH) + reportNode.getPath();
            Framework framework = (Framework)configuration.getResource().getChild("jcr:content").adaptTo(Framework.class);
            if (framework != null) {
                ReportEntry reportEntry = new ReportEntry(reportBasePath, report, resolver, framework);
                try {
                    this.statService.addEntry((Entry)reportEntry);
                }
                catch (RepositoryException e) {
                    this.log.error("adding stats entry failed", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.log.error("error while saving report data", (Throwable)e);
        }
    }

    protected void clearReportData(ResourceResolver resolver, Node reportNode, ValueMap reportValueMap) throws RepositoryException {
        Session session = null;
        try {
            String reportBasePath = (String)reportValueMap.get("cq:reportBasePath", (Object)DEFAULT_REPORT_BASEPATH) + reportNode.getPath();
            Resource reportData = resolver.getResource(reportBasePath);
            if (reportData != null) {
                Node dataNode = (Node)reportData.adaptTo(Node.class);
                Node parent = dataNode.getParent();
                session = parent.getSession();
                dataNode.remove();
                session.save();
            }
        }
        catch (Exception e) {
            if (session != null) {
                session.refresh(false);
            }
            this.log.error("error while clearing report data", (Throwable)e);
        }
    }

    public static JSONObject adjustDates(JSONObject reportDescription) {
        if (reportDescription.has("date")) {
            ReportImporter.adjustOneDate(reportDescription, "date", "datePattern");
        }
        if (reportDescription.has("dateFrom")) {
            ReportImporter.adjustOneDate(reportDescription, "dateFrom", "dateFromPattern");
        }
        if (reportDescription.has("dateTo")) {
            ReportImporter.adjustOneDate(reportDescription, "dateTo", "dateToPattern");
        }
        return reportDescription;
    }

    protected static void adjustOneDate(JSONObject reportDescription, String dateKey, String patternKey) {
        try {
            String date = reportDescription.getString(dateKey);
            String formatPattern = "yyyy-MM-dd";
            if (reportDescription.has(patternKey)) {
                formatPattern = reportDescription.getString(patternKey);
                reportDescription.remove(patternKey);
            }
            RelativeDateFormat format = new RelativeDateFormat(formatPattern);
            Date newDate = format.parseRelative(date);
            reportDescription.put(dateKey, (Object)format.format(newDate));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void activate(ComponentContext componentContext) {
        this.log.debug("Starting ReportImporter...");
        Dictionary config = componentContext.getProperties();
        this.reportInterval = (Long)config.get(REPORT_INTERVAL);
        this.log.debug("...ReportImporter started");
    }

    protected void deactivate(ComponentContext componentContext) {
        this.log.debug("Stopping ReportImporter...");
        this.log.debug("...ReportImporter stopped");
    }

    public void handleTopologyEvent(TopologyEvent event) {
        if (event.getType() == TopologyEvent.Type.TOPOLOGY_CHANGED || event.getType() == TopologyEvent.Type.TOPOLOGY_INIT) {
            this.isMasterInstance = event.getNewView().getLocalInstance().isLeader();
        }
    }

    protected void bindWebservice(SitecatalystWebservice sitecatalystWebservice) {
        this.webservice = sitecatalystWebservice;
    }

    protected void unbindWebservice(SitecatalystWebservice sitecatalystWebservice) {
        if (this.webservice == sitecatalystWebservice) {
            this.webservice = null;
        }
    }

    protected void bindCfgManager(ConfigurationManager configurationManager) {
        this.cfgManager = configurationManager;
    }

    protected void unbindCfgManager(ConfigurationManager configurationManager) {
        if (this.cfgManager == configurationManager) {
            this.cfgManager = null;
        }
    }

    protected void bindStatService(StatisticsService statisticsService) {
        this.statService = statisticsService;
    }

    protected void unbindStatService(StatisticsService statisticsService) {
        if (this.statService == statisticsService) {
            this.statService = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }
}

