/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl.servlets;

import com.day.cq.analytics.sitecatalyst.SitecatalystWebservice;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;

@Component
public class AbstractOptionsServlet
extends SlingAllMethodsServlet {
    protected static final String PARAM_CONFIG_PATH = "configPath";
    @Reference
    protected ConfigurationManager configManager;
    @Reference
    protected SitecatalystWebservice catalystService;

    protected Configuration getConfiguration(SlingHttpServletRequest request, String servicename) throws RepositoryException {
        String configPath = request.getParameter(PARAM_CONFIG_PATH);
        if (configPath != null) {
            return this.configManager.getConfiguration(configPath);
        }
        Resource resource = request.getResource();
        ResourceResolver resolver = resource.getResourceResolver();
        PageManager pageManager = (PageManager)resolver.adaptTo(PageManager.class);
        Page currentPage = pageManager.getContainingPage(resource);
        Configuration configuration = (Configuration)currentPage.adaptTo(Configuration.class);
        if (configuration != null) {
            return configuration;
        }
        Resource configRes = this.configManager.getConfigurationResource(currentPage.getContentResource());
        if (configRes != null) {
            return this.configManager.getConfiguration(this.getConfigurationPath(configRes, servicename));
        }
        return null;
    }

    protected String getConfigurationPath(Resource resource, String servicename) throws RepositoryException {
        Resource cloudconfigsContent = resource.getChild("jcr:content");
        Node cloudconfigsNode = (Node)cloudconfigsContent.adaptTo(Node.class);
        Property prop = cloudconfigsNode.getProperty("cq:cloudserviceconfigs");
        String configPath = null;
        if (prop.isMultiple()) {
            for (Value val : prop.getValues()) {
                String path = val.getString();
                if (path == null || path.indexOf(servicename) <= -1) continue;
                configPath = path;
            }
        } else {
            String path = prop.getValue().getString();
            if (path != null && path.indexOf(servicename) > -1) {
                configPath = path;
            }
        }
        return configPath;
    }

    protected void bindConfigManager(ConfigurationManager configurationManager) {
        this.configManager = configurationManager;
    }

    protected void unbindConfigManager(ConfigurationManager configurationManager) {
        if (this.configManager == configurationManager) {
            this.configManager = null;
        }
    }

    protected void bindCatalystService(SitecatalystWebservice sitecatalystWebservice) {
        this.catalystService = sitecatalystWebservice;
    }

    protected void unbindCatalystService(SitecatalystWebservice sitecatalystWebservice) {
        if (this.catalystService == sitecatalystWebservice) {
            this.catalystService = null;
        }
    }
}

