/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl.servlets;

import com.day.cq.analytics.sitecatalyst.SAINTService;
import com.day.cq.analytics.sitecatalyst.SitecatalystException;
import com.day.cq.analytics.sitecatalyst.impl.servlets.AbstractOptionsServlet;
import com.day.cq.wcm.webservicesupport.Configuration;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Properties(value={@Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.selectors", value={"compatabilitymetricsoptions"}), @Property(name="sling.servlet.resourceTypes", value={"cq/analytics/components/saintclassificationpage"}), @Property(name="sling.servlet.methods", value={"GET"})})
public class CompatabilityMetricsServlet
extends AbstractOptionsServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String PARAM_REPORTSUITES = "reportSuites";
    @Reference
    private SAINTService saintService;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();
        JSONObject options = new JSONObject();
        JSONArray metrics = new JSONArray();
        try {
            Configuration configuration = this.getConfiguration(request, "sitecatalyst");
            String[] reportSuites = this.getReportSuites(request, configuration);
            if (configuration != null && reportSuites != null) {
                metrics = this.saintService.getCompatabilityMetrics(configuration, reportSuites);
                options.put("metrics", (Object)metrics);
            }
            options.put("metrics", (Object)metrics);
            out.write(options.toString());
        }
        catch (SitecatalystException e) {
            this.log.error("Call to SAINT method 'Saint.GetCompatabiltyMetrics' failed", (Throwable)e);
            try {
                options.put("metrics", (Object)metrics);
            }
            catch (JSONException ignored) {
                // empty catch block
            }
            out.write(options.toString());
        }
        catch (Exception e) {
            this.log.error("Exception occured while building compatability metrics", (Throwable)e);
            throw new ServletException("Exception occured while building compatability metrics", (Throwable)e);
        }
        finally {
            out.flush();
        }
    }

    private String[] getReportSuites(SlingHttpServletRequest request, Configuration configuration) {
        String rsids;
        String[] reportSuites = request.getParameterValues(PARAM_REPORTSUITES);
        if (configuration != null && reportSuites == null && (rsids = (String)configuration.getInherited("reportsuite", (Object)"")).length() > 0) {
            reportSuites = rsids.split(",");
        }
        return reportSuites;
    }

    protected void bindSaintService(SAINTService sAINTService) {
        this.saintService = sAINTService;
    }

    protected void unbindSaintService(SAINTService sAINTService) {
        if (this.saintService == sAINTService) {
            this.saintService = null;
        }
    }
}

