/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl.servlets;

import com.day.cq.analytics.sitecatalyst.Framework;
import com.day.cq.analytics.sitecatalyst.FrameworkComponent;
import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.servlet.ServletException;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.io.JSONWriter;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false)
@Service
@Properties(value={@Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.paths", value={"/libs/cq/analytics/sitecatalyst/mappingconflicts"}), @Property(name="sling.servlet.methods", value={"GET"})})
public class MappingConflictsServlet
extends SlingSafeMethodsServlet
implements EventListener {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String SCVAR_PARAM = "scVar";
    private static final String RSID_PARAM = "rsid";
    private static final String EMPTY_CQVARS = " ";
    private static final String CQ_PAGE = "cq:Page";
    private static final String CQ_COMPONENT_NAME = "cq:componentName";
    private static final String MAPARSYS = "cq/analytics/components/mappings/maparsys";
    @Reference
    private ConfigurationManager configManager;
    @Reference
    private QueryBuilder queryBuilder;
    @Reference
    private SlingRepository repository;
    @Reference
    private JcrResourceResolverFactory jcrResourceResolverFactory;
    private static Map<String, Map<String, MultiValueMap>> rsMappings = new HashMap<String, Map<String, MultiValueMap>>();
    private Session adminSession;
    private ResourceResolver adminResolver;

    @Activate
    protected void activate(ComponentContext componentContext) throws Exception {
        this.adminSession = this.repository.loginAdministrative(this.repository.getDefaultWorkspace());
        this.adminResolver = this.jcrResourceResolverFactory.getResourceResolver(this.adminSession);
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) throws Exception {
        rsMappings.clear();
        this.adminResolver = null;
        this.adminSession.logout();
        this.adminSession = null;
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            String[] scVarArray = request.getParameterValues(SCVAR_PARAM);
            String[] rsidArray = request.getParameterValues(RSID_PARAM);
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            Resource resource = request.getResource();
            ResourceResolver resolver = resource.getResourceResolver();
            Session session = (Session)resolver.adaptTo(Session.class);
            JSONWriter json = new JSONWriter((Writer)response.getWriter());
            json.object();
            if (scVarArray != null && rsidArray != null) {
                HashSet<String> scVarSet = new HashSet<String>(Arrays.asList(scVarArray));
                HashMap<String, SetValueMap> conflicts = new HashMap<String, SetValueMap>();
                for (String string : scVarSet) {
                    conflicts.put(string, new SetValueMap());
                }
                this.scanFrameworks(resolver, session);
                for (String rsid : rsidArray) {
                    Map<String, MultiValueMap> mapping = rsMappings.get(rsid);
                    if (mapping == null) continue;
                    for (Map.Entry<String, MultiValueMap> entry : mapping.entrySet()) {
                        String scVar = entry.getKey();
                        MultiValueMap rsMapping = entry.getValue();
                        if (!scVarSet.contains(scVar) || rsMapping.size() <= 1) continue;
                        ((MultiValueMap)conflicts.get(scVar)).putAll((Map)rsMapping);
                    }
                }
                for (Map.Entry entry : conflicts.entrySet()) {
                    String scVar = (String)entry.getKey();
                    MultiValueMap rsMapping = (MultiValueMap)entry.getValue();
                    if (rsMapping.isEmpty()) continue;
                    json.key(scVar).object();
                    for (Object cqVar : rsMapping.keySet()) {
                        Collection frameworks = rsMapping.getCollection(cqVar);
                        json.key(cqVar.toString()).array();
                        for (Object framework : frameworks) {
                            json.value((Object)framework.toString());
                        }
                        json.endArray();
                    }
                    json.endObject();
                }
            }
            json.endObject();
        }
        catch (Exception e) {
            this.log.error("Exception occured while scanning for mapping conflicts", (Throwable)e);
            throw new ServletException("Exception occured while scanning for mapping conflicts", (Throwable)e);
        }
    }

    public void onEvent(EventIterator events) {
        while (events.hasNext()) {
            Event event = events.nextEvent();
            try {
                String path = event.getPath();
                int position = path.lastIndexOf(47);
                if (position < 0) {
                    return;
                }
                String scVar = path.substring(position + 1);
                Resource resource = this.adminResolver.getResource(path = path.substring(0, position));
                if (resource == null) {
                    return;
                }
                ValueMap properties = (ValueMap)resource.adaptTo(ValueMap.class);
                if (properties == null) {
                    return;
                }
                String componentFramework = (String)properties.get(CQ_COMPONENT_NAME, (Object)"");
                String cqVar = (String)properties.get(scVar, (Object)EMPTY_CQVARS);
                Resource mappingsResource = resource.getParent();
                if (mappingsResource == null) {
                    return;
                }
                Resource contentResource = mappingsResource.getParent();
                if (contentResource == null) {
                    return;
                }
                properties = (ValueMap)contentResource.adaptTo(ValueMap.class);
                if (properties == null) {
                    return;
                }
                componentFramework = (String)properties.get("jcr:title", (Object)"") + "/" + componentFramework;
                Resource frameworkResource = contentResource.getParent();
                if (frameworkResource == null) {
                    return;
                }
                if (!MAPARSYS.equals(mappingsResource.getResourceType())) continue;
                Configuration configuration = this.configManager.getConfiguration(frameworkResource.getPath());
                String rsidList = (String)configuration.getInherited("reportsuite", (Object)"");
                for (String rsid : rsidList.split(",")) {
                    Map<String, MultiValueMap> mapping = this.getReportSuiteMapping(rsid);
                    MultiValueMap scMapping = this.getScMapping(mapping, scVar);
                    for (Object cqElement : scMapping.keySet()) {
                        scMapping.remove(cqElement, (Object)componentFramework);
                    }
                    if (EMPTY_CQVARS.equals(cqVar)) continue;
                    scMapping.put((Object)cqVar, (Object)componentFramework);
                }
            }
            catch (RepositoryException e) {
                this.log.error("Exception occured while listening for added nodes", (Throwable)e);
            }
        }
    }

    private void scanFrameworks(ResourceResolver resolver, Session session) {
        PredicateGroup rootPred = new PredicateGroup("components");
        Predicate pathPred = new Predicate("rootPath", "path");
        pathPred.set("path", "/etc/cloudservices/sitecatalyst/*//");
        pathPred.set("exact", "true");
        rootPred.add(pathPred);
        Predicate typePred = new Predicate("nodeType", "type");
        typePred.set("type", CQ_PAGE);
        rootPred.add(typePred);
        Query query = this.queryBuilder.createQuery(rootPred, session);
        query.setHitsPerPage(0L);
        query.setStart(0L);
        SearchResult result = query.getResult();
        List hits = result.getHits();
        rsMappings.clear();
        for (Hit hit : hits) {
            try {
                String path = hit.getPath();
                Resource resultResource = hit.getResource();
                Resource contentResource = resultResource.getChild("jcr:content");
                Configuration configuration = this.configManager.getConfiguration(path);
                if (contentResource == null || configuration == null) continue;
                ValueMap contentProperties = (ValueMap)contentResource.adaptTo(ValueMap.class);
                Framework framework = (Framework)contentResource.adaptTo(Framework.class);
                if (contentProperties == null || framework == null) continue;
                String frameworkPath = resultResource.getPath();
                String rsidList = (String)configuration.getInherited("reportsuite", (Object)"");
                this.addMappings(rsidList.split(","), framework, frameworkPath);
            }
            catch (RepositoryException e) {
                this.log.error("Repository Exception occured while accessing an analytics component", (Throwable)e);
            }
        }
    }

    private void addMappings(String[] rsidArray, Framework framework, String path) {
        String name = (String)framework.get("jcr:title", "");
        Map<String, FrameworkComponent> allComponents = framework.getAllComponents();
        for (String rsid : rsidArray) {
            Map<String, MultiValueMap> mapping = this.getReportSuiteMapping(rsid);
            for (Map.Entry<String, FrameworkComponent> entry : allComponents.entrySet()) {
                FrameworkComponent component = entry.getValue();
                String componentName = (String)component.get(CQ_COMPONENT_NAME, "");
                MultiValueMap cqMappings = component.getCqMappings();
                for (Object cqVar : cqMappings.keySet()) {
                    String scVarList = cqMappings.get(cqVar).toString();
                    for (String scVar : scVarList.split(",")) {
                        MultiValueMap scMapping = this.getScMapping(mapping, scVar);
                        scMapping.put(cqVar, (Object)MappingConflictsServlet.generateConflictInfo(name, path, componentName));
                    }
                }
            }
        }
    }

    private Map<String, MultiValueMap> getReportSuiteMapping(String rsid) {
        Map<String, MultiValueMap> mapping = rsMappings.get(rsid);
        if (mapping == null) {
            mapping = new HashMap<String, MultiValueMap>();
            rsMappings.put(rsid, mapping);
        }
        return mapping;
    }

    private MultiValueMap getScMapping(Map<String, MultiValueMap> mapping, String scVar) {
        MultiValueMap scMapping = mapping.get(scVar);
        if (scMapping == null) {
            scMapping = new MultiValueMap();
            mapping.put(scVar, scMapping);
        }
        return scMapping;
    }

    private static String generateConflictInfo(String frameworkName, String frameworkPath, String componentName) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("frameworkName", (Object)frameworkName);
        }
        catch (JSONException e) {
            // empty catch block
        }
        try {
            jsonObj.put("frameworkPath", (Object)frameworkPath);
        }
        catch (JSONException e) {
            // empty catch block
        }
        try {
            jsonObj.put("componentName", (Object)componentName);
        }
        catch (JSONException e) {
            // empty catch block
        }
        return jsonObj.toString();
    }

    protected void bindConfigManager(ConfigurationManager configurationManager) {
        this.configManager = configurationManager;
    }

    protected void unbindConfigManager(ConfigurationManager configurationManager) {
        if (this.configManager == configurationManager) {
            this.configManager = null;
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.jcrResourceResolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.jcrResourceResolverFactory == jcrResourceResolverFactory) {
            this.jcrResourceResolverFactory = null;
        }
    }

    private class SetValueMap
    extends MultiValueMap {
        public SetValueMap() {
            super(new HashMap(), new Factory(){

                public Object create() {
                    return new HashSet();
                }
            });
        }
    }
}

