/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl.servlets;

import com.day.cq.commons.TidyJSONWriter;
import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import com.day.cq.wcm.api.designer.Designer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false)
@Service
@Properties(value={@Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.paths", value={"/libs/cq/reporting/properties"}), @Property(name="sling.servlet.methods", value={"GET"})})
public class PropertiesServlet
extends SlingSafeMethodsServlet
implements EventListener {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String ANALYTICS_SUFFIX = "/analytics";
    private static final String CQ_COMPONENT = "cq:Component";
    private static final String MAPPINGS_SUFFIX = "/jcr:content/framework/mappings";
    private static final String TEMPLATE_PATH = "/libs/cq/analytics/templates/framework/jcr:content";
    private static final String TIDY_PARAM = "tidy";
    @Reference
    private QueryBuilder queryBuilder;
    @Reference
    private SlingRepository repository;
    @Reference
    private JcrResourceResolverFactory jcrResourceResolverFactory;
    private Session adminSession;
    private ResourceResolver adminResolver;

    @Activate
    protected void activate(ComponentContext componentContext) throws Exception {
        this.adminSession = this.repository.loginAdministrative(this.repository.getDefaultWorkspace());
        this.adminSession.getWorkspace().getObservationManager().addEventListener((EventListener)this, 3, "/", true, null, null, false);
        this.adminResolver = this.jcrResourceResolverFactory.getResourceResolver(this.adminSession);
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) throws Exception {
        this.adminResolver = null;
        this.adminSession.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        this.adminSession.logout();
        this.adminSession = null;
    }

    public void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            String tidy = request.getParameter(TIDY_PARAM);
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            TidyJSONWriter json = new TidyJSONWriter((Writer)response.getWriter());
            json.setTidy("true".equals(tidy));
            Resource instanceResource = request.getResource();
            ResourceResolver resolver = instanceResource.getResourceResolver();
            Session session = (Session)resolver.adaptTo(Session.class);
            json.object();
            json.key("components").array();
            for (String component : this.getAnalyticsComponents(resolver, session)) {
                json.value((Object)component);
            }
            json.endArray();
            json.endObject();
        }
        catch (Exception e) {
            this.log.error("Exception occured while scanning for analytics components", (Throwable)e);
            throw new ServletException("Exception occured while scanning for analytics components", (Throwable)e);
        }
    }

    public void onEvent(EventIterator events) {
        boolean analyticsChanged = false;
        while (events.hasNext()) {
            Event event = events.nextEvent();
            try {
                String parentPath;
                Node parentNode;
                String path = event.getPath();
                if (!path.endsWith(ANALYTICS_SUFFIX) || (parentNode = PropertiesServlet.getNode(this.adminResolver, parentPath = path.substring(0, path.length() - ANALYTICS_SUFFIX.length()))) != null && !parentNode.isNodeType(CQ_COMPONENT)) continue;
                analyticsChanged = true;
                break;
            }
            catch (RepositoryException e) {
                this.log.error("Exception occured while listening for added nodes", (Throwable)e);
            }
        }
        if (analyticsChanged) {
            try {
                Node mappings;
                String mappingsPath = PropertiesServlet.getMappingsPath(this.adminResolver, TEMPLATE_PATH);
                if (mappingsPath != null && (mappings = PropertiesServlet.getNode(this.adminResolver, mappingsPath)) != null && mappings.hasProperty("components")) {
                    mappings.setProperty("components", (String[])null);
                    this.adminSession.save();
                }
            }
            catch (Exception e) {
                this.log.error("Exception occured while trying to delete the components property", (Throwable)e);
            }
        }
    }

    private List<String> getAnalyticsComponents(ResourceResolver resolver, Session session) {
        PredicateGroup rootPred = new PredicateGroup("components");
        Predicate pathPred = new Predicate("rootPath", "path");
        pathPred.set("path", "/");
        rootPred.add(pathPred);
        Predicate typePred = new Predicate("nodeType", "type");
        typePred.set("type", CQ_COMPONENT);
        rootPred.add(typePred);
        Query query = this.queryBuilder.createQuery(rootPred, session);
        query.setHitsPerPage(0L);
        query.setStart(0L);
        SearchResult result = query.getResult();
        List hits = result.getHits();
        ArrayList<String> analyticsComponents = new ArrayList<String>();
        for (Hit hit : hits) {
            try {
                ValueMap analyticsProperties;
                String group;
                Resource resultResource = hit.getResource();
                ValueMap resultProperties = (ValueMap)resultResource.adaptTo(ValueMap.class);
                Resource analyticsResource = resolver.getResource(resultResource, "analytics");
                if (analyticsResource == null || ((group = (String)(analyticsProperties = (ValueMap)analyticsResource.adaptTo(ValueMap.class)).get("cq:componentGroup", null)) != null ? this.isHiddenComponentGroup(group) : this.isHiddenComponentGroup((String)resultProperties.get("componentGroup", (Object)"")))) continue;
                analyticsComponents.add(resultResource.getPath());
            }
            catch (RepositoryException e) {
                this.log.error("Repository Exception occured while accessing an analytics component", (Throwable)e);
            }
        }
        return analyticsComponents;
    }

    private boolean isHiddenComponentGroup(String group) {
        return group.startsWith(".");
    }

    private static Node getNode(ResourceResolver resourceResolver, String path) {
        Node node;
        Resource resource = resourceResolver.getResource(path);
        if (resource != null && (node = (Node)resource.adaptTo(Node.class)) != null) {
            return node;
        }
        return null;
    }

    private static String getMappingsPath(ResourceResolver resourceResolver, String path) throws ValueFormatException, PathNotFoundException, RepositoryException {
        Node templateNode;
        Designer designer = (Designer)resourceResolver.adaptTo(Designer.class);
        String mappingsPath = null;
        if (designer != null && (templateNode = PropertiesServlet.getNode(resourceResolver, path)) != null) {
            mappingsPath = templateNode.getProperty("cq:designPath").getString() + MAPPINGS_SUFFIX;
        }
        return mappingsPath;
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.jcrResourceResolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.jcrResourceResolverFactory == jcrResourceResolverFactory) {
            this.jcrResourceResolverFactory = null;
        }
    }
}

