/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl.servlets;

import com.day.cq.analytics.sitecatalyst.Framework;
import com.day.cq.analytics.sitecatalyst.SitecatalystException;
import com.day.cq.analytics.sitecatalyst.SitecatalystUtil;
import com.day.cq.analytics.sitecatalyst.SitecatalystWebservice;
import com.day.cq.analytics.sitecatalyst.impl.importer.ReportEntry;
import com.day.cq.analytics.sitecatalyst.impl.importer.ReportImporter;
import com.day.cq.analytics.sitecatalyst.util.SitecatalystJsonItemWriter;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.io.CharArrayWriter;
import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Properties(value={@Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.selectors", value={"sitecatalystreport"}), @Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}), @Property(name="sling.servlet.methods", value={"GET"})})
public class ReportServlet
extends SlingAllMethodsServlet {
    private static final String TIDY_PARAM = "tidy";
    private static final String SYNCHRONOUS_PARAM = "synchronous";
    @Reference
    private SitecatalystWebservice webservice;
    @Reference
    private ConfigurationManager cfgManager;
    @Reference
    private SlingSettingsService settingsService;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Resource resource = request.getResource();
        ValueMap resourceProperties = (ValueMap)resource.adaptTo(ValueMap.class);
        if (resource.getChild("reportDescription") == null) {
            response.sendError(500, "Invalid report description");
            return;
        }
        if ("true".equals(request.getParameter(SYNCHRONOUS_PARAM))) {
            Configuration configuration = null;
            if (resourceProperties.containsKey((Object)"cq:cloudserviceconfig")) {
                if (this.cfgManager != null) {
                    configuration = this.cfgManager.getConfiguration((String)resourceProperties.get("cq:cloudserviceconfig", (Object)""));
                }
            } else {
                PageManager pm = (PageManager)resource.getResourceResolver().adaptTo(PageManager.class);
                Page page = pm.getContainingPage(resource);
                Resource contentResource = page.getContentResource();
                HierarchyNodeInheritanceValueMap pageProperties = new HierarchyNodeInheritanceValueMap(contentResource);
                String[] services = (String[])pageProperties.getInherited("cq:cloudserviceconfigs", (Object)new String[0]);
                if (this.cfgManager != null && services.length > 0) {
                    configuration = this.cfgManager.getConfiguration("sitecatalyst", services);
                }
            }
            if (configuration != null) {
                try {
                    String reportSuiteID = SitecatalystUtil.getReportSuites(this.settingsService, configuration);
                    JSONObject report = this.getSynchronousReport(reportSuiteID, configuration, resource);
                    Framework framework = (Framework)configuration.getResource().getChild("jcr:content").adaptTo(Framework.class);
                    if (framework == null) return;
                    ReportEntry reportEntry = new ReportEntry("", report, resource.getResourceResolver(), framework);
                    response.getWriter().println(reportEntry.getReport());
                    return;
                }
                catch (Exception e) {
                    this.log.error("Error while getting synchronous analytics report", (Throwable)e);
                    response.sendError(500, "Error while getting synchronous analytics report");
                    return;
                }
            }
            this.log.error("No valid cloudconfiguration found.");
            response.sendError(500, "No valid cloudconfiguration found.");
            return;
        }
        ValueMap reportValueMap = (ValueMap)resource.adaptTo(ValueMap.class);
        Node reportNode = (Node)resource.adaptTo(Node.class);
        try {
            String reportBasePath = (String)reportValueMap.get("cq:reportBasePath", (Object)"/var/statistics/sitecatalyst") + reportNode.getPath();
            SitecatalystJsonItemWriter itemWriter = new SitecatalystJsonItemWriter();
            itemWriter.setTidy("true".equals(request.getParameter(TIDY_PARAM)));
            CharArrayWriter charArray = new CharArrayWriter();
            Resource report = resource.getResourceResolver().getResource(reportBasePath);
            if (report == null) {
                response.sendError(404, "No report data found for this report description");
                return;
            }
            itemWriter.dump((Node)report.adaptTo(Node.class), charArray, -1);
            response.getWriter().println(charArray.toString());
            return;
        }
        catch (Exception e) {
            this.log.error("Error while writing analytics report", (Throwable)e);
            response.sendError(500, "Error while writing analytics report");
            return;
        }
    }

    protected JSONObject getSynchronousReport(String reportSuiteID, Configuration configuration, Resource resource) throws RepositoryException {
        try {
            ValueMap reportValueMap = (ValueMap)resource.adaptTo(ValueMap.class);
            String reportType = StringUtils.capitalize((String)((String)reportValueMap.get("cq:reportType", (Object)"ranked")));
            this.log.info("getting a synchronous " + reportType + " report for " + reportSuiteID);
            SitecatalystJsonItemWriter itemWriter = new SitecatalystJsonItemWriter();
            CharArrayWriter charArray = new CharArrayWriter();
            itemWriter.dump((Node)resource.getChild("reportDescription").adaptTo(Node.class), charArray, -1);
            this.log.debug("report config is: " + charArray.toString());
            JSONObject reportDescription = new JSONObject(charArray.toString());
            reportDescription = ReportImporter.adjustDates(reportDescription);
            reportDescription.put("reportSuiteID", (Object)reportSuiteID);
            String response = this.webservice.getSynchronousReport(configuration, reportType, reportDescription);
            this.log.debug("get synchronous report: " + response);
            JSONObject jsonObj = new JSONObject(response);
            if (jsonObj.has("report")) {
                return jsonObj.getJSONObject("report");
            }
            this.log.warn(jsonObj.getJSONArray("errors").toString());
            this.log.warn("getting synchronous report failed with errors: " + jsonObj.getJSONArray("errors").toString());
        }
        catch (SitecatalystException e) {
            this.log.error("Call to SiteCatalyst failed", (Throwable)e);
        }
        catch (JSONException e) {
            this.log.error("Parsing JSON response failed", (Throwable)e);
        }
        return new JSONObject();
    }

    protected void bindWebservice(SitecatalystWebservice sitecatalystWebservice) {
        this.webservice = sitecatalystWebservice;
    }

    protected void unbindWebservice(SitecatalystWebservice sitecatalystWebservice) {
        if (this.webservice == sitecatalystWebservice) {
            this.webservice = null;
        }
    }

    protected void bindCfgManager(ConfigurationManager configurationManager) {
        this.cfgManager = configurationManager;
    }

    protected void unbindCfgManager(ConfigurationManager configurationManager) {
        if (this.cfgManager == configurationManager) {
            this.cfgManager = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }
}

