/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl.servlets;

import com.day.cq.analytics.sitecatalyst.SAINTTransformer;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONObject;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Properties(value={@Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.selectors", value={"sainttransformeroptions"}), @Property(name="sling.servlet.resourceTypes", value={"cq/analytics/components/saintclassificationpage"}), @Property(name="sling.servlet.methods", value={"GET"})})
public class SAINTTransformerServlet
extends SlingSafeMethodsServlet {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ServiceTracker serviceTracker;
    private Map<String, SAINTTransformer> services = new HashMap<String, SAINTTransformer>();
    private int serviceCount;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.registerServicesIfNeeded();
        try {
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            JSONObject json = new JSONObject();
            JSONArray transformers = new JSONArray();
            if (this.services.size() > 0) {
                for (Map.Entry<String, SAINTTransformer> entry : this.services.entrySet()) {
                    SAINTTransformer t = entry.getValue();
                    JSONObject o = new JSONObject();
                    o.put("name", (Object)entry.getKey());
                    o.put("class", (Object)t.getClass().getName());
                    transformers.put((Object)o);
                }
            }
            json.put("transformers", (Object)transformers);
            out.write(json.toString());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerServicesIfNeeded() {
        if (this.serviceCount != this.serviceTracker.getTrackingCount()) {
            this.serviceCount = this.serviceTracker.getTrackingCount();
            ArrayList<SAINTTransformer> transformers = new ArrayList<SAINTTransformer>();
            ServiceReference[] refs = this.serviceTracker.getServiceReferences();
            if (refs != null) {
                for (ServiceReference svc : refs) {
                    transformers.add((SAINTTransformer)this.serviceTracker.getService(svc));
                }
            }
            ArrayList<SAINTTransformer> arrayList = transformers;
            synchronized (arrayList) {
                this.services.clear();
                for (SAINTTransformer t : transformers) {
                    this.services.put(t.getClass().getSimpleName(), t);
                }
            }
            this.log.info("SAINTTransformer tracker count changed, list rebuilt with {} services: [{}]", (Object)this.services.size(), this.services.keySet());
        }
    }

    @Activate
    protected void activate(ComponentContext ctx) throws Exception {
        this.serviceCount = -1;
        this.serviceTracker = new ServiceTracker(ctx.getBundleContext(), SAINTTransformer.class.getName(), null);
        this.serviceTracker.open();
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx) throws Exception {
        this.serviceTracker.close();
        this.serviceTracker = null;
    }
}

