/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl.servlets;

import com.day.cq.wcm.api.components.ComponentEditConfig;
import com.day.cq.wcm.api.components.ComponentManager;
import com.day.cq.wcm.api.components.VirtualComponent;
import com.day.text.Text;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Properties(value={@Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.paths", value={"/libs/cq/analytics/sitecatalystcomponent"}), @Property(name="sling.servlet.methods", value={"GET"})})
public class SitecatalystComponentServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(SitecatalystComponentServlet.class);
    private static final String ICON = "icon";
    private static final String THUMBNAIL = "thumbnail";
    private static final String DESCRIPTION = "description";
    private static final String RESOURCE_TYPE = "resourceType";
    private static final String DIV_ATTRIBUTES = "divAttributes";
    private static final String TITLE = "title";
    private static final String GROUP = "group";
    private static final String PATH = "path";
    private static final String VIRTUAL = "virtual";
    private static final String DIALOG = "dialog";
    private static final String CONFIG = "config";
    private static final String TEMPLATE_PATH = "templatePath";
    private static final String CELL_NAMES = "cellNames";
    private static final String IS_CONTAINER = "isContainer";
    private static final String CQ_COMPONENT_GROUP = "cq:componentGroup";
    private static final String CQ_COMPONENT_NAME = "cq:componentName";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        ResourceResolver resolver = request.getResourceResolver();
        String prefix = request.getContextPath();
        if (prefix == null) {
            prefix = "";
        }
        String json = null;
        ComponentFilter componentFilter = ComponentFilter.fromRequest((HttpServletRequest)request);
        try {
            ComponentManager compMgr = (ComponentManager)resolver.adaptTo(ComponentManager.class);
            json = this.collectComponents(compMgr, prefix, componentFilter, resolver);
        }
        catch (JSONException e) {
            log.error("Error while generating component json", (Throwable)e);
        }
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        response.getWriter().write(json);
        log.info("provided components for mode {} ", (Object)componentFilter);
    }

    private String collectComponents(ComponentManager compMgr, String prefix, ComponentFilter componentFilter, ResourceResolver resolver) throws JSONException {
        StringWriter ret = new StringWriter();
        JSONWriter w = new JSONWriter((Writer)ret);
        TreeMap<String, Object> components = new TreeMap<String, Object>();
        for (com.day.cq.wcm.api.components.Component c : compMgr.getComponents()) {
            if (c == null || !c.isAccessible() || !componentFilter.include(c, resolver)) continue;
            boolean displayVirtualsOnly = (Boolean)c.getProperties().get("displayVirtualsOnly", (Object)Boolean.FALSE);
            if (!displayVirtualsOnly) {
                components.put(c.getPath(), c);
            }
            for (VirtualComponent v : c.getVirtualComponents()) {
                components.put(v.getPath(), v);
            }
        }
        HashSet<String> resourceTypes = new HashSet<String>();
        w.object();
        for (com.day.cq.wcm.api.components.Component c : components.values()) {
            String templatePath;
            String dialogPath;
            ComponentEditConfig ed;
            String key;
            if (c instanceof VirtualComponent) {
                String p = c.getPath();
                key = p.substring(p.indexOf("/", 1) + 1);
            } else {
                key = c.getResourceType();
            }
            if (resourceTypes.contains(key)) continue;
            resourceTypes.add(key);
            w.key(key).object();
            w.key(PATH).value((Object)c.getPath());
            String title = null;
            String group = null;
            Resource analyticsResource = resolver.getResource(c.getPath() + "/analytics");
            if (analyticsResource != null) {
                ValueMap analyticsProperties = (ValueMap)analyticsResource.adaptTo(ValueMap.class);
                group = (String)analyticsProperties.get(CQ_COMPONENT_GROUP, null);
                title = (String)analyticsProperties.get(CQ_COMPONENT_NAME, null);
            }
            if (group == null) {
                group = c.getComponentGroup();
            }
            if (group != null) {
                w.key(GROUP).value((Object)group);
            }
            if (title == null || title.trim().length() == 0) {
                title = c.getTitle();
            }
            if (title == null) {
                title = Text.getName((String)c.getPath());
            }
            if (c instanceof VirtualComponent) {
                w.key(VIRTUAL).value(true);
            }
            w.key(TITLE).value((Object)title);
            w.key(RESOURCE_TYPE).value((Object)c.getResourceType());
            this.writeDivAttributes(w, c);
            if (c.getDescription() != null) {
                w.key(DESCRIPTION).value((Object)c.getDescription());
            }
            if (c.getThumbnailPath() != null) {
                w.key(THUMBNAIL).value((Object)(prefix + c.getThumbnailPath()));
            }
            if (c.getIconPath() != null) {
                w.key(ICON).value((Object)(prefix + c.getIconPath()));
            }
            if ((ed = c.getEditConfig()) != null && !ed.isDefault()) {
                w.key(CONFIG);
                ed.write(w);
            }
            if ((dialogPath = c.getDialogPath()) != null) {
                if (!dialogPath.endsWith(".json")) {
                    dialogPath = dialogPath + ".infinity.json";
                }
                w.key(DIALOG).value((Object)dialogPath);
            }
            if ((templatePath = c.getTemplatePath()) != null) {
                w.key(TEMPLATE_PATH).value((Object)templatePath);
            }
            w.key(CELL_NAMES);
            w.array();
            w.value((Object)c.getCellName());
            for (com.day.cq.wcm.api.components.Component component = c.getSuperComponent(); component != null; component = component.getSuperComponent()) {
                w.value((Object)component.getName());
            }
            w.endArray();
            if (c.isContainer()) {
                w.key(IS_CONTAINER).value(c.isContainer());
            }
            w.endObject();
        }
        w.endObject();
        return ret.toString();
    }

    private void writeDivAttributes(JSONWriter w, com.day.cq.wcm.api.components.Component c) throws JSONException {
        HashMap<String, String> attrs = new HashMap<String, String>(c.getHtmlTagAttributes());
        if (!attrs.containsKey("class")) {
            StringBuffer clazz = new StringBuffer();
            String delim = "";
            for (com.day.cq.wcm.api.components.Component cc = c; cc != null; cc = cc.getSuperComponent()) {
                String name = cc.getCellName();
                if (name.length() <= 0) continue;
                clazz.append(delim);
                clazz.append(name);
                delim = " ";
            }
            if (clazz.length() > 0) {
                attrs.put("class", clazz.toString());
            }
        }
        if (!attrs.isEmpty()) {
            w.key(DIV_ATTRIBUTES).object();
            for (Map.Entry e : attrs.entrySet()) {
                w.key((String)e.getKey()).value(e.getValue());
            }
            w.endObject();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ComponentFilter {
        SiteCatalyst{

            public boolean include(com.day.cq.wcm.api.components.Component c, ResourceResolver resolver) {
                return resolver.getResource(c.getPath() + "/analytics") != null;
            }
        }
        ,
        TestAndTarget{

            public boolean include(com.day.cq.wcm.api.components.Component c, ResourceResolver resolver) {
                return SiteCatalyst.include(c, resolver) && (resolver.getResource(c.getPath() + "/target") != null || c.getPath().contains("cq/personalization/components/contextstores"));
            }
        };


        public static ComponentFilter fromRequest(HttpServletRequest request) {
            String mode = request.getParameter("mode");
            if (mode != null && mode.equalsIgnoreCase(TestAndTarget.toString())) {
                return TestAndTarget;
            }
            return SiteCatalyst;
        }

        public abstract boolean include(com.day.cq.wcm.api.components.Component var1, ResourceResolver var2);
    }
}

