/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl.servlets;

import com.day.cq.analytics.sitecatalyst.SitecatalystException;
import com.day.cq.analytics.sitecatalyst.SitecatalystWebservice;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Properties(value={@Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.paths", value={"/libs/cq/analytics/deeplink"}), @Property(name="sling.servlet.methods", value={"GET"})})
public class SitecatalystDeepLinkServlet
extends SlingAllMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String PARAM_CONFIG = "cfgPath";
    private static final String PARAM_PATH = "path";
    @Reference
    ConfigurationManager cfgMgr;
    @Reference
    SitecatalystWebservice sitecatalystService;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            JSONWriter writer = new JSONWriter((Writer)response.getWriter());
            String pageId = "";
            String cfgPath = request.getParameter(PARAM_CONFIG);
            Configuration cfg = this.cfgMgr.getConfiguration(cfgPath);
            if (cfg != null) {
                pageId = this.findPageId(cfg, request);
            }
            writer.object();
            writer.key("pageid").value((Object)pageId);
            writer.endObject();
        }
        catch (JSONException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private String findPageId(Configuration config, SlingHttpServletRequest request) {
        String pagePath = request.getParameter(PARAM_PATH);
        JSONArray pages = this.getReportsuitePages(config, pagePath);
        if (pages != null) {
            String url = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
            url = url + pagePath;
            for (int i = 0; i < pages.length(); ++i) {
                try {
                    JSONObject page = pages.getJSONObject(i);
                    if (url.equals(page.get("url"))) {
                        return page.getString("id");
                    }
                    continue;
                }
                catch (JSONException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    private JSONArray getReportsuitePages(Configuration config, String pagePath) {
        try {
            if (pagePath == null) {
                return null;
            }
            String reportsuite = (String)config.getInherited("reportsuite", null);
            String pagename = pagePath.replaceAll(".*/(.*?)\\..*", "$1");
            String json = this.sitecatalystService.getPages(config, (Integer)100, pagename, reportsuite, (Integer)1);
            JSONArray response = new JSONArray(json);
            JSONObject page = response.getJSONObject(0);
            return page.getJSONArray("pages");
        }
        catch (SitecatalystException e) {
            this.log.error("Fetching pages for reportsuite failed", (Throwable)e);
        }
        catch (JSONException e) {
            this.log.error("Could not create JSONObject", (Throwable)e);
        }
        return null;
    }

    protected void bindCfgMgr(ConfigurationManager configurationManager) {
        this.cfgMgr = configurationManager;
    }

    protected void unbindCfgMgr(ConfigurationManager configurationManager) {
        if (this.cfgMgr == configurationManager) {
            this.cfgMgr = null;
        }
    }

    protected void bindSitecatalystService(SitecatalystWebservice sitecatalystWebservice) {
        this.sitecatalystService = sitecatalystWebservice;
    }

    protected void unbindSitecatalystService(SitecatalystWebservice sitecatalystWebservice) {
        if (this.sitecatalystService == sitecatalystWebservice) {
            this.sitecatalystService = null;
        }
    }
}

