/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl.servlets;

import com.day.cq.analytics.sitecatalyst.SitecatalystException;
import com.day.cq.analytics.sitecatalyst.SitecatalystWebservice;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Properties(value={@Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.paths", value={"/libs/cq/analytics/sitecatalyst/service"}), @Property(name="sling.servlet.methods", value={"POST"})})
public class SitecatalystServlet
extends SlingAllMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String PARAMETER_METHOD = "method";
    private static final String PARAMETER_CONFIG_PATH = "configPath";
    private static final String PARAMETER_COMPANY = "company";
    private static final String PARAMETER_USERNAME = "username";
    private static final String PARAMETER_PASSWORD = "password";
    private static final String PARAMETER_RSID = "rsid";
    @Reference
    private ConfigurationManager configManager;
    @Reference
    protected SitecatalystWebservice catalystService;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();
        String method = request.getParameter(PARAMETER_METHOD);
        try {
            if ("Connect".equals(method)) {
                this.handleConnect(request, out);
            } else {
                this.handleAPICall(request, out, method);
            }
        }
        catch (SitecatalystException e) {
            this.log.error("Call to SiteCatalyst method '" + request.getParameter(PARAMETER_METHOD) + "' failed", (Throwable)e);
            out.write("{error: '" + e.getMessage() + "'}");
        }
        catch (Exception e) {
            this.log.error("Exception occured while calling Sitecatalyst service", (Throwable)e);
            throw new ServletException("Exception occured while calling Sitecatalyst service", (Throwable)e);
        }
        finally {
            out.flush();
        }
    }

    private void handleConnect(SlingHttpServletRequest request, Writer out) throws Exception {
        String jsonResponse = "{}";
        String company = request.getParameter(PARAMETER_COMPANY);
        String username = request.getParameter(PARAMETER_USERNAME);
        String password = request.getParameter(PARAMETER_PASSWORD);
        try {
            String secret = this.catalystService.getLoginKey(company, username, password);
            JSONObject json = new JSONObject();
            if (password != null) {
                json.put("secret", (Object)secret);
            }
            jsonResponse = json.toString();
        }
        catch (JSONException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        out.write(jsonResponse);
    }

    private void handleAPICall(SlingHttpServletRequest request, Writer out, String method) throws Exception {
        String jsonResponse = "{}";
        String rsid = request.getParameter(PARAMETER_RSID);
        String configPath = request.getParameter(PARAMETER_CONFIG_PATH);
        Configuration configuration = this.configManager.getConfiguration(configPath);
        if (configuration == null) {
            throw new SitecatalystException("Configuration has not been found");
        }
        if (rsid == null) {
            rsid = (String)configuration.getInherited("reportsuite", (Object)"");
        }
        if (method.equals("Company.GetReportSuites")) {
            jsonResponse = this.catalystService.getReportSuites(configuration);
        } else if (method.equals("Company.GetTrackingServer")) {
            String[] rsidArray = rsid.split(",");
            if (rsidArray.length > 0) {
                jsonResponse = this.catalystService.getTrackingServer(configuration, rsidArray[0]);
            }
        } else if (method.equals("ReportSuite.GetEVars")) {
            jsonResponse = this.catalystService.getEvars(configuration, rsid);
        } else if (method.equals("ReportSuite.GetTrafficVars")) {
            jsonResponse = this.catalystService.getTrafficVars(configuration, rsid);
        } else if (method.equals("ReportSuite.GetSuccessEvents")) {
            jsonResponse = this.catalystService.getSuccessEvents(configuration, rsid);
        }
        out.write(jsonResponse);
    }

    private void saveConfiguration(Configuration configuration) {
        try {
            Session session;
            Resource resource = configuration.getResource();
            if (resource != null && (session = ((Node)resource.adaptTo(Node.class)).getSession()).hasPendingChanges()) {
                session.save();
            }
        }
        catch (RepositoryException e) {
            this.log.error("Could not save updated configuration", (Throwable)e);
        }
    }

    protected void bindConfigManager(ConfigurationManager configurationManager) {
        this.configManager = configurationManager;
    }

    protected void unbindConfigManager(ConfigurationManager configurationManager) {
        if (this.configManager == configurationManager) {
            this.configManager = null;
        }
    }

    protected void bindCatalystService(SitecatalystWebservice sitecatalystWebservice) {
        this.catalystService = sitecatalystWebservice;
    }

    protected void unbindCatalystService(SitecatalystWebservice sitecatalystWebservice) {
        if (this.catalystService == sitecatalystWebservice) {
            this.catalystService = null;
        }
    }
}

