/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl.servlets;

import com.day.cq.analytics.sitecatalyst.Framework;
import com.day.cq.analytics.sitecatalyst.FrameworkComponent;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Properties(value={@Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.paths", value={"/libs/cq/analytics/scviewinfo"}), @Property(name="service.description", value={"Servlet providing filtered variable mappings."}), @Property(name="sling.servlet.methods", value={"GET"})})
public class SitecatalystViewInfoServlet
extends SlingAllMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String CQ_COMPONENT_NAME = "cq:componentName";
    private static final String CQ_COMPONENT_ICON = "cq:componentIcon";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Resource resource = request.getResource();
        ResourceResolver resourceResolver = resource.getResourceResolver();
        String path = request.getParameter("path");
        ValueMap props = (ValueMap)request.getResource().adaptTo(ValueMap.class);
        Long expiryTime = (Long)props.get("expiryTime", (Object)120L) * 60L * 1000L;
        if (expiryTime > 0L) {
            response.setDateHeader("Expires", System.currentTimeMillis() + expiryTime);
        }
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        JSONWriter writer = new JSONWriter((Writer)response.getWriter());
        try {
            writer.object();
            if (path != null) {
                FrameworkComponent component;
                Framework fw = (Framework)resourceResolver.getResource(path).adaptTo(Framework.class);
                Map<String, FrameworkComponent> allComponents = fw.getAllComponents();
                writer.key("variableMappings").array();
                for (Map.Entry<String, FrameworkComponent> entry : allComponents.entrySet()) {
                    component = entry.getValue();
                    MultiValueMap cqMappings = component.getCqMappings();
                    for (Object cqVar : cqMappings.keySet()) {
                        String scVarList = cqMappings.get(cqVar).toString();
                        for (String scVar : scVarList.split(",")) {
                            writer.object();
                            writer.key("scVar").value((Object)scVar);
                            writer.key("cqVar").value(cqVar);
                            writer.key("componentFrameworkPath").value((Object)component.getPath());
                            writer.endObject();
                        }
                    }
                }
                writer.endArray();
                writer.key("cqVars").object();
                for (Map.Entry<String, FrameworkComponent> entry : allComponents.entrySet()) {
                    component = entry.getValue();
                    String componentPath = component.getPath();
                    writer.key(componentPath).array();
                    for (String trackedVarEvent : component.getTrackedVarsEvents()) {
                        writer.value((Object)trackedVarEvent);
                    }
                    writer.endArray();
                }
                writer.endObject();
                writer.key("componentFrameworkPathMap").object();
                for (Map.Entry<String, FrameworkComponent> entry : allComponents.entrySet()) {
                    component = entry.getValue();
                    writer.key(component.getPath()).object();
                    writer.key("name").value(component.get(CQ_COMPONENT_NAME));
                    writer.key("icon").value(component.get(CQ_COMPONENT_ICON));
                    writer.endObject();
                }
                writer.endObject();
            }
            writer.endObject();
        }
        catch (JSONException e) {
            ServletException se = new ServletException("Error creating component mappings json response", (Throwable)e);
            se.initCause((Throwable)e);
            this.log.debug(se.toString());
            throw se;
        }
    }
}

